<?php

defined( 'ABSPATH' ) || exit;

/**
 * Themify icon font
 */
class Themify_Icon_Themify extends Themify_Icon_Font {

    function get_id() {
	return 'ti';
    }

    function get_label() {
	return __('Themify', 'themify');
    }

    public function __construct() {
	parent::__construct();
    }

    /**
     * Check if the icon name belongs to the Themify icon font
     * Assumes yes, if the icon name has "ti-" prefix
     *
     * @return bool
     */
    function is_valid_icon($name) {
	return strpos($name, 'ti-') === 0;
    }

    function get_classname($icon, $lazy = false, $data_only = false,$attrs=array()) {
	$icon = str_replace('ti-', '', $icon);
	$k = 'ti-' . $icon;
	if (!isset(self::$usedIcons[$k])) {
	    $fonts = self::ti();
	    if (isset($fonts[$icon])) {
		self::$usedIcons[$k] = array('p' => $fonts[$icon]);
	    }
	    $fonts = null;
	}

	if ($data_only === true) {
	    return self::$usedIcons[$k];
	}
	return '<svg '.parent::svg_attributes($attrs).' class="tf_fa tf-' . $k . '"><use href="#tf-' . $k . '"></use></svg>';
    }

    function get_categories() {
	$icons = self::get_icons();
	$res = array();
	foreach ($icons as $k => $v) {
	    $res[$k] = $v['label'];
	}
	return $res;
    }

    public function get_icons_by_category($cat = '') {
	$icons = self::get_icons();
	if ($cat === '' || isset($icons[$cat])) {
	    $id = $this->get_id() . '-';
	    if ($cat !== '') {
		$icons = array($cat => $icons[$cat]);
	    }
	    $res = array();
	    foreach ($icons as $k => $v) {
		$res[$k] = array();
		foreach ($v['icons'] as $ic) {
		    $res[$k][$id . $ic] = $ic;
		}
	    }
	    return $res;
	}
	return array();
    }

    private static function get_icons() {
	return array(
	    'arrows' => array(
		'label' => __('Arrows', 'themify'),
		'icons' => array(
		    'arrow-up',
		    'arrow-right',
		    'arrow-left',
		    'arrow-down',
		    'arrows-vertical',
		    'arrows-horizontal',
		    'angle-up',
		    'angle-right',
		    'angle-left',
		    'angle-down',
		    'angle-double-up',
		    'angle-double-right',
		    'angle-double-left',
		    'angle-double-down',
		    'move',
		    'fullscreen',
		    'arrow-top-right',
		    'arrow-top-left',
		    'arrow-circle-up',
		    'arrow-circle-right',
		    'arrow-circle-left',
		    'arrow-circle-down',
		    'arrows-corner',
		    'split-v',
		    'split-v-alt',
		    'split-h',
		    'hand-point-up',
		    'hand-point-right',
		    'hand-point-left',
		    'hand-point-down',
		    'back-right',
		    'back-left',
		    'exchange-vertical',
		)
	    ),
	    'web' => array(
		'label' => __('Web App', 'themify'),
		'icons' => array(
		    'wand',
		    'save',
		    'save-alt',
		    'direction',
		    'direction-alt',
		    'user',
		    'link',
		    'unlink',
		    'trash',
		    'target',
		    'tag',
		    'desktop',
		    'tablet',
		    'mobile',
		    'email',
		    'star',
		    'spray',
		    'signal',
		    'shopping-cart',
		    'shopping-cart-full',
		    'settings',
		    'search',
		    'zoom-in',
		    'zoom-out',
		    'cut',
		    'ruler',
		    'ruler-alt-2',
		    'ruler-pencil',
		    'ruler-alt',
		    'bookmark',
		    'bookmark-alt',
		    'reload',
		    'plus',
		    'minus',
		    'close',
		    'pin',
		    'pencil',
		    'pencil-alt',
		    'paint-roller',
		    'paint-bucket',
		    'na',
		    'medall',
		    'medall-alt',
		    'marker',
		    'marker-alt',
		    'lock',
		    'unlock',
		    'location-arrow',
		    'layout',
		    'layers',
		    'layers-alt',
		    'key',
		    'image',
		    'heart',
		    'heart-broken',
		    'hand-stop',
		    'hand-open',
		    'hand-drag',
		    'flag',
		    'flag-alt',
		    'flag-alt-2',
		    'eye',
		    'import',
		    'export',
		    'cup',
		    'crown',
		    'comments',
		    'comment',
		    'comment-alt',
		    'thought',
		    'clip',
		    'check',
		    'check-box',
		    'camera',
		    'announcement',
		    'brush',
		    'brush-alt',
		    'palette',
		    'briefcase',
		    'bolt',
		    'bolt-alt',
		    'blackboard',
		    'bag',
		    'world',
		    'wheelchair',
		    'car',
		    'truck',
		    'timer',
		    'ticket',
		    'thumb-up',
		    'thumb-down',
		    'stats-up',
		    'stats-down',
		    'shine',
		    'shift-right',
		    'shift-left',
		    'shift-right-alt',
		    'shift-left-alt',
		    'shield',
		    'notepad',
		    'server',
		    'pulse',
		    'printer',
		    'power-off',
		    'plug',
		    'pie-chart',
		    'panel',
		    'package',
		    'music',
		    'music-alt',
		    'mouse',
		    'mouse-alt',
		    'money',
		    'microphone',
		    'menu',
		    'menu-alt',
		    'map',
		    'map-alt',
		    'location-pin',
		    'light-bulb',
		    'info',
		    'infinite',
		    'id-badge',
		    'hummer',
		    'home',
		    'help',
		    'headphone',
		    'harddrives',
		    'harddrive',
		    'gift',
		    'game',
		    'filter',
		    'files',
		    'file',
		    'zip',
		    'folder',
		    'envelope',
		    'dashboard',
		    'cloud',
		    'cloud-up',
		    'cloud-down',
		    'clipboard',
		    'calendar',
		    'book',
		    'bell',
		    'basketball',
		    'bar-chart',
		    'bar-chart-alt',
		    'archive',
		    'anchor',
		    'alert',
		    'alarm-clock',
		    'agenda',
		    'write',
		    'wallet',
		    'video-clapper',
		    'video-camera',
		    'vector',
		    'support',
		    'stamp',
		    'slice',
		    'shortcode',
		    'receipt',
		    'pin2',
		    'pin-alt',
		    'pencil-alt2',
		    'eraser',
		    'more',
		    'more-alt',
		    'microphone-alt',
		    'magnet',
		    'line-double',
		    'line-dotted',
		    'line-dashed',
		    'ink-pen',
		    'info-alt',
		    'help-alt',
		    'headphone-alt',
		    'gallery',
		    'face-smile',
		    'face-sad',
		    'credit-card',
		    'comments-smiley',
		    'time',
		    'share',
		    'share-alt',
		    'rocket',
		    'new-window',
		    'rss',
		    'rss-alt',
		)
	    ),
	    'control' => array(
		'label' => __('Controls', 'themify'),
		'icons' => array(
		    'control-stop',
		    'control-shuffle',
		    'control-play',
		    'control-pause',
		    'control-forward',
		    'control-backward',
		    'volume',
		    'control-skip-forward',
		    'control-skip-backward',
		    'control-record',
		    'control-eject',
		)
	    ),
	    'text-editor' => array(
		'label' => __('Editor', 'themify'),
		'icons' => array(
		    'paragraph',
		    'uppercase',
		    'underline',
		    'text',
		    'Italic',
		    'smallcap',
		    'list',
		    'list-ol',
		    'align-right',
		    'align-left',
		    'align-justify',
		    'align-center',
		    'quote-right',
		    'quote-left',
		)
	    ),
	    'layout' => array(
		'label' => __('Layouts', 'themify'),
		'icons' => array(
		    'layout-width-full',
		    'layout-width-default',
		    'layout-width-default-alt',
		    'layout-tab',
		    'layout-tab-window',
		    'layout-tab-v',
		    'layout-tab-min',
		    'layout-slider',
		    'layout-slider-alt',
		    'layout-sidebar-right',
		    'layout-sidebar-none',
		    'layout-sidebar-left',
		    'layout-placeholder',
		    'layout-menu',
		    'layout-menu-v',
		    'layout-menu-separated',
		    'layout-menu-full',
		    'layout-media-right',
		    'layout-media-right-alt',
		    'layout-media-overlay',
		    'layout-media-overlay-alt',
		    'layout-media-overlay-alt-2',
		    'layout-media-left',
		    'layout-media-left-alt',
		    'layout-media-center',
		    'layout-media-center-alt',
		    'layout-list-thumb',
		    'layout-list-thumb-alt',
		    'layout-list-post',
		    'layout-list-large-image',
		    'layout-line-solid',
		    'layout-grid4',
		    'layout-grid3',
		    'layout-grid2',
		    'layout-grid2-thumb',
		    'layout-cta-right',
		    'layout-cta-left',
		    'layout-cta-center',
		    'layout-cta-btn-right',
		    'layout-cta-btn-left',
		    'layout-column4',
		    'layout-column3',
		    'layout-column2',
		    'layout-accordion-separated',
		    'layout-accordion-merged',
		    'layout-accordion-list',
		    'widgetized',
		    'widget',
		    'widget-alt',
		    'view-list',
		    'view-list-alt',
		    'view-grid',
		    'upload',
		    'download',
		    'loop',
		    'layout-sidebar-2',
		    'layout-grid4-alt',
		    'layout-grid3-alt',
		    'layout-grid2-alt',
		    'layout-column4-alt',
		    'layout-column3-alt',
		    'layout-column2-alt',
		)
	    ),
	    'brand' => array(
		'label' => __('Brands', 'themify'),
		'icons' => array(
		    'flickr',
		    'flickr-alt',
		    'instagram',
		    'google',
		    'github',
		    'facebook',
		    'dropbox',
		    'dropbox-alt',
		    'dribbble',
		    'apple',
		    'android',
		    'yahoo',
		    'trello',
		    'stack-overflow',
		    'soundcloud',
		    'sharethis',
		    'sharethis-alt',
		    'reddit',
		    'microsoft',
		    'microsoft-alt',
		    'linux',
		    'jsfiddle',
		    'joomla',
		    'html5',
		    'css3',
		    'drupal',
		    'wordpress',
		    'tumblr',
		    'tumblr-alt',
		    'skype',
		    'youtube',
		    'vimeo',
		    'vimeo-alt',
		    'twitter',
		    'twitter-alt',
		    'linkedin',
		    'pinterest',
		    'pinterest-alt',
		    'themify-logo',
		    'themify-favicon',
		    'themify-favicon-alt',
		)
	    )
	);
    }

    public static function ti() {
	return array(
	    'wand' => 'M32 9.438V7.5h-6.188l4.313-4.25-1.375-1.375-4.25 4.313V0h-1.938v6.188l-4.375-4.375-1.313 1.313 4.375 4.375h-6.188v1.938h6.188L1.186 29.502l1.375 1.313 20-20.063v6.188h1.938v-6.188l4.375 4.375 1.313-1.313-4.375-4.375H32z',
	    'volume' => 'M6.75 11.188h3.375L20.75.375v30.938L10.062 20.625H6.749c-.75 0-1.5-.313-2.063-.875s-.875-1.25-.875-2.063v-4.063c0-1.5 1.125-2.438 2.938-2.438zM18.875 5l-7.938 8.063H6.749c-1.063 0-1.063.375-1.063.563v4.063c0 .563.5 1.063 1.063 1.063h4.063l8.063 8V5.002zm3.75 15.688c2.063 0 3.75-1.688 3.75-3.813 0-2.063-1.688-3.75-3.75-3.75V15c1 0 1.875.875 1.875 1.875 0 1.063-.875 1.938-1.875 1.938v1.875zm7.563-3.75c0-4.188-3.375-7.563-7.563-7.563v1.875c3.125 0 5.688 2.563 5.688 5.688 0 3.063-2.563 5.625-5.688 5.625v1.875c4.188 0 7.563-3.375 7.563-7.5z',
	    'user' => 'M32 31.063v.938H0v-.938c.125-5.125 5.313-9.5 12.438-10.625v-2.375c-1-.938-1.75-2.438-2.188-3.75-.563-.313-1.063-.875-1.438-1.688-.625-1.375-.438-2.688.375-3.25-.063-.375-.063-.813-.063-1.188v-.688c-.063-2.125-.063-4.813 3.125-5.125 0 0 .125-.125.188-.25.5-1 1.25-2 3.688-2.125h.5c3.563 0 6 1.313 6.813 3.688.25.688 0 1.313-.188 1.813-.25.625-.5 1.313-.375 2.563.063.438 0 .938 0 1.375.625.563.813 1.75.375 3.063-.313.938-.875 1.625-1.5 1.938-.438 1.188-1.125 2.563-2 3.438v2.625c7 1.125 12.125 5.5 12.25 10.563zm-30-.938h28C29.312 26.25 24.687 23 18.687 22.25l-.875-.125V17l.375-.313c.688-.5 1.375-1.688 1.938-3.313l.188-.625h.688c0-.063.25-.313.438-.875.125-.375.188-.688.188-.875l-.875.063.188-1.5c.063-.438.125-.938.063-1.25-.188-1.75.188-2.813.5-3.5.063-.188.125-.438.125-.5-.688-2.125-3.438-2.438-5-2.438h-.438c-1.563.063-1.813.563-2.063 1.125-.25.438-.625 1.188-1.688 1.25-1.375.125-1.5.688-1.438 3.188v.75c0 .563.063 1.188.125 1.813l.188 1.375-1-.25c.063.188.125.438.25.75.188.563.5.813.625.813l.563.125.125.5c.563 1.688 1.313 3 2.063 3.5l.375.25v5.063l-.813.063c-6.125.75-10.75 4-11.5 7.938z',
	    'unlock' => 'M17.875 20.625c0-1-.813-1.875-1.875-1.875s-1.875.875-1.875 1.875c0 .75.375 1.313.938 1.625v4.063h1.875V22.25c.563-.313.938-.938.938-1.625zm10.375-4.687c0-1.563-1.313-2.813-2.813-2.813v-3.75c0-5.188-4.25-9.438-9.438-9.438s-9.438 4.25-9.438 9.438h1.938c0-4.188 3.375-7.563 7.5-7.563s7.5 3.375 7.5 7.563v3.75H6.624c-1.563 0-2.875 1.25-2.875 2.813v13.313c0 1.563 1.313 2.813 2.875 2.813h18.75c1.563 0 2.875-1.25 2.875-2.813V15.938zm-1.937 0v13.313c0 .5-.375.938-.938.938H6.625c-.563 0-.938-.438-.938-.938V15.938c0-.563.375-.938.938-.938h18.75c.563 0 .938.375.938.938z',
	    'unlink' => 'M4 9.688c-2 3-1.125 7.125 1.875 9.125 1.188.75 2.438 1.125 3.688 1.125 1.875 0 3.625-.813 5.063-2.5l-1.438-1.25c-1.75 2.063-4.125 2.438-6.25 1.063-2.188-1.438-2.75-4.375-1.313-6.625L8.25 5.751c1.438-2.125 4.375-2.75 6.563-1.313l1-1.563c-3-2-7.125-1.188-9.188 1.938zm3.625 5.437c2.563-2.563 6.75-2.563 9.313 0s2.563 6.75 0 9.313l-5.688 5.688c-1.313 1.313-3 1.938-4.688 1.938s-3.375-.625-4.625-1.938c-2.563-2.563-2.563-6.75 0-9.313l1.938-2 1.375 1.313-2 2c-1.813 1.875-1.813 4.813 0 6.688 1.813 1.813 4.813 1.813 6.625 0l5.688-5.688c1.875-1.875 1.875-4.813 0-6.688-1.813-1.813-4.813-1.813-6.625 0l-.25.25-1.313-1.313zm13-1.937v-1.875h7.688v1.875h-7.688zm-.875 2.5l.938-1.625 3.688 2.125-.938 1.625zm.5-13.5l1.625.938-3 5.125-1.625-.938zm9.625 2.937L20.5 10.563l-1-1.625L28.938 3.5z',
	    'trash' => 'M20.563 3.813h6.75v1.875H6.563V3.813h6.75c.438-1.688 1.875-2.875 3.625-2.875s3.25 1.25 3.625 2.875zm-3.625-1c-.688 0-1.313.438-1.625 1h3.25c-.313-.563-.875-1-1.625-1zM24.5 7.5v19.813c0 .5-.438.938-1 .938H10.375c-.563 0-.938-.438-.938-.938V7.5H7.499v19.813c0 1.563 1.313 2.813 2.875 2.813h13.125c1.563 0 2.875-1.25 2.875-2.813V7.5h-1.875zm-9.437 1.938h-1.875v15.063h1.875V9.438zm5.625 0h-1.875v15.063h1.875V9.438z',
	    'thought' => 'M21.625 19.063c-.813 0-1.688-.125-2.625-.375-1.25 1.313-3 2-4.875 2-1.688 0-3.375-.625-4.563-1.688-.375 0-.75.063-1.063.063-4.688 0-8.5-3.5-8.5-7.813s3.813-7.813 8.5-7.813c1.5 0 3 .375 4.313 1.125 1.875-2.813 5.25-4.563 8.813-4.563 5.75 0 10.375 4.25 10.375 9.5s-4.625 9.563-10.375 9.563zm-3.312-2.5l.625.188c1 .25 1.875.438 2.688.438 4.688 0 8.5-3.438 8.5-7.688 0-4.188-3.813-7.625-8.5-7.625-3.25 0-6.25 1.75-7.625 4.438l-.5 1-.938-.625C11.375 5.751 9.938 5.314 8.5 5.314c-3.688 0-6.625 2.688-6.625 5.938S4.813 17.19 8.5 17.19c.375 0 .813-.063 1.188-.125l.5-.125.375.375c.875.938 2.188 1.5 3.563 1.5 1.5 0 2.938-.625 3.813-1.75zm3.312 3.187c2.125 0 3.813 1.688 3.813 3.75 0 2.125-1.688 3.813-3.813 3.813-2.063 0-3.75-1.688-3.75-3.813 0-2.063 1.688-3.75 3.75-3.75zm0 5.688c1.063 0 1.875-.875 1.875-1.938 0-1-.813-1.875-1.875-1.875-1 0-1.875.875-1.875 1.875 0 1.063.875 1.938 1.875 1.938zm7.063.937c1.313 0 2.375 1.063 2.375 2.313 0 1.313-1.063 2.375-2.375 2.375-1.25 0-2.313-1.063-2.313-2.375 0-1.25 1.063-2.313 2.313-2.313zm-.438 2.313c0 .563.938.563.938 0 0-.25-.25-.438-.5-.438s-.438.188-.438.438z',
	    'target' => 'M32.063 15.063v1.875h-3.875c-.438 6-5.313 10.813-11.313 11.25v3.813H15v-3.813c-5.938-.5-10.75-5.25-11.188-11.25H-.063v-1.875h3.875c.438-6 5.25-10.75 11.188-11.25V-.062h1.875v3.875c6.063.438 10.875 5.25 11.313 11.25h3.875zm-15.188 11.25c5-.438 9-4.375 9.438-9.375h-3.688v-1.875h3.688c-.438-5-4.438-8.938-9.438-9.375v3.625H15V5.688c-4.938.5-8.875 4.438-9.313 9.375h3.688v1.875H5.687c.438 4.938 4.375 8.875 9.313 9.375v-3.75h1.875v3.75z',
	    'tag' => 'M16.875 1.875L24.5 7.313v22.875l-7.625-5.25-7.5 5.25V7.313zm5.75 24.688V8.313l-5.75-4.125-5.625 4.063v18.313l5.625-3.938zm-9-15.25C13.625 9.5 15.125 8 16.938 8s3.313 1.5 3.313 3.313-1.5 3.25-3.313 3.25-3.313-1.438-3.313-3.25zm3.313-1.438c-.75 0-1.375.625-1.375 1.438 0 .75.625 1.375 1.375 1.375.813 0 1.438-.625 1.438-1.375 0-.813-.625-1.438-1.438-1.438z',
	    'tablet' => 'M17.438 27.313c0-.813-.688-1.438-1.438-1.438s-1.438.625-1.438 1.438c0 .75.688 1.375 1.438 1.375s1.438-.625 1.438-1.375zm12.687-24.5C30.125 1.25 28.937 0 27.5 0h-23C3.062 0 1.875 1.25 1.875 2.813v26.375c0 1.563 1.188 2.813 2.625 2.813h23c1.438 0 2.625-1.25 2.625-2.813V2.813zm-1.875 0v26.375c0 .5-.375.938-.75.938h-23c-.375 0-.75-.438-.75-.938V2.813c0-.5.375-.938.75-.938h23c.375 0 .75.438.75.938zM5.625 3.75V24.5h20.75V3.75H5.625zM7.5 22.563V5.625h17v16.938h-17z',
	    'star' => 'M31.313 13.188l-9.438 6.938L25.5 31.251 16 24.376l-9.5 6.875 3.625-11.125-9.438-6.938h11.688L16 2.063l3.625 11.125h11.688zm-9.438 13.125l-2.25-6.938 5.938-4.313H18.25L16 8.124l-2.25 6.938H6.437l5.938 4.313-2.25 6.938L16 22z',
	    'spray' => 'M12.25 5.625c2.688 0 5.125 1.5 6.5 3.813h1.938v19.75c0 1.563-1.25 2.813-2.813 2.813H6.562c-1.5 0-2.813-1.25-2.813-2.813V9.438h2c1.313-2.313 3.813-3.813 6.5-3.813zm0 1.875c-1.625 0-3.188.75-4.188 1.938h8.375C15.374 8.25 13.874 7.5 12.249 7.5zm6.563 21.688V11.313H5.625v17.875c0 .5.438.938.938.938h11.313c.5 0 .938-.438.938-.938zM15.063 0v5.625H9.438V0h5.625zm-1.875 3.75V1.875h-1.875V3.75h1.875zm9.312-.875l5.875-1L28.062 0l-11.25 1.875.125 1-.125.938 11.25 1.875.313-1.875z',
	    'signal' => 'M21.625 7.5c0 2.813-2 5.125-4.688 5.563v15.188h3.75v1.875h-9.375v-1.875h3.75V13.063c-2.688-.438-4.688-2.75-4.688-5.563 0-3.063 2.5-5.625 5.625-5.625s5.625 2.563 5.625 5.625zm-9.375 0c0 2.125 1.688 3.813 3.75 3.813s3.75-1.688 3.75-3.813c0-2.063-1.688-3.75-3.75-3.75s-3.75 1.688-3.75 3.75zM8.5 4.125L7 2.937c-.938 1.188-1.5 2.625-1.5 4.125 0 1.563.563 3 1.5 4.188l1.5-1.188c-.75-.875-1.125-1.875-1.125-3 0-1.063.375-2.063 1.125-2.938zM3.75 7.063c0-2 .75-3.938 2.125-5.5L4.437.313c-1.625 1.938-2.563 4.313-2.563 6.75 0 2.5.938 4.875 2.563 6.813l1.438-1.25C4.5 11.063 3.75 9.126 3.75 7.063zm22.75 0c0-1.5-.563-2.938-1.5-4.125l-1.5 1.188c.75.875 1.125 1.875 1.125 2.938 0 1.125-.375 2.125-1.125 3l1.5 1.188c.938-1.188 1.5-2.625 1.5-4.188zm3.625 0c0-2.438-.938-4.813-2.563-6.75l-1.438 1.25c1.375 1.563 2.125 3.5 2.125 5.5 0 2.063-.75 4-2.125 5.563l1.438 1.25c1.625-1.938 2.563-4.313 2.563-6.813z',
	    'shopping-cart' => 'M5.188 23.5c1.813 0 3.313 1.5 3.313 3.313s-1.5 3.313-3.313 3.313-3.313-1.5-3.313-3.313 1.5-3.313 3.313-3.313zm0 4.75c.75 0 1.375-.625 1.375-1.438 0-.75-.625-1.375-1.375-1.375-.813 0-1.438.625-1.438 1.375 0 .813.625 1.438 1.438 1.438zm16-4.75c1.813 0 3.313 1.5 3.313 3.313s-1.5 3.313-3.313 3.313-3.313-1.5-3.313-3.313 1.5-3.313 3.313-3.313zm0 4.75c.75 0 1.375-.625 1.375-1.438 0-.75-.625-1.375-1.375-1.375-.813 0-1.438.625-1.438 1.375 0 .813.625 1.438 1.438 1.438zm4-24.5h6.813v1.875h-5.188l-.5 3-1.938 14H1.937L-.126 7.5h24.75zm-.875 5.688H2l.313 1.875h21.75zM3.625 20.75H22.75l1.063-7.563H2.563z',
	    'shopping-cart-full' => 'M5.188 23.5c1.813 0 3.313 1.5 3.313 3.313s-1.5 3.313-3.313 3.313-3.313-1.5-3.313-3.313 1.5-3.313 3.313-3.313zm0 4.75c.75 0 1.375-.625 1.375-1.438 0-.75-.625-1.375-1.375-1.375-.813 0-1.438.625-1.438 1.375 0 .813.625 1.438 1.438 1.438zm16-4.75c1.813 0 3.313 1.5 3.313 3.313s-1.5 3.313-3.313 3.313-3.313-1.5-3.313-3.313 1.5-3.313 3.313-3.313zm0 4.75c.75 0 1.375-.625 1.375-1.438 0-.75-.625-1.375-1.375-1.375-.813 0-1.438.625-1.438 1.375 0 .813.625 1.438 1.438 1.438zm4-24.5h6.813v1.875h-5.188l-.438 2.938-2 14.063H1.937L-.126 7.501h24.75zm-2.438 17l1.563-11.313H2L3.625 20.75H22.75zm-2.062-1.937v-7.438h-1.875v5.563H7.5v-5.563H5.625v7.438h15.063zM7.5 5.563V3.75h11.313V5.5h1.875V1.875H5.625v3.688H7.5z',
	    'settings' => 'M16 11.25c2.625 0 4.688 2.125 4.688 4.688 0 2.625-2.063 4.688-4.688 4.688s-4.688-2.063-4.688-4.688c0-2.563 2.063-4.688 4.688-4.688zm0 7.5c1.563 0 2.813-1.25 2.813-2.813s-1.25-2.813-2.813-2.813-2.813 1.25-2.813 2.813S14.437 18.75 16 18.75zm15.875-1L27 19.25c-.188.75-.5 1.5-.875 2.125l2.375 4.5c-.75.938-1.625 1.813-2.563 2.625l-4.5-2.438c-.688.375-1.375.688-2.125.875l-1.5 4.875c-.563.063-1.188.125-1.813.125s-1.25-.063-1.813-.125l-1.5-4.875c-.75-.188-1.438-.5-2.125-.875l-4.5 2.438c-.938-.813-1.813-1.688-2.563-2.625l2.375-4.438c-.375-.688-.688-1.438-.875-2.188l-4.875-1.5c-.063-.563-.125-1.188-.125-1.813s.063-1.25.125-1.813l4.875-1.5c.188-.75.5-1.438.875-2.125l-2.375-4.5c.75-.938 1.625-1.813 2.563-2.563l4.5 2.375c.688-.375 1.375-.688 2.125-.875l1.5-4.875c.563-.063 1.188-.125 1.813-.125s1.25.063 1.813.125l1.5 4.875c.75.25 1.438.5 2.125.875l4.5-2.375c.938.75 1.813 1.625 2.563 2.563l-2.375 4.5c.375.688.688 1.375.875 2.125l4.875 1.5c.063.563.125 1.188.125 1.813s-.063 1.25-.125 1.813zm-6.375 0l4.625-1.375v-.813L26.5 14.437l-1-.25-.313-1c-.188-.625-.438-1.25-.75-1.813l-.438-.875.438-.875 1.813-3.375-.563-.563-4.25 2.25-.875-.438c-.563-.313-1.188-.563-1.813-.75l-.938-.313-.313-.938-1.125-3.688h-.75l-1.125 3.688-.313.938-.938.313c-.625.188-1.25.438-1.813.75l-.875.438-4.25-2.25-.563.563 2.25 4.25-.438.875c-.313.563-.563 1.188-.75 1.813l-.313 1-4.625 1.375v.813l4.625 1.375.313.938c.188.625.438 1.25.75 1.813l.438.875-2.25 4.25.563.563 4.25-2.25.875.5c.563.313 1.188.563 1.813.75l.938.25.313 1 1.125 3.625h.75l1.125-3.625.313-1 .938-.25c.625-.25 1.25-.438 1.813-.75l.875-.5 4.25 2.25.563-.563-1.813-3.313-.438-.938.438-.875c.313-.563.563-1.188.75-1.813z',
	    'search' => 'M31.25 29.875l-1.313 1.313-9.75-9.75c-2.125 1.875-4.938 3-7.938 3-6.75 0-12.25-5.5-12.25-12.25 0-3.25 1.25-6.375 3.563-8.688C5.875 1.25 8.937-.063 12.25-.063c6.75 0 12.25 5.5 12.25 12.25 0 3-1.125 5.813-3 7.938zm-19-7.312c5.688 0 10.313-4.688 10.313-10.375S17.938 1.813 12.25 1.813c-2.813 0-5.375 1.125-7.313 3.063-2 1.938-3.063 4.563-3.063 7.313 0 5.688 4.625 10.375 10.375 10.375z',
	    'zoom-in' => 'M31.25 29.938l-1.313 1.313-9.75-9.75c-2.125 1.875-4.938 3-7.938 3-6.75 0-12.25-5.5-12.25-12.25 0-3.313 1.25-6.375 3.563-8.688S8.937 0 12.25 0C19 0 24.5 5.5 24.5 12.25c0 3-1.125 5.813-3 7.938zm-19-7.375c5.688 0 10.313-4.625 10.313-10.313 0-5.75-4.625-10.375-10.313-10.375-2.813 0-5.375 1.063-7.313 3.063-2 1.938-3.063 4.5-3.063 7.313 0 5.688 4.625 10.313 10.375 10.313zm.938-11.25V7.5h-1.875v3.813H7.5v1.875h3.813v3.75h1.875v-3.75h3.75v-1.875h-3.75z',
	    'zoom-out' => 'M31.25 29.875l-1.313 1.313-9.75-9.75c-2.125 1.875-4.938 3-7.938 3-6.75 0-12.25-5.5-12.25-12.25 0-3.25 1.25-6.375 3.563-8.688C5.875 1.25 8.937-.063 12.25-.063c6.75 0 12.25 5.5 12.25 12.25 0 3-1.125 5.813-3 7.938zm-19-7.312c5.688 0 10.313-4.688 10.313-10.375S17.938 1.813 12.25 1.813c-2.813 0-5.375 1.125-7.313 3.063-2 1.938-3.063 4.563-3.063 7.313 0 5.688 4.625 10.375 10.375 10.375zM7.5 11.25v1.875h9.438V11.25H7.5z',
	    'cut' => 'M24.5 20.688c3.063 0 5.625 2.563 5.625 5.688 0 3.063-2.563 5.625-5.625 5.625-3.125 0-5.688-2.563-5.688-5.625 0-1.438.563-2.688 1.375-3.688l-4.188-4.438-4.188 4.438c.813 1 1.375 2.25 1.375 3.688 0 3.063-2.563 5.625-5.688 5.625-3.063 0-5.625-2.563-5.625-5.625 0-3.125 2.563-5.688 5.625-5.688 1.063 0 2 .313 2.813.813l4.375-4.625L2.936 4.438l1.375-1.313L15.999 15.5 27.687 3.125l1.375 1.313-11.75 12.438 4.375 4.625c.813-.5 1.75-.813 2.813-.813zm-17 9.437c2.125 0 3.813-1.688 3.813-3.75 0-2.125-1.688-3.813-3.813-3.813-2.063 0-3.75 1.688-3.75 3.813 0 2.063 1.688 3.75 3.75 3.75zm17 0c2.063 0 3.75-1.688 3.75-3.75 0-2.125-1.688-3.813-3.75-3.813-2.125 0-3.813 1.688-3.813 3.813 0 2.063 1.688 3.75 3.813 3.75z',
	    'ruler' => 'M9.438 0h13.125v32H9.438V0zm11.25 30.125V1.875h-9.375V3.75h3.75v1.875h-3.75V7.5h1.875v1.938h-1.875v1.875h3.75v1.875h-3.75v1.875h1.875v1.938h-1.875v1.813h3.75v1.875h-3.75v1.875h1.875v1.938h-1.875v1.875h3.75v1.875h-3.75v1.875h9.375z',
	    'ruler-pencil' => 'M8.438 0c1.563 0 2.813 1.25 2.813 2.813v20.063l-4.625 9.313-4.75-9.313V2.813C1.876 1.25 3.189 0 4.751 0h3.688zM4.75 1.875c-.563 0-1 .438-1 .938v1.938h5.625V2.813c0-.5-.375-.938-.938-.938H4.749zm-1 6.688h5.625V6.625H3.75v1.938zm3.688 17.812l1.938-3.938v-12H7.563v12.188H5.688V10.437H3.75v12l2.063 3.938h1.625zM15.063 0h13.188v32H15.063V0zm11.312 30.125V1.875h-9.438V3.75h3.75v1.875h-3.75V7.5h1.875v1.938h-1.875v1.875h3.75v1.875h-3.75v1.875h1.875v1.938h-1.875v1.813h3.75v1.875h-3.75v1.875h1.875v1.938h-1.875v1.875h3.75v1.875h-3.75v1.875h9.438z',
	    'ruler-alt' => 'M22.625 0L32 9.375 9.375 32 0 22.625zM2.688 22.625l6.688 6.688L29.314 9.375l-6.688-6.688L21.313 4l2.688 2.688-1.375 1.313-2.625-2.625-1.313 1.313 1.313 1.313-1.313 1.375-1.375-1.375L16 9.377l2.625 2.625-1.313 1.375-2.688-2.688-1.313 1.313 1.313 1.375-1.313 1.313-1.313-1.313-1.313 1.313 2.625 2.625-1.313 1.375-2.625-2.688-1.375 1.313 1.375 1.375-1.375 1.313-1.313-1.313-1.375 1.313 2.688 2.688-1.313 1.313-2.688-2.625z',
	    'bookmark' => 'M6.688 1.875h17.813v29.063l-9-6.125-8.813 6.188V1.876zm15.875 25.5V3.75h-14v23.625l6.938-4.813z',
	    'bookmark-alt' => 'M18.875 18.938l-5.688-3.813-5.688 3.813V0h11.375v18.938zm-9.5-3.5l3.813-2.625 3.813 2.625V1.875H9.376v13.563zm20.75-13.563h-9.438V3.75h7.563v24.5H3.75V3.75h1.875V1.875h-3.75v28.25h28.25V1.875z',
	    'reload' => 'M11.313 15.063v-1.875H3.375C4.688 7.313 9.938 3.063 16 3.063c5.75 0 10.875 3.875 12.438 9.438l1.813-.5c-1.813-6.375-7.625-10.813-14.25-10.813-6.5 0-12.188 4.313-14.125 10.313v-7.75H.001v11.313h11.313zm9.375 1.875h11.313v11.313h-1.875v-7.75c-1.938 6-7.625 10.313-14.125 10.313-6.625 0-12.438-4.438-14.25-10.813l1.813-.5c1.563 5.563 6.688 9.438 12.438 9.438 6.063 0 11.313-4.25 12.625-10.125h-7.938v-1.875z',
	    'plus' => 'M30.125 16.938v-1.875H16.937V1.875h-1.875v13.188H1.874v1.875h13.188v13.188h1.875V16.938h13.188z',
	    'pin' => 'M22.563 8.5c0 3.313-2.5 6.063-5.688 6.5v15.125H15V14.937c-3.188-.5-5.563-3.188-5.563-6.438 0-3.688 2.938-6.625 6.563-6.625s6.563 2.938 6.563 6.625zM16 13.188c2.625 0 4.688-2.125 4.688-4.688 0-2.625-2.063-4.75-4.688-4.75s-4.688 2.125-4.688 4.75c0 2.563 2.063 4.688 4.688 4.688zm2.813-3.75c0-2.125-1.688-3.813-3.75-3.813V7.5c1.063 0 1.875.875 1.875 1.938h1.875z',
	    'pencil' => 'M29.25 5.375c1.063 1.125 1.063 2.875 0 4L12.187 26.438l-9.875 3.313 3.25-9.938L22.625 2.75c1.063-1.063 2.875-1.063 3.938 0zM5.813 25l1.188 1.188 3.688-1.25-3.625-3.625zm2.375-5.187l4 3.938 10.313-10.313-3.938-4zM19.875 8.125l3.938 4 1.375-1.375-3.938-4zm8-.062c.375-.375.375-1 0-1.375L25.25 4.063c-.375-.375-.938-.375-1.313 0l-1.375 1.375 4 3.938z',
	    'pencil-alt' => 'M31.063 3.5c.5.5.813 1.188.813 1.938 0 .813-.313 1.5-.813 2L16.875 21.626 7 24.939l3.25-9.938L24.438.813c1.063-1.063 2.938-1.063 4 0zM10.5 20.25l1.188 1.188 3.625-1.25-3.625-3.625zm2.375-5.187l3.938 3.938 7.5-7.5-3.938-3.938zm8.813-8.875l4 4 1.375-1.375-4-3.938zm8.062-.063c.125-.188.25-.438.25-.688s-.125-.438-.25-.625l-2.688-2.625c-.313-.375-.938-.375-1.313 0L24.374 3.5l4 4zm-1.5 8v16H1.875v-24.5h12.25V3.75H0V32h30.125V14.125H28.25z',
	    'paint-roller' => 'M28.25 3.75h1.875v1.875H28.25v5.688H3.75V5.625h-.938c-.5 0-.938.438-.938 1v5.625c0 .5.438.938.938.938h11.313c1.563 0 2.813 1.25 2.813 2.813v2.813h1.875v13.188h-5.625V18.814h1.875v-2.813c0-.5-.438-.938-.938-.938H2.812c-1.563 0-2.813-1.25-2.813-2.813V6.625c0-1.563 1.25-2.875 2.813-2.875h.938V0h24.5v3.75zM16.938 30.125v-9.438h-1.875v9.438h1.875zm9.437-20.687V1.875H5.625v7.563h20.75z',
	    'paint-bucket' => 'M31.438 18.5h-6.75l-10.5 10.438c-.563.563-1.313.875-2.125.875s-1.563-.313-2.125-.875L.875 19.813C.312 19.25 0 18.5 0 17.688s.313-1.563.875-2.125l4.188-4.188c-1.25-1.25-1.938-2.938-1.938-4.688 0-1.813.688-3.438 1.938-4.75C6.313.687 8.001-.001 9.813-.001c1.75 0 3.438.688 4.688 1.938l.25-.25zM5 6.688c0 1.25.5 2.438 1.375 3.375l6.813-6.813c-.938-.875-2.125-1.375-3.375-1.375-1.313 0-2.5.5-3.438 1.438C5.5 4.188 5 5.376 5 6.688zm7.875 20.937l6.875-6.938H4.437l6.813 6.938c.25.188.5.313.813.313s.563-.125.813-.313zm8.75-8.812l2.25-2.188h3.063L14.75 4.375l-12.563 12.5c-.188.188-.313.5-.313.813s.125.563.313.813l.375.313h19.063zM29.5 22.5c.625.875 2.5 3.813 2.5 5.25 0 1.813-1.5 3.313-3.313 3.313s-3.25-1.5-3.25-3.313c0-1.438 1.938-4.375 2.563-5.25l.75-1.125zm-.812 6.688c.813 0 1.438-.625 1.438-1.438 0-.438-.625-1.75-1.375-3-.813 1.313-1.438 2.563-1.438 3 0 .813.625 1.438 1.375 1.438z',
	    'na' => 'M16 .938c8.313 0 15.063 6.75 15.063 15.063S24.313 31.064 16 31.064.937 24.314.937 16.001 7.687.938 16 .938zm0 1.875c-7.25 0-13.188 5.938-13.188 13.188 0 3.313 1.25 6.313 3.25 8.625L24.625 6.063c-2.313-2-5.313-3.25-8.625-3.25zm0 26.375c7.25 0 13.188-5.938 13.188-13.188 0-3.313-1.25-6.313-3.25-8.625L7.375 25.938c2.313 2 5.313 3.25 8.625 3.25z',
	    'mobile' => 'M23.5 0c1.563 0 2.875 1.25 2.875 2.813v26.375c0 1.563-1.313 2.813-2.875 2.813h-15c-1.563 0-2.875-1.25-2.875-2.813V2.813C5.625 1.25 6.938 0 8.5 0h15zm-15 1.875c-.563 0-1 .438-1 .938v2.813h17V2.813c0-.5-.438-.938-1-.938h-15zm16 5.625h-17v15.063h17V7.5zm-1 22.625c.563 0 1-.438 1-.938v-4.688h-17v4.688c0 .5.438.938 1 .938h15zm-6.562-2.812c0-.563-.438-.938-.938-.938s-.938.375-.938.938c0 .5.438.938.938.938s.938-.438.938-.938z',
	    'minus' => 'M28.25 15.063H3.75v1.875h24.5v-1.875z',
	    'medall' => 'M16 0c5.188 0 9.438 4.25 9.438 9.438 0 2.563-1.063 5-2.938 6.75-.188.188-.375.313-.563.438l-.188.188c-.313.25-.688.438-1.063.688v13.563l-4.75-3.563-4.625 3.563V17.502c-.375-.25-.75-.438-1.063-.688l-.188-.188c-.188-.125-.375-.25-.563-.438-1.875-1.75-2.938-4.188-2.938-6.75C6.559 4.25 10.809 0 15.997 0zm2.813 27.25v-7.938c-.875.313-1.875.438-2.813.438s-1.938-.125-2.813-.438v7.938l2.75-2.125zm2.375-12.375c1.5-1.438 2.313-3.375 2.313-5.438 0-4.188-3.375-7.563-7.5-7.563s-7.5 3.375-7.5 7.563c0 2.063.813 4 2.313 5.438.125.063.25.188.375.25l.25.188c2.688 2.125 6.438 2.125 9.188 0l.188-.188c.125-.063.25-.188.375-.25zm-.563-8.25l-3.688.688V3.75h-1.875v3.563l-3.563-.688-.313 1.813 3.313.688-2.125 3.625 1.563.938L16 10.251l2.063 3.438 1.625-.938L17.5 9.126l3.438-.688z',
	    'medall-alt' => 'M16 0c5.188 0 9.438 4.25 9.438 9.438 0 2.563-1.063 5-2.938 6.75-.188.188-.375.313-.563.438l-.188.188c-.313.25-.688.438-1.063.688v13.563l-4.75-3.563-4.625 3.563V17.502c-.375-.25-.75-.438-1.063-.688l-.188-.188c-.188-.125-.375-.25-.563-.438-1.875-1.75-2.938-4.188-2.938-6.75C6.559 4.25 10.809 0 15.997 0zm2.813 27.25v-7.938c-.875.313-1.875.438-2.813.438s-1.938-.125-2.813-.438v7.938l2.75-2.125zm2.375-12.375c1.5-1.438 2.313-3.375 2.313-5.438 0-4.188-3.375-7.563-7.5-7.563s-7.5 3.375-7.5 7.563c0 2.063.813 4 2.313 5.438.125.063.25.188.375.25l.25.188c2.688 2.125 6.438 2.125 9.188 0l.188-.188c.125-.063.25-.188.375-.25zm-1.875-5.437c0-1.875-1.5-3.313-3.313-3.313s-3.313 1.438-3.313 3.313c0 1.813 1.5 3.25 3.313 3.25s3.313-1.438 3.313-3.25z',
	    'marker' => 'M20.063 1.875c1.5 0 2.5 1.313 2.5 3.125v8h-1.875V5c0-.25 0-1.25-.625-1.25h-1.25v21.313l-3.5 4.375h-.25v1.25l-1.875 1.313v-2.563h-.313l-3.438-4.375V2.875c0-.938-.063-1.75.563-2.375.313-.313.75-.5 1.313-.5h4.688c1.125 0 2.188.75 2.625 1.875h1.438zm-8.75 0v7.563h5.625V3.125c0-.688-.438-1.25-.938-1.25h-4.688zM14.438 27.5l2.5-3.125V11.312h-5.625v13.063l2.5 3.125h.625z',
	    'marker-alt' => 'M29.5 10.688c.563.563.813 1.313.625 2.125-.125.688-.438 1.313-1.063 1.875l-5.625 5.688-1.375-1.313 5.688-5.688c.313-.313.5-.625.563-.875 0-.188 0-.313-.188-.5l-.813-.813-16.375 16.375-5.563.625-.188-.188-.938.875-2.25-.375 1.813-1.875-.188-.188.625-5.563 17-17c.688-.625 1.25-1.25 2.125-1.25.438 0 .875.188 1.25.563l3.313 3.313c.563.563.813 1.313.813 2.125-.063.375-.125.688-.313 1.063zM10.063 25.75l10.563-10.563-4-4L6.063 21.75l-.438 4 .438.438zM22 13.813l4.438-4.438c.25-.25.375-.563.438-.875 0-.125-.063-.438-.25-.688l-3.313-3.25c-.063 0-.438.375-.688.625L18 9.812z',
	    'arrow-up' => 'M28.5 16.688l1.313-1.375L16 1.5 2.187 15.313 3.5 16.688 15.063 5.125v25h1.875v-25z',
	    'arrow-right' => 'M29.563 15.938L15.75 2.125l-1.375 1.313 11.563 11.563H1.875v1.875h24.063L14.375 28.439l1.375 1.375z',
	    'arrow-left' => 'M30.125 16.875V15H6.062L17.625 3.437 16.25 2.124 2.437 15.937 16.25 29.812l1.375-1.375L6.062 16.874h24.063z',
	    'arrow-down' => 'M29.813 16.688L28.5 15.313 16.937 26.876v-25h-1.875v25L3.499 15.313l-1.313 1.375 13.813 13.813z',
	    'lock' => 'M17.875 20.625c0-1-.813-1.875-1.875-1.875s-1.875.875-1.875 1.875c0 .75.375 1.313.938 1.625v4.063h1.875V22.25c.563-.313.938-.938.938-1.625zm10.313-4.687c0-1.563-1.25-2.813-2.75-2.813v-3.75c0-5.188-4.25-9.438-9.438-9.438s-9.438 4.25-9.438 9.438v3.75c-1.563 0-2.813 1.25-2.813 2.813v13.313c0 1.563 1.25 2.813 2.813 2.813h18.813c1.5 0 2.813-1.25 2.813-2.813V15.938zM8.5 13.125v-3.75c0-4.188 3.375-7.563 7.5-7.563s7.5 3.375 7.5 7.563v3.75h-15zm17.813 2.813v13.313c0 .5-.438.938-.938.938H6.562c-.563 0-.938-.438-.938-.938V15.938c0-.563.375-.938.938-.938h18.875c.438.063.875.438.875.938z',
	    'location-arrow' => 'M3.688 3.688l26.563 9.938-14.313 2.313-2.25 14.313zm10.625 10.625l8.625-1.375-16-6 6 16z',
	    'link' => 'M24.438 13.063c2.563-2.563 2.563-6.75 0-9.313s-6.75-2.563-9.313 0L9.5 9.375c-2.563 2.563-2.563 6.75 0 9.313 1.313 1.313 2.938 1.938 4.688 1.938 1.688 0 3.313-.625 4.625-1.938L17.5 17.375c-1.875 1.813-4.813 1.813-6.688 0-1.813-1.875-1.813-4.813 0-6.688l5.625-5.625c1.875-1.813 4.813-1.813 6.688 0 1.813 1.875 1.813 4.813 0 6.688l-1.813 1.75 1.375 1.313zm-13.063 2.062c2.563-2.563 6.75-2.563 9.313 0s2.563 6.75 0 9.313L15 30.126c-1.313 1.313-3 1.938-4.688 1.938s-3.375-.625-4.625-1.938c-2.563-2.563-2.563-6.75 0-9.313l2-2L9 20.126l-2 2c-1.813 1.875-1.813 4.813 0 6.688 1.875 1.813 4.813 1.813 6.688 0l5.688-5.688c1.813-1.875 1.813-4.813 0-6.688-1.875-1.813-4.813-1.813-6.688 0l-.25.25-1.313-1.313z',
	    'layout' => 'M0 0h32v32H0V0zm1.875 11.313v18.813h16.938V11.313H1.875zm28.25 18.812V11.312h-9.438v18.813h9.438zM1.875 9.438h28.25V1.875H1.875v7.563z',
	    'layers' => 'M24.5 1.875v20.688H0V1.875h24.5zm-1.937 18.813V3.75H1.875v16.938h20.688zM32 9.438h-5.688v1.875h3.813v16.938H9.437v-3.813H7.499v5.688h24.5V9.438z',
	    'layers-alt' => 'M20.688 1.875v16.938H0V1.875h20.688zm-1.875 15.063V3.75H1.875v13.188h16.938zm7.562 7.562v-17h-3.75v1.938H24.5v13.125h-17V20.75H5.625v3.75h20.75zM32 13.188h-3.75v1.875h1.875v13.188H13.187v-1.875h-1.875v3.75H32V13.188z',
	    'key' => 'M27.875 11.875l-3.25-3.313-1.313 1.313 3.25 3.313-1.313 1.313-3.313-3.25-9.875 9.813c.688.938 1.063 2.125 1.063 3.375 0 3.063-2.5 5.625-5.625 5.625s-5.625-2.563-5.625-5.625c0-3.125 2.5-5.688 5.625-5.688 1.188 0 2.313.375 3.188 1l15.375-15.25 1.313 1.375-1.438 1.375 3.25 3.25zM7.5 28.188c2.063 0 3.75-1.688 3.75-3.75 0-2.125-1.688-3.813-3.75-3.813s-3.75 1.688-3.75 3.813c0 2.063 1.688 3.75 3.75 3.75z',
	    'import' => 'M16 25.75l9.125-9.125-1.313-1.313-6.875 6.813V1.812h-1.875v20.313l-6.875-6.813-1.313 1.313zM30.125 17H32v12.188c0 1.563-1.25 2.813-2.813 2.813H2.812c-1.563 0-2.813-1.25-2.813-2.813V17h1.875v12.188c0 .5.438.938.938.938h26.375c.5 0 .938-.438.938-.938V17z',
	    'image' => 'M1.875 1.875h28.25v28.25H1.875V1.875zM28.25 28.25V24.5H3.75v3.75h24.5zm-24.5-5.687h24.5V3.75H3.75v18.813zm23-3.438l-5.938-5.75-2.5 2.688-4.875-8.688-8.125 11.813 1.563 1.063 6.375-9.313 4.688 8.25 2.938-3.125 4.563 4.438z',
	    'heart' => 'M23.5 1.25c4.688 0 8.5 3.813 8.5 8.438 0 .688-.063 1.313-.25 2.063l-.25.688c-1.875 7.563-14.375 17.688-14.938 18.125l-.563.438-.563-.438c-.5-.438-12.25-9.875-14.938-18.063l-.188-.688C.06 11-.003 10.375-.003 9.688c0-4.625 3.813-8.438 8.5-8.438 3.25 0 6.063 1.875 7.5 4.563 1.438-2.688 4.25-4.563 7.5-4.563zm6.438 10c.125-.563.188-1.063.188-1.563 0-3.625-2.938-6.563-6.625-6.563-3.625 0-6.563 2.938-6.563 6.563v.5h-1.875v-.5c0-3.625-2.938-6.563-6.563-6.563-3.688 0-6.625 2.938-6.625 6.563 0 .5.063 1 .25 1.625l.188.563c2.188 6.688 11.25 14.688 13.688 16.75 2.5-2.125 12.188-10.563 13.688-16.688z',
	    'heart-broken' => 'M.313 11.813l.188.688c.188.625.5 1.313.938 2.188l1.688-.875c-.375-.75-.688-1.375-.813-1.938l-.188-.563c-.188-.625-.25-1.125-.25-1.625 0-3.625 2.938-6.563 6.625-6.563 3.625 0 6.563 2.938 6.563 6.563h1.875c0-3.625 2.938-6.563 6.563-6.563 3.688 0 6.625 2.938 6.625 6.563 0 .5-.063 1-.188 1.563l-.25.688c-.125.563-.375 1.188-.75 2l1.75.75c.375-.875.688-1.625.813-2.25l.25-.688c.188-.75.25-1.375.25-2.063 0-4.625-3.813-8.438-8.5-8.438-3.25 0-6.063 1.875-7.5 4.563-1.438-2.688-4.25-4.563-7.5-4.563-4.688 0-8.5 3.813-8.5 8.438 0 .688.063 1.313.313 2.125zM16 28.625c1.563-1.188 6-4.875 9.5-9.438l1.5 1.125c-4.438 5.813-10.188 10.063-10.438 10.25l-.563.438-.563-.438c-.25-.125-5.813-4.25-10.313-10.25l1.5-1.125c3.563 4.688 7.875 8.25 9.375 9.438zm10.688-14.687l5.875 4.188-1.125 1.5-4.75-3.375-5.313 3.75L16 16.251l-5.313 3.75-5.375-3.75-4.75 3.375-1.125-1.5 5.875-4.188 5.375 3.813L16 13.938l5.375 3.813z',
	    'hand-stop' => 'M26.375 8.313c0-1.563-1.25-2.813-2.813-2.813-.313 0-.688.063-1 .188v-.5c0-1.563-1.188-2.813-2.688-2.813-.375 0-.688.063-1.063.188C18.748 1.125 17.498 0 15.998 0s-2.688 1.125-2.813 2.563c-.313-.125-.625-.188-.938-.188-1.563 0-2.875 1.25-2.875 2.813v8.25l-.438-.5c-1.063-1.25-2.5-1.563-3.75-.875-.688.375-1.125 1-1.313 1.688-.188.75-.125 1.5.25 2.063l6.188 13.188c.25.438.625.813 1.063 1v1.063c0 .5.375.938.938.938.5 0 .938-.438.938-.938v-1.688c0-.438-.313-.813-.75-.875-.25-.063-.438-.25-.563-.375L5.747 14.939c-.125-.188-.125-.438-.063-.688s.188-.438.438-.563c.188-.063.688-.375 1.375.5l2.125 2.375c.25.25.688.375 1.063.25s.563-.5.563-.875V5.188c0-.5.438-.938 1-.938.438 0 .875.375.938.813v8.625c0 .563.438 1 .938 1s.938-.438.938-1V2.813c0-.563.375-.938.938-.938.5 0 .938.438.938.938v10.813c0 .5.438.938.938.938s.938-.438.938-.938V5.188l.063-.063c0-.438.5-.875 1-.875.563 0 .813.5.813.938v10.375c0 .5.438.938.938.938.563 0 .938-.438.938-.938V8.25c.063-.5.5-.875 1-.875s.938.375.938.938v13.625c0 1.313-.625 3.125-1.125 4.625-.438 1.313-.813 2.313-.813 3.063v1.438c0 .5.438.938.938.938.563 0 1-.438 1-.938v-1.438c0-.438.313-1.5.688-2.5.5-1.688 1.188-3.563 1.188-5.188V8.313z',
	    'hand-open' => 'M28.688 10.188c.25-1.688-.625-3-2.125-3.188-.688-.125-1.375 0-1.875.438-.063.063-.125.063-.188.125l.125-1.813c.125-1.563-1-2.875-2.563-3.063-.688-.063-1.438.188-2 .688-.313.188-.5.5-.688.813V2.75c0-1.5-1.25-2.75-2.75-2.75-1.563 0-2.813 1.25-2.813 2.75v1.438c-.188-.313-.375-.625-.688-.813-.563-.5-1.25-.75-2-.688s-1.375.438-1.875 1-.688 1.313-.625 2L9.311 16l-.938-1.188c-.813-1.438-2.625-1.875-4.063-1.063-.688.375-1.188 1.063-1.375 1.813-.25.75-.125 1.563.313 2.25L9.873 29.25c.25.5.688.875 1.125 1.125v.688c0 .5.438.938.938.938.563 0 1-.438 1-.938V29.75c0-.438-.313-.813-.75-.875-.313-.125-.563-.313-.688-.563L4.873 16.874c-.188-.25-.188-.563-.125-.813.063-.313.25-.563.5-.688.5-.313 1.188-.125 1.563.5l2.938 3.688c.25.313.688.438 1.063.313.438-.188.625-.563.625-.938l-.938-13.375c-.063-.25.063-.5.188-.688.125-.125.375-.25.625-.313.188 0 .438.063.625.25.188.125.313.375.313.625l1 10c0 .313.188.625.5.75.25.125.625.125.875 0 .125-.063.25-.125.313-.188.375-.188.563-.5.563-.813l.25-12.438c0-.5.375-.875.875-.875.438 0 .875.375.875.938l.188 11.5c0 .5.438.875.938.938h.438c.563 0 1-.375 1-.875l.875-9c.063-.188.125-.438.313-.563.188-.188.438-.25.688-.25.5.063.813.5.813 1l-.563 10c0 .313.125.625.438.813.188.125.313.188.438.125.25.188.563.25.875.125s.5-.438.563-.75l.938-6.25c.063-.313.188-.563.375-.688.125-.125.313-.125.5-.125.625.125.563.875.5 1.125L24.63 25.059c-.125.563-.313.75-.625 1-.625.625-1.125 1.313-1.125 3.125v1.875c0 .5.438.938.938.938s.938-.438.938-.938v-1.875c0-1.188.25-1.438.625-1.75.375-.375.875-.875 1.063-2.063z',
	    'hand-drag' => 'M26.313 10.563c0-1.688-1.375-3.063-2.938-3.063-.313 0-.688.063-1 .125-.375-1.188-1.438-2.063-2.75-2.063-.375 0-.75.125-1.063.25-.375-1.188-1.375-2-2.625-2-1.313 0-2.313.75-2.688 2-.375-.125-.688-.25-1.063-.25-1.625 0-2.875 1.375-2.875 3V12c0 .063-.063.063-.063.063v1.375c-.5-.125-1.063-.125-1.438-.063-.75.188-1.5.75-1.875 1.5-.438.875-.5 1.938-.063 2.875l3.188 6.875c.25 1.063 1.063 1.875 2.063 2.125v2.438c0 .5.438.938.938.938s.938-.438.938-.938v-3.313c0-.25-.125-.5-.313-.688s-.438-.25-.75-.25c-.5.063-1-.25-1.063-.813-.063-.063-.063-.125-.063-.188l-3.25-7c-.188-.563-.063-1 .063-1.188.125-.25.375-.5.563-.5.25-.063.75 0 1.063.125v1.563c0 .563.438.938 1 .938.5 0 .938-.375.938-.938V8.561c0-.625.438-1.063 1-1.063.5 0 .75.313.875.688v5.063c0 .5.375.938.938.938.5 0 .938-.438.938-.938V6.874c0-.438.125-1.188 1-1.188s.875 1.063.875 1.188v5.313c0 .5.438.938.938.938.563 0 .938-.438.938-.938V8.374c.063-.5.438-.875.938-.875.563 0 1 .438 1 1v4c0 .5.375.938.938.938.5-.063.938-.438.938-.938v-1.188c0-.75 0-1.625.125-1.813 0 0 .125-.125.75-.125.5 0 1 .563 1 1.188v11c0 .75-.313 1.188-.813 1.75-.438.625-1.063 1.313-1.063 2.5v3.375c0 .5.375.938.938.938.5 0 .938-.438.938-.938v-3.375c0-.438.25-.75.688-1.313.5-.625 1.25-1.5 1.25-2.938v-11z',
	    'folder' => 'M15.063 7.5h16.938V32h-32V3.75h11.375zm-4.5-1.875H1.875v7.563l28.25.063V9.438H14.25zm-8.688 24.5h28.25v-15l-28.25-.063v15.063z',
	    'flag' => 'M24.5 18.813L2.125 10.125 24.5 1.437v17.375zm-1.937-2.75V4.188l-15.25 5.938zM28.25 0h-1.875v32h1.875V0z',
	    'flag-alt' => 'M28.25 0h-1.875v32h1.875V0zM2.875 1.813l5.438 7.625-5.5 7.438h21.688V1.813H2.876zM22.563 3.75V15h-16l4.063-5.5-4.063-5.75h16z',
	    'flag-alt-2' => 'M28.25 0h-1.875v32h1.875V0zM9.375 1.875v3.75h-7.5v15.063h13.188v-3.75h9.375V1.875H9.375zm3.813 15.063v1.875H3.75V7.5h5.688v9.438h3.75zM11.25 3.75h11.313v11.313h-11.25V5.625h-.063V3.75z',
	    'eye' => 'M31.938 16.625c.063.188.063.438 0 .688C29.5 23.438 23.125 27.563 16 27.563S2.5 23.438.062 17.313c-.063-.25-.063-.5 0-.688C2.5 10.437 8.875 6.312 16 6.312s13.5 4.125 15.938 10.313zM16 25.688c6.188 0 11.813-3.5 14.063-8.75-2.25-5.25-7.875-8.75-14.063-8.75s-11.813 3.5-14.063 8.75c2.25 5.25 7.875 8.75 14.063 8.75zm0-15.625c3.813 0 6.875 3.125 6.875 6.875 0 3.813-3.063 6.875-6.875 6.875s-6.875-3.063-6.875-6.875c0-3.75 3.063-6.875 6.875-6.875zm0 11.875c2.75 0 5-2.25 5-5s-2.25-5-5-5-5 2.25-5 5 2.25 5 5 5zm0-7.563c1.438 0 2.563 1.188 2.563 2.563 0 1.438-1.125 2.563-2.563 2.563s-2.563-1.125-2.563-2.563c0-1.375 1.125-2.563 2.563-2.563zm0 3.25c.375 0 .688-.313.688-.688s-.313-.688-.688-.688-.688.313-.688.688.313.688.688.688z',
	    'export' => 'M8.188 11.188l6.875-7.063v20.313h1.875V4.125l6.875 7.063 1.313-1.313L16.001.5 6.876 9.875zM30.125 17H32v12.188c0 1.563-1.25 2.813-2.813 2.813H2.812c-1.563 0-2.813-1.25-2.813-2.813V17h1.875v12.188c0 .5.438.938.938.938h26.375c.5 0 .938-.438.938-.938V17z',
	    'exchange-vertical' => 'M11.313 28.313l6.875-6.875 1.313 1.375-9.125 9.125-9.188-9.125 1.375-1.375 6.875 6.875v-13.25h1.875v13.25zm-1 .937zm19.125-18.687l1.375-1.375L21.625.063 12.5 9.188l1.313 1.375 6.875-6.875v13.375h1.875V3.688z',
	    'desktop' => 'M3.75 20.688V5.625h24.5v15.063H3.75zM5.625 7.5v11.313h20.75V7.5H5.625zm23.563-5.625c1.563 0 2.813 1.188 2.813 2.688v19.125c0 1.438-1.25 2.688-2.813 2.688H2.813C1.25 26.376 0 25.126 0 23.688V4.563c0-1.5 1.25-2.688 2.813-2.688h26.375zm.937 21.813V4.563c0-.438-.438-.813-.938-.813H2.812c-.5 0-.938.375-.938.813v19.125c0 .438.438.813.938.813h26.375c.5 0 .938-.375.938-.813zM9.438 28.25v1.875h13.125V28.25H9.438z',
	    'cup' => 'M32 1.875v.938c0 2.063-.125 4.125-.375 6.25-.625 5.5-2.375 11.938-5.25 13.313-.375.188-.75.313-1.125.313-.438 0-.875-.125-1.313-.375l-.438-.313c-1.688 2.625-3.875 4.063-6.563 4.375v3.75h5.75v1.875H9.498v-1.875h5.563v-3.813c-2.875-.25-5-1.875-6.563-4.313l-.438.25c-.438.313-.875.438-1.313.438-.375 0-.75-.125-1.125-.313C2.747 21 .997 14.562.372 9.062c-.25-2.125-.375-4.188-.375-6.25v-.938h4.25V-.001h23.5v1.875h4.25zm-24.5 18.5l.188.25C5.25 15.937 4.438 9.25 4.313 3.75H1.875c.063 1.688.188 3.375.375 5.063.813 6.875 2.75 11.188 4.188 11.875.25.125.438.125.625 0zm8.5 4.188c8.313 0 9.813-13.813 9.875-22.688H6.125c.063 7.5 1.313 22.688 9.875 22.688zm13.75-15.75c.188-1.688.313-3.375.375-5.063H27.75c-.25 7.438-1.438 13.125-3.5 17l.25-.375.438.313c.188.125.375.125.625 0 1.438-.688 3.375-5 4.188-11.875z',
	    'crown' => 'M23.75 12.688L32.313 5.5l-3.25 24.625H2.938L-.312 5.5l8.438 7.188L16.064.125zM4.625 28.25h22.75l.25-1.875H4.375zm23.25-3.75l1.938-14.438-6.5 5.5-7.25-11.875-7.5 11.875-6.375-5.438 1.938 14.375h23.75z',
	    'comments' => 'M32 2.813C32 1.25 30.75 0 29.187 0H2.812C1.249 0-.001 1.25-.001 2.813v15c0 1.563 1.25 2.813 2.813 2.813h.938v7.75l6.5-5.688L9 21.25l-3.375 2.938V18.75H2.812c-.5 0-.938-.438-.938-.938v-15c0-.5.438-.938.938-.938h26.375c.5 0 .938.438.938.938v15c0 .5-.438.938-.938.938h-.938v1.875h.938c1.563 0 2.813-1.25 2.813-2.813v-15zm-5.625 15.125c0-1.563-1.25-2.813-2.813-2.813h-9.438c-1.563 0-2.813 1.25-2.813 2.813v5.75c0 1.563 1.25 2.813 2.813 2.813h1.625l6.875 5.75v-5.75h.938c1.563 0 2.813-1.25 2.813-2.813v-5.75zm-1.875 0v5.75c0 .5-.438.938-.938.938h-2.813v3.625l-4.313-3.625h-2.313c-.5 0-.938-.438-.938-.938v-5.75c0-.5.438-.938.938-.938h9.438c.5 0 .938.438.938.938z',
	    'comment' => 'M29.188 0c1.563 0 2.813 1.25 2.813 2.813v18.813c0 1.563-1.25 2.875-2.813 2.875H12.563L3.75 32.189v-7.688h-.938c-1.563 0-2.813-1.313-2.813-2.875V2.813C-.001 1.25 1.249 0 2.812 0h26.375zm.937 21.625V2.812c0-.5-.438-.938-.938-.938H2.812c-.5 0-.938.438-.938.938v18.813c0 .563.438.938.938.938h2.813v5.5l6.25-5.5h17.313c.5 0 .938-.375.938-.938z',
	    'comment-alt' => 'M29.188 0c1.563 0 2.813 1.25 2.813 2.813v18.813c0 1.563-1.25 2.875-2.813 2.875H12.563L3.75 32.189v-7.688h-.938c-1.563 0-2.813-1.313-2.813-2.875V2.813C-.001 1.25 1.249 0 2.812 0h26.375zm.937 21.625V2.812c0-.5-.438-.938-.938-.938H2.812c-.5 0-.938.438-.938.938v18.813c0 .563.438.938.938.938h2.813v5.5l6.25-5.5h17.313c.5 0 .938-.375.938-.938zm-24.5-16V7.5h20.75V5.625H5.625zm0 3.813v1.875h20.75V9.438H5.625zm0 3.75v1.875h11.313v-1.875H5.625z',
	    'close' => 'M17.313 16l12.5-12.5L28.5 2.187 16 14.687 3.5 2.187 2.187 3.5l12.5 12.5-12.5 12.5L3.5 29.813l12.5-12.5 12.5 12.5 1.313-1.313z',
	    'clip' => 'M22.625 8c0-3.063-2.313-6.188-6.688-6.188-4.5 0-6.5 3.188-6.5 6.188v18c0 2.188 2.125 4.125 4.563 4.125 2.563 0 4.813-2 4.813-4.188v-2.75l.063-12.125c0-2.875-1.5-3.5-2.813-3.5-2.875 0-2.875 2.563-2.875 3.438v9.688h1.875V11c0-1.5.313-1.563 1-1.563.438 0 .875 0 .875 1.625v14.875c0 1.063-1.313 2.313-2.938 2.313-1.375 0-2.688-1.063-2.688-2.25V8c0-1.625 1-4.313 4.625-4.313 3.313 0 4.813 2.25 4.813 4.313v15.938h1.875V8z',
	    'angle-up' => 'M30.813 22.375L16 7.625 1.187 22.375l1.375 1.375L16 10.25l13.438 13.5z',
	    'angle-right' => 'M24.875 15.938L10.062 1.188 8.749 2.501l13.438 13.438L8.749 29.377l1.313 1.375z',
	    'angle-left' => 'M9.813 15.938L23.251 2.5l-1.313-1.313-14.813 14.75L21.938 30.75l1.313-1.375z',
	    'angle-down' => 'M30.813 9.563L29.438 8.25 16 21.688 2.562 8.25 1.187 9.563 16 24.313z',
	    'check' => 'M29 3.313l-1.563-1-15.438 23.563-7.625-6.813-1.25 1.375 9.25 8.313z',
	    'check-box' => 'M26.375 10.875V28.25H3.75V5.625h13.938V3.75H1.875v26.375H28.25v-19.25h-1.875zm-17.25 4.438l4.813 4.875L27.001.438l1.563 1-14.313 21.688-6.438-6.438z',
	    'camera' => 'M11.188 5.625h20.813V28.25h-32V5.625h5.75V3.75h5.438v1.875zm18.937 20.75V13.187h-2.938c.625 1.125 1.063 2.375 1.063 3.75 0 4.125-3.375 7.563-7.563 7.563-4.125 0-7.5-3.438-7.5-7.563 0-1.375.375-2.625 1.063-3.75H1.875v13.188h28.25zm-3.75-9.437c0-3.125-2.563-5.625-5.688-5.625s-5.625 2.5-5.625 5.625 2.5 5.625 5.625 5.625 5.688-2.5 5.688-5.625zm-.75-5.625h4.5V7.5H1.875v3.813H15.75c1.375-1.188 3.063-1.875 4.938-1.875 1.938 0 3.625.688 4.938 1.875z',
	    'announcement' => 'M31 4.188c.563 0 1 .438 1 1v21.563c0 .5-.438.938-1 .938h-3.625c-.563 0-1-.438-1-.938v-1.25l-5.938-1.063c-.625 2.875-3.188 5-6.313 5-3.625 0-6.563-2.875-6.563-6.438 0-.313 0-.625.063-.938l-1.938-.375v.625c0 .813-.688 1.5-1.5 1.5H1.498c-.813 0-1.5-.688-1.5-1.5v-8.813c0-.813.688-1.5 1.5-1.5h2.688c.813 0 1.5.688 1.5 1.5v.5l20.688-7.563v-1.25c0-.563.438-1 1-1h3.625zM14.125 27.563c2.188 0 4-1.438 4.5-3.5L9.5 22.375c0 .188-.063.438-.063.625 0 2.5 2.063 4.563 4.688 4.563zm16-1.75V6.063H28.25v1.688L3.812 16.689v-2.75H1.874v8h1.938v-2.5l24.438 4.5v1.875h1.875z',
	    'brush' => 'M29.938 3.375l-1.563-1.063-12.188 17.875 1.5 1.063zm-13 22.938c0-2.063-1.688-3.75-3.75-3.75-1.125 0-2.438.938-2.75 1.125l-8.563 6.438h11.313c2.063 0 3.75-1.688 3.75-3.813zm-1.875 0c0 1.063-.875 1.938-1.875 1.938H7.5l4.063-3.063c.5-.375 1.313-.75 1.625-.75 1 0 1.875.875 1.875 1.875z',
	    'briefcase' => 'M13.188 24.5h5.625v-2.875h-1.875v.938h-1.875v-.938h-1.875V24.5zM32 20.688V5.625h-6.813C23.437 2.187 19.937 0 15.999 0S8.561 2.188 6.811 5.625H-.002v15.063h1.875v11.313h28.25V20.688h1.875zM9 5.625c1.5-2.313 4.125-3.75 7-3.75s5.5 1.438 7 3.75H9zm19.25 15.063v9.438H3.75v-9.438h24.5zM30.125 7.5v11.313H1.875V7.5h28.25z',
	    'bolt' => 'M26.938 3.813l-6.125 9.438h5.5L8.438 28.376l3.813-11.375H9.063l4.438-13.188h13.438zm-5.75 11.312h-3.813L23.5 5.687h-8.688l-3.125 9.438h3.125l-2.438 7.5z',
	    'bolt-alt' => 'M22.25 15.063h-9.188l7.25-10.75-1.563-1.063-9.25 13.688h9.625l-5.75 10.875 1.688.875z',
	    'blackboard' => 'M16.938 3.75h13.188v18.813H1.876V3.75h13.188V0h1.875v3.75zM28.25 20.688V5.625H3.75v15.063h24.5zM6.563 24.5v1.875h4.938L8.626 30.75l1.563 1 3.5-5.375h1.375V32h1.875v-5.625h1.375l3.5 5.375 1.563-1-2.813-4.375h4.875V24.5H6.564z',
	    'bag' => 'M24.5 7.5h5.625V32H1.875V7.5h5.688V3c0-1.625 1.375-3 3.063-3h10.75c1.688 0 3.125 1.375 3.125 3v4.5zM9.438 3v4.5h13.125V3c0-.625-.5-1.125-1.188-1.125h-10.75c-.625 0-1.188.5-1.188 1.125zM28.25 30.125V15.062H3.75v15.063h24.5zm0-16.937v-3.75H24.5v1.188h-1.938V9.438H9.437v1.188H7.562V9.438H3.749v3.75h24.5z',
	    'move' => 'M25.625 21.375L31 16l-5.375-5.375L24.25 12l3.125 3.063H16.937V4.625L20 7.75l1.375-1.375L16 1l-5.375 5.375L12 7.75l3.063-3.125v10.438H4.625L7.75 12l-1.375-1.375L1 16l5.375 5.375L7.75 20l-3.125-3.063h10.438v10.438L12 24.25l-1.375 1.375L16 31l5.375-5.375L20 24.25l-3.063 3.125V16.937h10.438L24.25 20z',
	    'arrows-vertical' => 'M21.938 22.688l-5 5.125V4.188l5 5.125L23.251 8 16.001.562 8.751 8l1.313 1.313 5-5.125v23.625l-5-5.125-1.313 1.313 7.25 7.438 7.25-7.438z',
	    'arrows-horizontal' => 'M31.438 16L24 8.75l-1.313 1.313 5.125 5H4.187l5.125-5L7.999 8.75.561 16l7.438 7.25 1.313-1.313-5.125-5h23.625l-5.125 5L24 23.25z',
	    'fullscreen' => 'M30.125 21.375H28.25v5.5L17.312 16 28.25 5.125v5.5h1.875v-8.75h-8.75V3.75h5.5L16 14.688 5.125 3.75h5.5V1.875h-8.75v8.75H3.75v-5.5L14.688 16 3.75 26.875v-5.5H1.875v8.75h8.75V28.25h-5.5L16 17.312 26.875 28.25h-5.5v1.875h8.75v-8.75z',
	    'arrow-top-right' => 'M30.125 1.875h-17V3.75h13.75L7.5 23.125 8.813 24.5 28.251 5.062v13.75h1.875V1.874z',
	    'arrow-top-left' => 'M23.125 24.5l1.313-1.375L5.063 3.75h13.75V1.875h-17v16.938h1.875V5.063z',
	    'arrow-circle-up' => 'M16 10.875l-8.188 8.25 1.313 1.313L16 13.563l6.875 6.875 1.313-1.313zM32 16c0-8.813-7.188-16-16-16S0 7.188 0 16s7.188 16 16 16 16-7.188 16-16zm-1.875 0c0 7.813-6.313 14.125-14.125 14.125S1.875 23.812 1.875 16 8.188 1.875 16 1.875 30.125 8.188 30.125 16z',
	    'arrow-circle-right' => 'M12.875 7.813l-1.313 1.313 6.875 6.875-6.875 6.875 1.313 1.313 8.25-8.188zM32 16c0-8.813-7.188-16-16-16S0 7.188 0 16s7.188 16 16 16 16-7.188 16-16zm-1.875 0c0 7.813-6.313 14.125-14.125 14.125S1.875 23.812 1.875 16 8.188 1.875 16 1.875 30.125 8.188 30.125 16z',
	    'arrow-circle-left' => 'M20.438 9.125l-1.313-1.313L10.875 16l8.25 8.188 1.313-1.313L13.563 16zM32 16c0-8.813-7.188-16-16-16S0 7.188 0 16s7.188 16 16 16 16-7.188 16-16zm-1.875 0c0 7.813-6.313 14.125-14.125 14.125S1.875 23.812 1.875 16 8.188 1.875 16 1.875 30.125 8.188 30.125 16z',
	    'arrow-circle-down' => 'M22.875 11.563L16 18.438l-6.875-6.875-1.313 1.313L16 21.126l8.188-8.25zM32 16c0-8.813-7.188-16-16-16S0 7.188 0 16s7.188 16 16 16 16-7.188 16-16zm-1.875 0c0 7.813-6.313 14.125-14.125 14.125S1.875 23.812 1.875 16 8.188 1.875 16 1.875 30.125 8.188 30.125 16z',
	    'angle-double-up' => 'M16 11.438L3.125 24.313l1.313 1.375 11.563-11.625 11.563 11.625 1.313-1.375zM16 5L4.437 16.563l-1.313-1.375L15.999 2.313l12.875 12.875-1.313 1.375z',
	    'angle-double-right' => 'M18.125 16L5.25 3.125 3.937 4.438 15.5 16.001 3.937 27.564l1.313 1.313zm-3.75-12.875L27.25 16 14.375 28.875l-1.313-1.313 11.563-11.563L13.062 4.436z',
	    'angle-double-left' => 'M15.063 16L26.626 4.437l-1.375-1.313-12.875 12.875 12.875 12.875 1.375-1.313zM17.5 4.438L5.937 16.001 17.5 27.564l-1.313 1.313L3.249 16.002 16.187 3.127z',
	    'angle-double-down' => 'M16 20.063L28.875 7.125l-1.313-1.313-11.563 11.563L4.436 5.812 3.123 7.125zm0 6.437l11.563-11.563 1.313 1.313-12.875 12.875L3.126 16.25l1.313-1.313z',
	    'zip' => 'M18.188 0l10.063 10v22h-24.5V0h14.438zm.625 3.25v6.188h6.188zM5.625 30.125h20.75V11.312h-9.438V1.874h-3.75v1.875h-1.875V1.874H5.624v28.25zm3.813-15.062v1.875h1.875v-1.875H9.438zm1.875 0h1.875v-1.875h-1.875v1.875zm0-3.75h1.875V9.438h-1.875v1.875zm-1.875 0v1.875h1.875v-1.875H9.438zm0-3.813v1.938h1.875V7.5H9.438zm1.875 0h1.875V5.625h-1.875V7.5zM9.438 3.75v1.875h1.875V3.75H9.438zm1.875 13.938c2.063 0 3.75 1.688 3.75 3.75 0 .625-.188 1.25-.5 1.813-.563 1.063-1.625 1.813-2.875 1.938h-.375c-2.125 0-3.813-1.688-3.813-3.75s1.688-3.75 3.813-3.75zm1.625 4.625c.188-.25.25-.563.25-.875 0-1.063-.875-1.875-1.875-1.875-1.063 0-1.875.813-1.875 1.875s.813 1.875 1.875 1.875h.188c.625-.063 1.125-.438 1.438-1z',
	    'world' => 'M16 0c8.875 0 16 7.188 16 16s-7.125 16-16 16C7.187 32 0 24.812 0 16S7.188 0 16 0zM1.938 16.938c.125 2 .688 3.938 1.625 5.625h4.875c-.563-1.813-.875-3.688-.938-5.625H1.937zM7.5 15.063c.063-1.938.375-3.813.938-5.625H3.563c-.938 1.688-1.5 3.625-1.625 5.625h5.563zm2.938-5.625c-.625 1.813-1 3.688-1.063 5.625h13.25c-.125-1.938-.438-3.813-1.063-5.625H10.437zm-1.063 7.5c.063 1.938.438 3.813 1.063 5.625h11.125c.625-1.813.938-3.688 1.063-5.625H9.376zm15.125 0c-.063 1.938-.375 3.813-1 5.625h5c.938-1.688 1.438-3.625 1.625-5.625H24.5zm0-1.875h5.625c-.188-2-.688-3.938-1.625-5.625h-4.938c.563 1.813.875 3.688.938 5.625zM27.313 7.5c-1.813-2.375-4.375-4.188-7.375-5.063 1.188 1.625 2.188 3.313 2.938 5.063h4.438zm-10.25-5.562c-.313 0-.688-.063-1.063-.063s-.75.063-1.125.063c-1.5 1.688-2.75 3.563-3.688 5.563h9.625c-.938-2-2.188-3.875-3.75-5.563zM12 2.5c-2.938.813-5.438 2.625-7.25 5h4.375c.75-1.75 1.688-3.438 2.875-5zm-7.25 22c1.813 2.375 4.375 4.188 7.313 5.063-1.188-1.625-2.188-3.313-2.938-5.063H4.75zm10.188 5.563c.375 0 .688.063 1.063.063s.75-.063 1.063-.063c1.563-1.688 2.813-3.563 3.75-5.563h-9.625c.938 2 2.188 3.875 3.75 5.563zm5-.5c3-.875 5.563-2.688 7.375-5.063h-4.438c-.75 1.75-1.75 3.5-2.938 5.063z',
	    'wheelchair' => 'M20.5 24.188c-.75 3.5-3.75 5.938-7.313 5.938-4.188 0-7.563-3.375-7.563-7.563 0-3.375 2.313-6.375 5.625-7.25l-.5-1.813c-4.125 1.063-7 4.813-7 9.063 0 5.188 4.25 9.438 9.438 9.438 4.438 0 8.25-3.063 9.188-7.438zm9.625 4.25h-2l-1.813-7.75H14.999l-.313-3.813 7.188-1.813-.438-1.813-6.875 1.688-.5-7.5c1.625-.438 2.875-1.938 2.875-3.688 0-2.063-1.688-3.75-3.75-3.75s-3.75 1.688-3.75 3.75c0 1.75 1.188 3.188 2.75 3.625l1 15.25h11.625l1.813 7.75h3.5v-1.938zM13.188 5.625c-1.063 0-1.875-.813-1.875-1.875 0-1 .813-1.875 1.875-1.875 1 0 1.875.875 1.875 1.875 0 1.063-.875 1.875-1.875 1.875z',
	    'view-list' => 'M0 0h32v7.5H0V0zm30.125 5.625v-3.75H1.875v3.75h28.25zM0 18.813v-7.5h32v7.5H0zm1.875-5.625v3.75h28.25v-3.75H1.875zM0 30.125v-7.563h32v7.563H0zM1.875 24.5v3.75h28.25V24.5H1.875z',
	    'view-list-alt' => 'M9.438 0h22.563v7.5H9.438V0zm20.687 5.625v-3.75H11.312v3.75h18.813zM9.438 18.813v-7.5h22.563v7.5H9.438zm1.875-5.625v3.75h18.813v-3.75H11.313zM9.438 30.125v-7.563h22.563v7.563H9.438zm1.875-5.625v3.75h18.813V24.5H11.313zM0 7.5V0h7.5v7.5H0zm1.875-5.625v3.75h3.75v-3.75h-3.75zM0 18.813v-7.5h7.5v7.5H0zm1.875-5.625v3.75h3.75v-3.75h-3.75zM0 30.125v-7.563h7.5v7.563H0zM1.875 24.5v3.75h3.75V24.5h-3.75z',
	    'view-grid' => 'M0 13.188V0h13.188v13.188H0zM1.875 1.875v9.438h9.438V1.875H1.875zM18.813 0h13.188v13.188H18.813V0zm11.312 11.313V1.875h-9.438v9.438h9.438zM0 32V18.812h13.188V32H0zm1.875-11.312v9.438h9.438v-9.438H1.875zM18.813 32V18.812h13.188V32H18.813zm1.875-11.312v9.438h9.438v-9.438h-9.438z',
	    'uppercase' => 'M13.188 7.5H1.875v3.813H3.75V9.438H7.5v15.063H5.625v1.875h5.688v-1.875H9.438V9.438h3.75v1.875h1.875V7.5h-1.875zm15.062 0h1.875v3.813H28.25V9.438H24.5v15.063h1.875v1.875h-5.688v-1.875h1.875V9.438h-3.75v1.875h-1.875V7.5H28.25z',
	    'upload' => 'M32 30.125H0V32h32v-1.875zM15.063 3.188l-6.875 6.875L6.875 8.75 16-.375l9.125 9.125-1.313 1.313-6.875-6.875v21.313h-1.875V3.188z',
	    'underline' => 'M28.25 1.875h-5.688V3.75H24.5v12.188c0 4.625-3.813 8.438-8.5 8.438s-8.5-3.813-8.5-8.438V3.75h1.938V1.875H3.75V3.75h1.875v12.188c0 5.688 4.688 10.313 10.375 10.313s10.375-4.625 10.375-10.313V3.75h1.875V1.875zm-24.5 28.25V28.25h24.5v1.875H3.75z',
	    'truck' => 'M32 5.625v22.563h-3.75v.063c0 2.063-1.688 3.75-3.75 3.75-2.125 0-3.813-1.688-3.813-3.75v-.063h-9.375v.063c0 2.063-1.688 3.75-3.813 3.75-2.063 0-3.75-1.688-3.75-3.75v-.063h-3.75v-9.375h3.625l2.25-7.5h5.438V5.625H32zM7.313 13.188l-1.688 5.625h5.688v-5.625h-4zM7.5 30.125c1.063 0 1.938-.875 1.938-1.875 0-1.063-.875-1.875-1.938-1.875-1 0-1.875.813-1.875 1.875 0 1 .875 1.875 1.875 1.875zm17 0c1 0 1.875-.875 1.875-1.875 0-1.063-.875-1.875-1.875-1.875-1.063 0-1.938.813-1.938 1.875 0 1 .875 1.875 1.938 1.875zm5.625-3.812V7.5H13.187v13.188H1.874v5.625h2.438C5 25.188 6.187 24.5 7.5 24.5c1.375 0 2.563.688 3.25 1.813h10.5c.688-1.125 1.875-1.813 3.25-1.813 1.313 0 2.5.688 3.188 1.813h2.438z',
	    'timer' => 'M16.938 3.813c7.375.5 13.188 6.625 13.188 14.063 0 7.813-6.313 14.125-14.125 14.125S1.876 25.688 1.876 17.876c0-7.438 5.813-13.563 13.188-14.063V1.875h-2.813V0h7.5v1.875h-2.813v1.938zM16 30.125c6.75 0 12.25-5.5 12.25-12.25S22.75 5.625 16 5.625s-12.25 5.5-12.25 12.25 5.5 12.25 12.25 12.25zm.938-13.187v-5.625h-1.875v7.5h9.438v-1.875h-7.563z',
	    'ticket' => 'M17.875 1.875H24.5v28.25h-6.625v-.938c0-1.063-.813-1.875-1.875-1.875s-1.875.813-1.875 1.875v.938H7.5V1.875h6.625v.938c0 1.063.813 1.875 1.875 1.875s1.875-.813 1.875-1.875v-.938zm-5.5 1.875H9.437v11.313h13.125V3.75h-2.938c-.375 1.625-1.875 2.813-3.625 2.813s-3.25-1.188-3.625-2.813zm7.25 24.5h2.938V16.937H9.438V28.25h2.938c.375-1.625 1.875-2.813 3.625-2.813s3.25 1.188 3.625 2.813z',
	    'thumb-up' => 'M28.938 18.313c.688-.5 1.188-1.375 1.188-2.313 0-1.563-1.313-2.813-2.875-2.813h-7.25l.75-4c.25-1.25.5-2.813-.188-3.938-.438-.813-1.313-1.313-2.25-1.313-.625 0-1.75.25-2.688 1.75l-5.813 9.375H5.499c-.5 0-.938.438-.938.938 0 .563.438 1 .938 1h4.875c.313 0 .625-.188.75-.5l6.125-9.813c.313-.563.688-.875 1.063-.875.313 0 .563.188.625.375.438.625.063 2.125-.063 2.625l-.938 5.125c-.063.313 0 .563.188.813.188.188.438.313.688.313h8.438c.563 0 1 .438 1 .938 0 .563-.5 1-1 1h-3.125c-.5 0-.938.375-.938.938 0 .5.438.938.938.938H26.5c.813 0 .813 0 .813.938 0 .438-.25.938-.875.938H23.75c-.5 0-.938.375-.938.938 0 .5.438.938.938.938h1.438c.5 0 1.313.125 1.313.938 0 .563-.438.938-1 .938h-2.375c-.5 0-.938.375-.938.938 0 .5.438.938.938.938h.188c1.813 0 1.938.125 1.938 1 0 .313-.063.5-.188.688-.125.125-.438.188-.813.188H13.626c-.75 0-1.313-.438-1.938-.875-.625-.5-1.313-1.063-2.25-1.063H5.5c-.5 0-.938.438-.938.938 0 .563.438.938.938.938h3.938c.313 0 .688.313 1.125.625.688.563 1.688 1.313 3.063 1.313h10.625c.938 0 1.625-.25 2.188-.75.5-.5.75-1.188.75-2.063-.063-.5-.125-.938-.25-1.313.875-.438 1.438-1.375 1.438-2.438 0-.5-.125-1-.375-1.438.75-.5 1.188-1.313 1.188-2.313 0-.625-.125-1.125-.25-1.5z',
	    'thumb-down' => 'M27.438 17.875c0-.5-.438-.938-.938-.938h-4.875c-.313 0-.625.188-.813.438l-6.063 9.875c-.313.5-.688.813-1.063.813-.313 0-.563-.188-.625-.313-.438-.688-.063-2.125.063-2.625l.938-5.188c.063-.25 0-.563-.188-.75-.188-.25-.438-.313-.75-.313H4.749c-.563 0-1-.438-1-1 0-.5.438-.938 1-.938h3.125c.5 0 .938-.438.938-.938s-.438-.938-.938-.938H5.999c-.625-.125-1.313-.688-1.313-1 0-.438.25-.875.875-.875h2.688c.5 0 .938-.438.938-.938 0-.563-.438-.938-.938-.938H6.811c-.5 0-1.313-.125-1.313-1 0-.5.438-.875 1-.875h2.375c.5 0 .938-.438.938-.938s-.438-.938-.938-.938h-.25c-1.875 0-1.875-.688-1.875-1 0-.625.125-.938 1-.938h10.625c.75 0 1.313.438 1.938.938s1.313 1 2.25 1h3.938c.5 0 .938-.375.938-.938 0-.5-.438-.938-.938-.938h-3.938c-.313 0-.688-.313-1.125-.625-.688-.563-1.688-1.313-3.063-1.313H7.748c-1.813 0-2.938 1.063-2.938 2.813 0 .313.063.813.313 1.313-.875.438-1.5 1.375-1.5 2.438 0 .5.125 1 .375 1.438-.75.5-1.188 1.375-1.188 2.313 0 .563.188 1 .5 1.375-.875.5-1.438 1.438-1.438 2.438 0 1.563 1.313 2.875 2.875 2.875h7.25l-.75 4c-.25 1.188-.5 2.813.188 3.938.438.75 1.313 1.25 2.25 1.25.625 0 1.75-.188 2.688-1.75l5.813-9.375h4.313c.5 0 .938-.438.938-.938z',
	    'text' => 'M26.375 3.75H5.625v5.688H7.5V5.625h7.563V28.25h-3.125v1.875h8.125V28.25h-3.125V5.625h7.563v3.813h1.875V3.75z',
	    'stats-up' => 'M32 30.125H0V32h32v-1.875zM9.813 15l-7.125 6.438-1.25-1.375 8.25-7.438 7.75 5.563L27.001 7.5h-4.5V5.625h7.625v7.625h-1.875V8.937l-10.563 11.75z',
	    'stats-down' => 'M9.75 16.563L17.5 11l9.563 10.625h-4.5V23.5h7.625v-7.563h-1.875v4.313L17.75 8.437l-7.875 5.688L2.75 7.75 1.5 9.125zM0 30.125h32V32H0v-1.875z',
	    'split-v' => 'M20.063 24.75l-3.125 3.125V20.75h-1.875v7.125l-3.125-3.125-1.313 1.313L16 31.438l5.375-5.375zm-5-20.625L11.938 7.25l-1.313-1.313L16 .562l5.375 5.375-1.313 1.313-3.125-3.125v7.125h-1.875V4.125zM0 15.063h32v1.875H0v-1.875z',
	    'split-h' => 'M4.125 15.063l3.125-3.125-1.313-1.313L.562 16l5.375 5.375 1.313-1.313-3.125-3.125h7.125v-1.875H4.125zm21.938-4.438L31.438 16l-5.375 5.375-1.313-1.313 3.125-3.125H20.75v-1.875h7.125l-3.125-3.125zM15.063 32V0h1.875v32h-1.875z',
	    'smallcap' => 'M11.313 11.125H0v3.813h1.875v-1.875h3.75v15.063H3.75v1.875h5.688v-1.875H7.5V13.063h3.813v1.875h1.875v-3.813h-1.875zM30.125 3.75H32v4.875h-1.875v-3h-7.563V28.25H24.5v1.875h-5.688V28.25h1.875V5.625h-7.5v3h-1.875V3.75h18.813z',
	    'shine' => 'M16 9.438c3.625 0 6.563 2.938 6.563 6.563S19.625 22.564 16 22.564s-6.563-2.938-6.563-6.563S12.375 9.438 16 9.438zm0 11.25c2.625 0 4.688-2.063 4.688-4.688S18.625 11.312 16 11.312 11.312 13.375 11.312 16s2.063 4.688 4.688 4.688zM16.938 7.5V1.875h-1.875V7.5h1.875zm-1.875 17v5.625h1.875V24.5h-1.875zm15.062-9.437H24.5v1.875h5.625v-1.875zM7.5 16.938v-1.875H1.875v1.875H7.5zm15.125-6.25l4-4-1.313-1.313-4 4zM9.375 21.313l-4 4 1.313 1.313 4-4zm13.25 0l-1.313 1.313 4 4 1.313-1.313zM9.375 10.688l1.313-1.313-4-4-1.313 1.313z',
	    'shift-right' => 'M15.75 6.875l-1.375 1.313 6.875 6.875H0v1.875h21.25l-6.875 6.875 1.375 1.313 9.125-9.125zM30.125 0H32v32h-1.875V0z',
	    'shift-left' => 'M32 16.938v-1.875H10.75l6.875-6.875-1.375-1.313L7.125 16l9.125 9.125 1.375-1.313-6.875-6.875H32zM0 32V0h1.875v32H0z',
	    'shield' => 'M28.25 1.938h1.875v12.813c0 10.438-13.313 15.125-13.875 15.313l-.313.125-.313-.125c-.563-.188-13.75-5.063-13.75-15.25V1.939h1.875c0 3.063 2.563 5.625 5.688 5.625 3.063 0 5.625-2.563 5.625-5.625h1.875c0 3.063 2.563 5.625 5.625 5.625 3.125 0 5.688-2.563 5.688-5.625zM3.75 14.813c0 7.188 8.188 11.563 11.313 13V6.875c-1.375 1.563-3.375 2.563-5.625 2.563s-4.313-1-5.688-2.563v7.938zm24.5-.063V6.875c-1.375 1.563-3.438 2.563-5.688 2.563s-4.25-1-5.625-2.563V27.75c3.188-1.375 11.313-5.688 11.313-13z',
	    'notepad' => 'M1.875 0h28.25v32H1.875V0zM28.25 30.125V1.875H24.5v2.063c1.063.375 1.875 1.438 1.875 2.625 0 1.563-1.313 2.875-2.875 2.875-1.5 0-2.813-1.313-2.813-2.875 0-1.188.813-2.25 1.875-2.625V1.875h-5.625v2.063c1.125.375 1.875 1.438 1.875 2.625 0 1.563-1.25 2.875-2.813 2.875s-2.813-1.313-2.813-2.875c0-1.188.75-2.25 1.875-2.625V1.875H9.436v2.063c1.063.375 1.875 1.438 1.875 2.625 0 1.563-1.313 2.875-2.813 2.875-1.563 0-2.875-1.313-2.875-2.875 0-1.188.813-2.25 1.875-2.625V1.875h-3.75v28.25h24.5zM9.438 6.563c0-.5-.438-.938-.938-.938-.563 0-1 .438-1 .938 0 .563.438.938 1 .938.5 0 .938-.375.938-.938zm7.5 0c0-.5-.438-.938-.938-.938s-.938.438-.938.938c0 .563.438.938.938.938s.938-.375.938-.938zm7.562 0c0-.5-.438-.938-1-.938-.5 0-.938.438-.938.938 0 .563.438.938.938.938.563 0 1-.375 1-.938z',
	    'server' => 'M32 6.563c0 .313-.063.625-.125.938H32v17.938c0 4.25-8.25 6.563-16 6.563S0 29.689 0 25.439V7.501h.125C.062 7.188 0 6.876 0 6.563 0 2.313 8.25 0 16 0s16 2.313 16 6.563zM16 1.875c-8.063 0-14.125 2.5-14.125 4.688 0 .75.75 1.625 2.063 2.313 2.688 1.5 7.188 2.438 12.063 2.438s9.375-.938 12.063-2.438c1.313-.688 2.063-1.563 2.063-2.313 0-2.188-6.063-4.688-14.125-4.688zm0 28.25c8.063 0 14.125-2.5 14.125-4.688v-3.125c-.313.25-.688.563-1.125.813-2.625 1.438-6.625 2.375-11.063 2.563-.625 0-1.313.063-1.938.063-5.188 0-10.063-1-13-2.625-.438-.25-.813-.563-1.125-.813v3.125c0 2.188 6.063 4.688 14.125 4.688zm12.063-8.687c1.313-.75 2.063-1.563 2.063-2.313v-3.063c-.313.25-.688.5-1.125.75-2.938 1.625-7.813 2.625-13 2.625s-10.063-1-13-2.625c-.438-.25-.813-.5-1.125-.75v3.063c0 .75.75 1.563 2.063 2.313 2.313 1.313 6.063 2.188 10.25 2.375.625 0 1.188.063 1.813.063 4.875 0 9.375-.938 12.063-2.438zm0-6.25c1.313-.75 2.063-1.563 2.063-2.313V9.812c-.313.25-.688.5-1.125.75-2.938 1.625-7.813 2.625-13 2.625s-10.063-1-13-2.625c-.438-.25-.813-.5-1.125-.75v3.063c0 .75.75 1.563 2.063 2.313 2.688 1.5 7.188 2.375 12.063 2.375s9.375-.875 12.063-2.375z',
	    'quote-right' => 'M13.75 12.938v.125c-.813 13.25-10.375 14.563-10.438 14.563l-.25-1.875c.25-.063 5.438-.813 7.75-7.313-1.063.688-2.313 1.125-3.688 1.125-3.688 0-6.625-3-6.625-6.625 0-3.688 2.938-6.688 6.625-6.688 3.625 0 6.625 3 6.625 6.688zm-6.625 4.75c2.625 0 4.75-2.125 4.75-4.75s-2.125-4.75-4.75-4.75-4.75 2.125-4.75 4.75 2.125 4.75 4.75 4.75zM31.5 13.063c-.813 13.25-10.375 14.563-10.438 14.563l-.25-1.875c.25-.063 5.5-.813 7.813-7.313-1.063.688-2.375 1.125-3.75 1.125-3.688 0-6.625-3-6.625-6.625 0-3.688 2.938-6.688 6.625-6.688s6.625 3 6.625 6.688v.125zm-6.625 4.625c2.625 0 4.75-2.125 4.75-4.75s-2.125-4.75-4.75-4.75-4.75 2.125-4.75 4.75 2.125 4.75 4.75 4.75z',
	    'quote-left' => 'M24.813 14.313c3.625 0 6.625 3 6.625 6.688 0 3.625-3 6.625-6.625 6.625-3.688 0-6.688-3-6.688-6.625 0-.063.063-.125.063-.188h-.063c.813-13.188 10.375-14.5 10.5-14.563l.188 1.875c-.25.063-5.438.813-7.75 7.375 1.063-.75 2.375-1.188 3.75-1.188zm0 11.437c2.625 0 4.75-2.125 4.75-4.75s-2.125-4.813-4.75-4.813S20 18.375 20 21s2.188 4.75 4.813 4.75zM7 14.313c3.688 0 6.688 3 6.688 6.688 0 3.625-3 6.625-6.688 6.625-3.625 0-6.625-3-6.625-6.625v-.188c.813-13.188 10.375-14.5 10.5-14.563l.188 1.875c-.25.063-5.438.813-7.75 7.375 1.063-.75 2.313-1.188 3.688-1.188zM7 25.75c2.625 0 4.813-2.125 4.813-4.75S9.625 16.187 7 16.187 2.25 18.375 2.25 21 4.375 25.75 7 25.75z',
	    'pulse' => 'M27 15.063h5v1.875h-6.25L23.625 12l-6.75 19.25L9.437 7l-3.125 9.938H-.001v-1.875h4.938l4.5-14.5L17 25.251l6.438-18.438z',
	    'printer' => 'M32 11.313v15.063h-5.625v5.813H5.625v-5.813H0V11.313h5.625V0h12.25l8.438 7.875v3.438h5.688zM18.813 3.438v4.063h4.375zM7.5 1.875v9.438h16.938V9.438h-7.5V1.875H7.5zm17 28.438v-9.438h-17v9.438h17zm5.625-5.813V13.187H1.875V24.5h3.75V19h20.75v5.5h3.75zm-9.437 0v-1.938H9.438V24.5h11.25zm-3.75 3.75v-1.875h-7.5v1.875h7.5zM5.625 16.938v-1.875H3.75v1.875h1.875zm3.813 0v-1.875H7.5v1.875h1.938z',
	    'power-off' => 'M30.125 17.875c0-6.563-4.688-12.375-11.063-13.75l-.438 1.813c5.563 1.25 9.625 6.25 9.625 11.938 0 6.75-5.5 12.25-12.25 12.25s-12.25-5.5-12.25-12.25c0-5.688 4.063-10.75 9.625-11.938l-.438-1.875C6.561 5.501 1.873 11.313 1.873 17.876c0 7.813 6.313 14.125 14.125 14.125s14.125-6.313 14.125-14.125zM16.938 0v18.813h-1.875V0h1.875z',
	    'plug' => 'M5.625 7.5h20.75v9.438c0 5.188-4.688 9.438-10.375 9.438s-10.375-4.25-10.375-9.438V7.5zM24.5 16.938v-7.5h-17v7.5c0 4.188 3.813 7.563 8.5 7.563s8.5-3.375 8.5-7.563zM13.188 5.625V0h-1.875v5.625h1.875zm7.5 0V0h-1.875v5.625h1.875zm-5.625 20.75V32h1.875v-5.625h-1.875zm5.625-11.312v-1.875h-9.375v1.875h9.375zm0 3.75v-1.875h-9.375v1.875h9.375z',
	    'pie-chart' => 'M28.188 16.813C27.75 23.251 22.438 28.251 16 28.251c-6.75 0-12.25-5.5-12.25-12.25 0-6.375 5-11.75 11.313-12.188l-.125-1.875c-7.313.5-13.063 6.688-13.063 14.063 0 7.813 6.313 14.125 14.125 14.125 7.375 0 13.563-5.813 14.063-13.188zM32 14.125C32 6.375 25.687 0 17.937 0h-.938v15.063h15v-.938zm-1.937-.937H18.875V1.938c6 .438 10.813 5.313 11.188 11.25z',
	    'paragraph' => 'M30.125 1.938v1.875h-7.5v26.313H20.75V3.813h-3.813v26.313h-1.875V16.813H9.374c-4.063 0-7.438-3.313-7.438-7.438s3.375-7.438 7.438-7.438h20.75zm-15.062 13V3.813H9.375c-3.063 0-5.563 2.5-5.563 5.563s2.5 5.563 5.563 5.563h5.688z',
	    'panel' => 'M0 0h32v32H0V0zm30.125 30.125V1.875H1.875v28.25h28.25zM7.5 19.25c-1.375-.375-2.375-1.688-2.375-3.188s1-2.813 2.375-3.188V7.499h1.938v5.375c1.375.375 2.375 1.688 2.375 3.188s-1 2.813-2.375 3.188v5.25H7.5v-5.25zm1-4.687c-.813 0-1.5.688-1.5 1.5s.688 1.438 1.5 1.438 1.438-.625 1.438-1.438-.625-1.5-1.438-1.5zm6.563.687c-1.375-.375-2.438-1.688-2.438-3.188s1.063-2.813 2.438-3.188V7.499h1.875v1.375c1.375.375 2.438 1.688 2.438 3.188s-1.063 2.813-2.438 3.188v9.25h-1.875v-9.25zM16 10.563c-.813 0-1.5.688-1.5 1.5s.688 1.438 1.5 1.438 1.5-.625 1.5-1.438-.688-1.5-1.5-1.5zm7.5 14.687c-1.813 0-3.313-1.5-3.313-3.375 0-1.5 1-2.75 2.375-3.188V7.499H24.5v11.188c1.375.438 2.375 1.688 2.375 3.188 0 1.875-1.5 3.375-3.375 3.375zm0-4.812c-.813 0-1.438.625-1.438 1.438s.688 1.5 1.438 1.5c.813 0 1.5-.688 1.5-1.5s-.688-1.438-1.5-1.438z',
	    'package' => 'M16.063-.063L32.001 6v20.125l-16 6-16-6V6zm12.312 6.688L16 1.937l-4.813 1.875L23.5 8.437zM16 11.313l4.875-1.875L8.5 4.813 3.625 6.626zM1.875 8v16.813l13.188 4.938V12.938zm15.063 21.75l13.188-4.938V7.999l-13.188 4.938V29.75z',
	    'music' => 'M27.813 8.375l-10.875-5v19.438c0 .125.063.188.063.313 0 3-2.5 5.5-5.5 5.5-3.063 0-5.5-2.5-5.5-5.5s2.438-5.5 5.5-5.5c1.375 0 2.625.563 3.563 1.375V.438l13.5 6.25zM11.5 26.75c2 0 3.563-1.625 3.563-3.625S13.5 19.5 11.5 19.5s-3.625 1.625-3.625 3.625S9.5 26.75 11.5 26.75z',
	    'music-alt' => 'M11.313.5l20.688 4.063v22.063c-.063 3-2.5 5.375-5.5 5.375s-5.5-2.438-5.5-5.5c0-3 2.5-5.5 5.5-5.5 1.375 0 2.625.563 3.625 1.438v-8.813l-16.938-3.313v11.875c-.125 2.938-2.5 5.25-5.5 5.25S2.25 25 2.25 22c0-3.063 2.438-5.5 5.438-5.5 1.375 0 2.625.5 3.625 1.375V.5zM7.688 25.563c1.938 0 3.5-1.5 3.625-3.375v-.375c-.125-1.938-1.688-3.438-3.625-3.438S4.125 20 4.125 22c0 1.938 1.625 3.563 3.563 3.563zm5.5-17.188l16.938 3.313V6.125L13.188 2.812v5.563zM26.5 30.125c2 0 3.625-1.625 3.625-3.625S28.5 22.937 26.5 22.937 22.937 24.5 22.937 26.5s1.563 3.625 3.563 3.625z',
	    'mouse' => 'M16 0c5.688 0 10.375 4.625 10.375 10.375v11.25C26.375 27.375 21.687 32 16 32S5.625 27.375 5.625 21.625v-11.25C5.625 4.625 10.313 0 16 0zm8.5 21.625v-11.25c0-4.688-3.813-8.5-8.5-8.5s-8.5 3.813-8.5 8.5v11.25c0 4.688 3.813 8.5 8.5 8.5s8.5-3.813 8.5-8.5zM16 6.563c1.563 0 2.813 1.313 2.813 2.875v3.75c0 1.563-1.25 2.813-2.813 2.813s-2.813-1.25-2.813-2.813v-3.75c0-1.563 1.25-2.875 2.813-2.875zm.938 6.625v-3.75c0-.563-.438-.938-.938-.938s-.938.375-.938.938v3.75c0 .5.438.938.938.938s.938-.438.938-.938z',
	    'mouse-alt' => 'M16 0c5.688 0 10.375 4.625 10.375 10.375v11.25C26.375 27.375 21.687 32 16 32S5.625 27.375 5.625 21.625v-11.25C5.625 4.625 10.313 0 16 0zm8.5 10.375C24.5 6 21.187 2.437 16.937 2v9.313H24.5v-.938zM15.063 2c-4.25.438-7.563 4-7.563 8.375v.938h7.563V2zM16 30.125c4.688 0 8.5-3.813 8.5-8.5v-8.438h-17v8.438c0 4.688 3.813 8.5 8.5 8.5z',
	    'money' => 'M20.188 18c1.5 1.25 2.375 3 2.375 4.875 0 3.188-2.438 5.75-5.625 6.188v2.938h-1.875v-2.938c-3.188-.438-5.625-3-5.625-6.188h1.875c0 2.125 1.625 3.938 3.75 4.313v-10.75l-3.438-2.625h-.063v-.063c-1.375-1.188-2.125-2.875-2.125-4.625 0-3.188 2.438-5.75 5.625-6.188V-.001h1.875v2.938c3.188.438 5.625 3 5.625 6.188l-.938.125-.938-.125c0-2.125-1.625-3.938-3.75-4.313v10.75l3.125 2.375c.063 0 .063.063.125.063zm-7.375-5.625l2.25 1.688v-9.25c-2.125.375-3.75 2.188-3.75 4.313 0 1.25.563 2.438 1.5 3.25zm4.125 14.813c2.125-.375 3.75-2.188 3.75-4.313 0-1.313-.625-2.5-1.688-3.375l-2.063-1.563v9.25z',
	    'microphone' => 'M16 22.563c-4.688 0-8.5-3.75-8.5-8.438V8.5c0-4.375 3.313-7.938 7.563-8.375V0h1.875v.125c4.25.438 7.563 4 7.563 8.375v5.625c0 4.688-3.813 8.438-8.5 8.438zM11.313 3.875C10.125 5.063 9.438 6.688 9.438 8.5v.938h13.125V8.5c0-1.813-.688-3.438-1.875-4.625V7.5h-1.875V2.562c-.563-.313-1.188-.5-1.875-.563v5.5h-1.875v-5.5c-.688.063-1.313.25-1.875.563V7.5h-1.875V3.875zm-1.875 7.438v2.813c0 3.625 2.938 6.563 6.563 6.563s6.563-2.938 6.563-6.563v-2.813H9.439zm18.812 1.875h-1.875v6.125c0 2.813-3 5.188-6.625 5.188h-7.5c-3.625 0-6.625-2.375-6.625-5.188v-6.125H3.75v6.125c0 3.875 3.813 7.063 8.5 7.063h2.813v5.625h1.875v-5.625h2.813c4.688 0 8.5-3.188 8.5-7.063v-6.125z',
	    'menu' => 'M30.125 5.625H1.875v3.813h28.25V5.625zM1.875 18.813v-3.75h28.25v3.75H1.875zm0 9.437V24.5h28.25v3.75H1.875z',
	    'menu-alt' => 'M30.125 3.75H9.437V7.5h20.688V3.75zM9.438 16.938v-3.75h20.688v3.75H9.438zm0 9.437v-3.813h20.688v3.813H9.438zM3.75 3.75c1.063 0 1.875.875 1.875 1.875 0 1.063-.813 1.875-1.875 1.875-1 0-1.875-.813-1.875-1.875 0-1 .875-1.875 1.875-1.875zm0 9.438c1.063 0 1.875.813 1.875 1.875s-.813 1.875-1.875 1.875c-1 0-1.875-.813-1.875-1.875s.875-1.875 1.875-1.875zm0 9.375c1.063 0 1.875.875 1.875 1.938 0 1-.813 1.875-1.875 1.875-1 0-1.875-.875-1.875-1.875 0-1.063.875-1.938 1.875-1.938z',
	    'map' => 'M19.75 8.375l10.375-3.063v20.813l-10.25 3-9.813-2.75H-.001V5.625l10.563.063zm-8.437-.5V24.75l7.5 2.125V10.062zM1.875 7.5v17h7.563v-17H1.875zM28.25 24.688V7.813l-7.563 2.25v16.875z',
	    'map-alt' => 'M28.25 7.5h1.875V28l-10.25 3-9.813-2.75H-.001V7.5h11.313v.063l1.938.438c.25-3.438 3.063-6.125 6.5-6.125 3.5 0 6.313 2.688 6.563 6.063l1.875-.375.063.125v-.188zm-8.5-3.75c-2.563 0-4.688 2.125-4.688 4.75 0 3.375 3.25 7.875 4.688 9.75 1.5-1.875 4.75-6.375 4.75-9.75 0-2.625-2.125-4.75-4.75-4.75zM11.313 9.5v17.125l7.5 2.125v-8.625c-.938-1.188-4.688-5.938-5.5-10.188zm-9.438-.062v16.938h7.563V9.438H1.875zm18.813 19.375l7.563-2.25V9.5l-2.063.438c-.75 4.25-4.5 9-5.5 10.188v8.688zm1.625-20.188c0 1.438-1.125 2.563-2.563 2.563-1.375 0-2.563-1.125-2.563-2.563s1.188-2.563 2.563-2.563c1.438 0 2.563 1.125 2.563 2.563zm-3.25 0c0 .375.313.688.688.688s.688-.313.688-.688-.313-.688-.688-.688-.688.313-.688.688z',
	    'loop' => 'M1.875 16.938c0-4.125 3.25-7.5 7.188-7.5h7.938l-3.063 3.063 1.313 1.313 5.375-5.313-5.375-5.375-1.313 1.313 3.063 3.063H9.063c-5 0-9.063 4.25-9.063 9.438s4.063 9.438 9.063 9.438v-1.875c-3.938 0-7.188-3.438-7.188-7.563zM22.938 7.5c5 0 9.063 4.25 9.063 9.438s-4.063 9.438-9.063 9.438H15l3.063 3.063-1.313 1.375-5.375-5.375 5.375-5.375 1.313 1.313L15 24.502h7.938c3.938 0 7.188-3.438 7.188-7.563s-3.25-7.5-7.188-7.5V7.501z',
	    'location-pin' => 'M16 .938c5.688 0 10.375 4.625 10.375 10.375 0 8.188-9.25 18.938-9.688 19.438l-.688.813-.688-.813c-.438-.5-9.688-11.25-9.688-19.438 0-5.75 4.688-10.375 10.375-10.375zm0 27.687c2.188-2.688 8.5-11.063 8.5-17.313 0-4.688-3.813-8.5-8.5-8.5s-8.5 3.813-8.5 8.5c0 6.25 6.313 14.625 8.5 17.313zm0-22.687c3.125 0 5.625 2.5 5.625 5.625s-2.5 5.625-5.625 5.625-5.625-2.5-5.625-5.625 2.5-5.625 5.625-5.625zm0 9.375c2.063 0 3.75-1.688 3.75-3.75s-1.688-3.75-3.75-3.75-3.75 1.688-3.75 3.75 1.688 3.75 3.75 3.75z',
	    'list' => 'M32 7.5H9.437v1.938H32V7.5zm-26.375 1c0-1.563-1.25-2.875-2.813-2.875S-.001 6.938-.001 8.5c0 1.5 1.25 2.813 2.813 2.813S5.625 10 5.625 8.5zm-1.875 0c0 .5-.438.938-.938.938S1.874 9 1.874 8.5c0-.563.438-1 .938-1s.938.438.938 1zm5.688 8.438v-1.875h22.563v1.875H9.438zM5.625 16c0-1.563-1.25-2.813-2.813-2.813S-.001 14.437-.001 16s1.25 2.813 2.813 2.813S5.625 17.563 5.625 16zM3.75 16c0 .5-.438.938-.938.938S1.874 16.5 1.874 16s.438-.938.938-.938.938.438.938.938zm5.688 8.5v-1.938h22.563V24.5H9.438zm-3.813-1c0-1.5-1.25-2.813-2.813-2.813S-.001 22-.001 23.5c0 1.563 1.25 2.875 2.813 2.875s2.813-1.313 2.813-2.875zm-1.875 0c0 .563-.438 1-.938 1s-.938-.438-.938-1c0-.5.438-.938.938-.938s.938.438.938.938z',
	    'light-bulb' => 'M16 0c5.688 0 10.375 4.938 10.375 11 0 4.563-1.938 7.063-3.438 9.125-1.25 1.688-2.25 2.938-2.25 4.938v4c0 1.625-1.25 2.938-2.813 2.938h-3.75c-1.563 0-2.813-1.313-2.813-2.938v-3.938c0-2-1.063-3.438-2.25-5.063-1.625-2.188-3.438-4.625-3.438-9.063 0-6.063 4.688-11 10.375-11zm1.875 30.125c.5 0 .938-.5.938-1.063v-3.063h-5.625v3.063c0 .563.438 1.063.938 1.063h3.75zM21.375 19c1.563-2 3.125-4.125 3.125-8 0-5.063-3.813-9.125-8.5-9.125S7.5 5.938 7.5 11c0 3.813 1.563 5.938 3.063 7.938 1.125 1.5 2.25 3.063 2.563 5.188h5.75c.313-2.125 1.438-3.625 2.5-5.125z',
	    'Italic' => 'M22.375 3.813H24.5V1.938h-5.688v1.875h1.5L9.624 28.251H7.499v1.875h5.688v-1.875h-1.5z',
	    'info' => 'M20.313 26.875h-3.375V11H11.75v1.875h3.313v14h-3.375v1.875h8.625v-1.875zm-5.25-19.25c-1.625 0-2.938-1.313-2.938-2.875 0-1.625 1.313-2.938 2.938-2.938 1.563 0 2.875 1.313 2.875 2.938 0 1.563-1.313 2.875-2.875 2.875z',
	    'infinite' => 'M32 15.063c0-4.125-3.375-7.563-7.5-7.563-2.188 0-4.25.938-5.688 2.563l-1.75 2.25 1.438 1.188 1.813-2.25c1.063-1.188 2.563-1.813 4.188-1.813 3.063 0 5.625 2.5 5.625 5.625s-2.563 5.625-5.625 5.625c-1.75 0-3.313-.75-4.375-2.063l-6.938-8.563-.125-.125V10C11.625 8.437 9.625 7.5 7.5 7.5 3.375 7.5 0 10.938 0 15.063s3.375 7.5 7.5 7.5c2.313 0 4.438-1 5.875-2.75h.063l1.5-1.938-1.438-1.188-1.563 1.938v-.063c-1.063 1.375-2.688 2.125-4.438 2.125-3.063 0-5.625-2.5-5.625-5.625s2.563-5.625 5.625-5.625c1.625 0 3.188.688 4.25 1.875l6.813 8.438c.063 0 .063.063.063.063l.063.063c1.438 1.688 3.5 2.688 5.813 2.688 4.125 0 7.5-3.375 7.5-7.5z',
	    'id-badge' => 'M0 5.625h32V28.25H0V5.625zm30.125 20.75V7.5H1.875v18.875h28.25zm-25.312-.937c.063-1.938 2.375-3.625 5.438-4l.813-.063v-3.188l-.438-.313c-.188-.125-.563-.625-.813-1.5v-.438l-.25-.063-.125-1.063c-.063-.313-.063-.563-.063-.813v-.375c0-.375 0-1 .063-1.063 0 0 .063-.063.25-.063.75-.063 1.063-.688 1.188-.938.125-.188.125-.25.688-.25.5 0 1.75 0 2.188.75l-.063.063c-.125.375-.375 1-.25 1.938v.5l-.188 1.188-.25.688c-.25.813-.563 1.25-.75 1.438l-.375.25v3.25l.813.063c3.063.375 5.25 2.063 5.313 4l1.875-.063c-.063-2.688-2.563-4.938-6.125-5.625v-.75c.375-.438.688-1.063.938-1.563.313-.25.625-.625.813-1.125.25-.75.125-1.438-.188-1.875v-.563c-.063-.5.063-.813.188-1.063.063-.313.25-.75.063-1.25-.5-1.438-2-2.188-4.125-2.125-1.313 0-1.813.563-2.188 1.188-1.813.313-1.75 2-1.75 3v.75c-.375.5-.438 1.25-.125 2 .188.438.438.75.75 1 .25.563.563 1.25 1.063 1.75v.563c-3.625.688-6.188 3-6.25 5.688zM28.25 15.063v-1.875h-9.438v1.875h9.438zm-1.875 3.75v-1.875h-7.563v1.875h7.563z',
	    'hummer' => 'M16.938 7.5v7.063h2.125v17.438h-6.125V14.563h2.125V7.5H7.5V0h13.25l6.75 7.5H16.937zm-7.5-5.625v3.75h13.875l-3.438-3.75H9.437zm7.75 28.25V16.437h-2.375v13.688h2.375z',
	    'home' => 'M26.375 30.125V13.187h1.875V32H3.75V13.187h1.875v16.938h5.688V18.812h9.375v11.313h5.688zm-13.187 0h5.625v-9.438h-5.625v9.438zm18.437-17.937L16 .688.375 12.188l1.125 1.5L16 3.063l14.5 10.625z',
	    'help' => 'M19.438 27.938c0-1.688-1.375-3.063-3.125-3.063-1.688 0-3.063 1.375-3.063 3.063s1.375 3.063 3.063 3.063c1.75 0 3.125-1.375 3.125-3.063zm2.5-23.5c1.375 1.75 1.813 3.875 1.563 5.063-.688 2.875-2.375 4.438-3.938 5.813-1.625 1.5-2.938 2.688-2.938 5.313H14.75c0-3.5 1.813-5.125 3.563-6.688 1.438-1.313 2.813-2.563 3.375-4.875.125-.563-.125-2.125-1.188-3.438-.688-.875-2-1.938-4.125-1.938-5.938 0-6.125 5.125-6.125 5.313l-1.875-.063c0-.063.25-7.125 8-7.125 2.875 0 4.625 1.438 5.563 2.625z',
	    'headphone' => 'M30.063 15.25c1.125.375 1.938 1.375 1.938 2.625v7.563c0 1.5-1.25 2.813-2.813 2.813h-2.813v-1.875H24.5v-9.438h1.875v-1.875h1.813C27.75 7.688 22.5 1.875 16 1.875S4.25 7.688 3.812 15.063h1.813v1.875H7.5v9.438H5.625v1.875H2.812c-1.563 0-2.813-1.313-2.813-2.813v-7.563c0-1.25.813-2.25 1.938-2.625C2.25 6.75 8.437 0 16 0s13.75 6.75 14.063 15.25zM3.75 26.375v-9.438h-.938c-.5 0-.938.438-.938.938v7.563c0 .5.438.938.938.938h.938zm26.375-.937v-7.563c0-.5-.438-.938-.938-.938h-.938v9.438h.938c.5 0 .938-.438.938-.938z',
	    'harddrives' => 'M25.438 23.5c1.5 0 2.813 1.313 2.813 2.875s-1.313 2.813-2.813 2.813c-1.563 0-2.875-1.25-2.875-2.813s1.313-2.875 2.875-2.875zm0 3.813c.5 0 .938-.438.938-.938 0-.563-.438-.938-.938-.938-.563 0-.938.375-.938.938 0 .5.375.938.938.938zM32 5.938v12h-2l2 2.25v11.813H0V20.126l1.75-2.188H0V5.813L5.5 0h21zM6.313 1.875L2.75 5.625h26.438l-3.5-3.75H6.313zm-4.438 28.25h28.25v-7.563H1.875v7.563zm28.063-9.437l-2.375-2.75H4.188l-2.25 2.75h28zM1.875 16.063h28.25V7.5H1.875v8.563zm23.563-6.625c1.5 0 2.813 1.25 2.813 2.813s-1.313 2.813-2.813 2.813c-1.563 0-2.875-1.25-2.875-2.813s1.313-2.813 2.875-2.813zm0 3.75c.5 0 .938-.438.938-.938 0-.563-.438-.938-.938-.938-.563 0-.938.375-.938.938 0 .5.375.938.938.938z',
	    'harddrive' => 'M26.625 5.625L32 14v12.375H0v-12.5l5.375-8.25h21.25zM6.438 7.5l-3.75 5.688h26.563L25.563 7.5H6.438zm-4.563 17h28.25v-9.438H1.875V24.5zm23.563-7.562c1.5 0 2.813 1.25 2.813 2.813s-1.313 2.875-2.813 2.875c-1.563 0-2.875-1.313-2.875-2.875s1.313-2.813 2.875-2.813zm0 3.75c.5 0 .938-.375.938-.938 0-.5-.438-.938-.938-.938-.563 0-.938.438-.938.938 0 .563.375.938.938.938z',
	    'gift' => 'M14.75 10.563c-2.063-.375-6.188-1.375-8.625-3.375-.938-.813-1.438-1.875-1.438-3 0-1.188.5-2.25 1.438-3 1.813-1.563 4.813-1.563 6.625 0 1.5 1.25 2.563 3.188 3.188 4.875.688-1.688 1.688-3.625 3.25-4.938 1.75-1.5 4.813-1.5 6.563 0 .938.813 1.438 1.875 1.438 3.063 0 1.125-.5 2.188-1.438 3-2.375 2-6.563 3-8.563 3.375v.375L16 10.75h-.063l-1.25.188zm5.625-8c-1.813 1.625-2.813 4.438-3.313 6.125 1.938-.375 5.563-1.313 7.5-2.938.5-.438.75-1 .75-1.563 0-.625-.25-1.188-.75-1.625-.563-.438-1.313-.688-2.063-.688-.813 0-1.563.25-2.125.688zm-13 0c-.5.438-.813 1-.813 1.625 0 .563.313 1.125.813 1.563 1.938 1.625 5.5 2.5 7.438 2.875-.438-1.625-1.438-4.5-3.313-6.063-.563-.438-1.25-.688-2.063-.688s-1.5.25-2.063.688zM32 11.313v7.5h-1.875v13.188H1.875V18.813H0v-7.5h32zm-18.875 1.875l2.125 11.938 2.438-2.25 3.125 1.313-2-11h-5.688zm-11.25 0v3.75h10l-.625-3.75H1.875zM28.25 30.125V18.812h-6.5l1.5 8.438-5.188-2.188-4.063 3.813-1.813-10.063H3.748v11.313h24.5zm1.875-13.187v-3.75h-9.438l.688 3.75h8.75z',
	    'game' => 'M16.938 7.5c6.688.188 15.063 2.438 15.063 4.688v13.25c0 1.563-1.25 2.813-2.813 2.813h-3.5l-3.563-7.375c-1.125.188-3.438.5-6.188.5s-4.938-.313-6-.5l-3.75 7.375H2.812c-1.563 0-2.813-1.25-2.813-2.813v-13.25c0-2.25 8.375-4.5 15.063-4.688V1.875h1.875V7.5zm13.187 17.938v-13c-.938-.813-6.375-2.875-13.188-3.063v.063h-1.875v-.063c-6.813.188-12.25 2.25-13.188 3.063v13c0 .5.438.938.938.938h2.25l3.875-7.688.688.188c.063 0 2.625.625 6.313.625 3.625 0 6.5-.625 6.5-.625l.75-.125 3.688 7.625h2.313c.5 0 .938-.438.938-.938zM9.438 13.188v-1.875H7.5v1.875H5.625v1.938H7.5v1.875h1.938v-1.875h1.875v-1.938H9.438zM23.5 17c-1.5 0-2.813-1.313-2.813-2.875 0-1.5 1.313-2.813 2.813-2.813 1.563 0 2.875 1.313 2.875 2.813 0 1.563-1.313 2.875-2.875 2.875zm0-3.812c-.5 0-.938.438-.938.938 0 .563.438 1 .938 1 .563 0 1-.438 1-1 0-.5-.438-.938-1-.938z',
	    'filter' => 'M1 0h30L18.812 17.375V32h-5.625V17.375zm15.938 16.75L27.376 1.875H4.626L15.064 16.75v13.375h1.875V16.75z',
	    'files' => 'M23.5 0L32 7.875v18.5h-9.438V24.5h7.563V9.437h-7.563V1.874h-9.375v1.938h-1.875V-.001H23.5zm1 3.438v4.063h4.375zM0 5.625h12.25l8.438 7.875V32H0V5.625zm13.188 3.5v4.063h4.375zm-11.313 21h16.938V15.062h-7.5V7.499H1.875v22.625z',
	    'file' => 'M18.188 0l10.063 10v22h-24.5V0h14.438zm.625 3.25v6.188h6.188zM5.625 30.125h20.75V11.312h-9.438V1.874H5.624v28.25z',
	    'eraser' => 'M25.313 7.938c1.375.75 1.813 2.5 1.063 3.813l-10.75 18.375h-8.25l-5.938-3.438c-1.375-.75-1.813-2.5-1.063-3.813L11.688 3.312c.75-1.313 2.563-1.813 3.813-1.063zM14.5 28.25l4-6.875-11.313-6.563-5.188 9c-.25.438-.125 1 .375 1.25l5.5 3.188h6.625zm10.188-17.437c.313-.438.125-1-.313-1.25l-9.813-5.688c-.125-.063-.25-.125-.438-.125-.313 0-.625.188-.813.5l-5.188 8.938 11.375 6.563zM32 28.25H18.812v1.875H32V28.25z',
	    'envelope' => 'M3.75 0h24.5v32H3.75V0zm5.063 7.5h14.375l2.625-5.625H6.188zM7.625 9.438l-2-4.25v23.313L7.5 26.376h7.563V9.438H7.625zm.75 18.812L6.75 30.125h18.5l-1.625-1.875H8.375zM24.5 26.375l1.875 2.125V5.125l-2 4.313h-7.438v16.938H24.5z',
	    'download' => 'M32 30.125H0V32h32v-1.875zm-6.875-13.437L16 25.813l-9.125-9.125 1.313-1.375 6.875 6.875V0h1.875v22.188l6.875-6.875z',
	    'direction' => 'M31.313 10.188l-5.25 6.75h-9.125v15.063h-1.875V16.938H1.875V3.75h13.188V0h1.875v3.75h9.125zm-14.375 4.875h8.188l3.813-4.875-3.813-4.563H3.751v9.438h13.188z',
	    'direction-alt' => 'M16.938 11.313v3.75h11.313v9.438H16.938v7.5h-1.875v-7.5H6.25l-3.688-4.875 3.688-4.563h8.813v-3.75H3.75V1.875h11.313V0h1.875v1.875h8.813L29.439 6.5l-3.688 4.813h-8.813zM5.625 3.75v5.688h19.188l2.25-2.938-2.188-2.75H5.625zm20.75 18.813v-5.625H7.125l-2.188 2.75 2.25 2.875h19.188z',
	    'dashboard' => 'M32 21.625c0-8.813-7.188-16-16-16s-16 7.188-16 16v.938h11.625v-1.875H1.937c.188-3.188 1.438-6.063 3.438-8.313l1.5 1.5 1.313-1.313-1.438-1.5c2.25-2 5.125-3.25 8.313-3.5v5.625h1.875V7.562c3.188.25 6.063 1.5 8.375 3.5l-1.563 1.5 1.375 1.313 1.5-1.5c2 2.25 3.25 5.125 3.438 8.313h-9.688v1.875H32v-.938zm-12.25 0c0-2.063-1.688-3.75-3.75-3.75-.188 0-.375.063-.563.063l-4-7-1.625.938 3.875 6.813c-.875.688-1.438 1.75-1.438 2.938 0 2.125 1.688 3.813 3.75 3.813s3.75-1.688 3.75-3.813zm-1.875 0c0 1.063-.813 1.875-1.875 1.875s-1.875-.813-1.875-1.875c0-1 .813-1.875 1.875-1.875s1.875.875 1.875 1.875z',
	    'control-stop' => 'M5.625 5.625h20.75v20.75H5.625V5.625zM24.5 24.5v-17h-17v17h17z',
	    'control-shuffle' => 'M16.813 12.938l1.5 1.188 2-2.563c1.25-1.375 3.063-2.125 4.875-2.125h3.625l-3.125 3.063 1.313 1.313 5.375-5.313-5.375-5.375-1.313 1.313 3.125 3.063h-3.625c-2.375 0-4.75 1.063-6.313 2.875v.063zM11 20.125l1.75-2.188 1.5 1.188-1.813 2.188c-1.625 2-4 3.188-6.563 3.188H-.001v-1.938h5.875c2 0 3.875-.875 5.125-2.438zm14.688-.625l1.313-1.375 5.375 5.375-5.375 5.375-1.313-1.313 3.125-3.063h-3.625c-2.563 0-5-1.188-6.625-3.188l.063-.063-7.875-9.625c-1.25-1.438-3-2.188-4.875-2.188H.001V7.497h5.875c2.375 0 4.625 1.063 6.188 2.813l.063-.063 8 9.938c1.25 1.5 3.125 2.375 5.063 2.375h3.625z',
	    'control-play' => 'M5.625 5.063L27.5 15.938l-21.875 11V5.063zM7.5 8.125v15.75l15.813-7.938z',
	    'control-pause' => 'M5.625 28.25V3.75h7.563v24.5H5.625zM7.5 5.625v20.75h3.813V5.625H7.5zM18.813 3.75h7.563v24.5h-7.563V3.75zM24.5 26.375V5.625h-3.813v20.75H24.5z',
	    'control-forward' => 'M5.625 4.563l13.75 11.375-13.75 11.5V4.563zm1.875 4v14.813l8.938-7.438zm21.25 7.375L16.625 5.875l-1.25 1.438 10.438 8.625-10.438 8.75 1.25 1.438z',
	    'control-backward' => 'M12.625 15.938l13.75-11.375v22.875zM24.5 23.375V8.562l-8.938 7.375zM6.188 15.938l10.438-8.625-1.25-1.438L3.251 15.938l12.125 10.188 1.25-1.438z',
	    'cloud' => 'M24 8.5c4.438 0 8 3.563 8 8 0 4.375-3.563 8-8 8H6.125C2.75 24.5 0 21.75 0 18.375c0-3.438 2.938-6.25 6.313-6.125 1.313-3.438 4.563-5.688 8.25-5.688 2.375 0 4.563.938 6.25 2.625 1-.5 2.125-.688 3.188-.688zm0 14.063c3.375 0 6.125-2.688 6.125-6.063s-2.75-6.125-6.125-6.125c-1 0-2 .25-2.938.75l-.688.375-.5-.563c-1.313-1.563-3.25-2.438-5.313-2.438-3.125 0-5.813 2-6.688 5l-.25.813-.813-.125c-.25-.063-.438-.063-.688-.063-2.313 0-4.25 1.875-4.25 4.25 0 2.313 1.938 4.188 4.25 4.188h17.875z',
	    'cloud-up' => 'M32 12.688c0-4.375-3.563-8-8-8-1.063 0-2.125.25-3.188.688-1.688-1.625-3.875-2.563-6.25-2.563-3.688 0-6.938 2.25-8.25 5.688-3.438-.188-6.313 2.625-6.313 6.063 0 3.375 2.75 6.125 6.125 6.125h6.938v-1.875H6.124c-2.313 0-4.25-1.875-4.25-4.25 0-2.313 1.938-4.188 4.25-4.188.25 0 .438 0 .688.063l.813.125.25-.813c.875-3 3.563-5.063 6.688-5.063 2.063 0 4 .938 5.313 2.5l.5.563.688-.375c.938-.5 1.938-.813 2.938-.813 3.375 0 6.125 2.75 6.125 6.125s-2.75 6.125-6.125 6.125h-5.188v1.875h5.188c4.438 0 8-3.563 8-8zm-11.937 4l-3.125-3.125v14.688h-1.875V13.563l-3.125 3.125-1.313-1.375L16 9.938l5.375 5.375z',
	    'cloud-down' => 'M32 12.688c0-4.375-3.563-8-8-8-1.063 0-2.125.25-3.188.688-1.688-1.625-3.875-2.563-6.25-2.563-3.688 0-6.938 2.25-8.25 5.688-3.438-.188-6.313 2.625-6.313 6.063 0 3.375 2.75 6.125 6.125 6.125h6.938v-1.875H6.124c-2.313 0-4.25-1.875-4.25-4.25 0-2.313 1.938-4.188 4.25-4.188.25 0 .438 0 .688.063l.813.125.25-.813c.875-3 3.563-5.063 6.688-5.063 2.063 0 4 .938 5.313 2.5l.5.563.688-.375c.938-.5 1.938-.813 2.938-.813 3.375 0 6.125 2.75 6.125 6.125s-2.75 6.125-6.125 6.125h-5.188v1.875h5.188c4.438 0 8-3.563 8-8zM16.938 25.875l3.125-3.125 1.313 1.313-5.375 5.375-5.375-5.375 1.313-1.313 3.125 3.125V11.312h1.875v14.563z',
	    'clipboard' => 'M30.125 3.75h-4.313v1.875h2.438v24.5H3.75v-24.5h2.375V3.75h-4.25V32h28.25V3.75zM24.5 9.438V1.875h-5.813C18.249.812 17.249 0 15.999 0s-2.25.813-2.688 1.875H7.498v7.563h17zM22.563 3.75V7.5H9.438V3.75h5.625v-.938c0-.5.438-.938.938-.938s.938.438.938.938v.938h5.625z',
	    'car' => 'M32 18.813v9.375h-3.75v.063c0 2.063-1.688 3.75-3.75 3.75-2.125 0-3.813-1.688-3.813-3.75v-.063h-9.375v.063c0 2.063-1.688 3.75-3.813 3.75-2.063 0-3.75-1.688-3.75-3.75v-.063h-3.75v-9.375h3.875l5.625-7.5h14.938l3.875 7.5H32zm-5.812 0l-2.875-5.625h-4.438v5.625h7.313zm-15.75-5.625L6.25 18.813H17v-5.625h-6.563zM7.5 30.125c1.063 0 1.938-.875 1.938-1.875 0-1.063-.875-1.875-1.938-1.875-1 0-1.875.813-1.875 1.875 0 1 .875 1.875 1.875 1.875zm17 0c1 0 1.875-.875 1.875-1.875 0-1.063-.875-1.875-1.875-1.875-1.063 0-1.938.813-1.938 1.875 0 1 .875 1.875 1.938 1.875zm5.625-3.812v-5.625H1.875v5.625h2.438c.688-1.125 1.875-1.813 3.188-1.813 1.375 0 2.563.688 3.25 1.813h10.5c.688-1.125 1.875-1.813 3.25-1.813 1.313 0 2.5.688 3.188 1.813h2.438z',
	    'calendar' => 'M26.375 3.75H32V32H0V3.75h5.625V1.875h5.688V3.75h9.375V1.875h5.688V3.75zm-3.812 0V7.5h1.938V3.75h-1.938zM7.5 3.75V7.5h1.938V3.75H7.5zm22.625 26.375V13.312H1.875v16.813h28.25zM1.875 11.438h28.25V5.625h-3.75v3.813h-5.688V5.625h-9.375v3.813H5.624V5.625h-3.75v5.813z',
	    'book' => 'M31.25 2.188l.75.125v26.125l-1.125-.188s-2.313-.438-5.25-.438c-2.125 0-4.875.25-7.25 1.188v1.563h-4.75V29c-2.188-.813-4.688-1.313-7.438-1.313-2.875 0-5 .563-5 .563l-1.188.313V2.375l.688-.188c.125 0 2.313-.625 5.5-.625 3.625 0 6.938.75 9.813 2.188 2.438-1.375 5.688-2.063 9.625-2.063 3.125 0 5.5.438 5.625.5zm-29.375 24c1-.188 2.5-.375 4.313-.375 3.25 0 6.25.625 8.875 1.813V5.438C12.5 4.125 9.5 3.5 6.188 3.5c-1.875 0-3.438.188-4.313.375v22.313zm28.25.062V3.875c-.938-.125-2.563-.313-4.5-.313-2.5 0-6 .375-8.688 1.813v22.188c2.313-1.063 5.188-1.625 8.688-1.625 1.875 0 3.5.188 4.5.313z',
	    'bell' => 'M28.813 26.563l1.688 1.625H1.563l1.625-1.563c0-.063 2.438-2.563 2.438-6.063v-6.188c0-5.875 4.688-10.625 10.375-10.625s10.375 4.75 10.375 10.625v6.188c0 3.563 2.438 6 2.438 6zm-23.063-.25h20.5c-.875-1.25-1.75-3.313-1.75-5.75v-6.188c0-4.813-3.813-8.75-8.5-8.75s-8.5 3.938-8.5 8.75v6.188c0 2.438-.938 4.438-1.75 5.75zM16.938 3.75V1.875h-1.875V3.75h1.875zm0 24.5c0 .5-.438.938-.938.938s-.938-.438-.938-.938h-1.875c0 1.563 1.25 2.813 2.813 2.813s2.813-1.25 2.813-2.813h-1.875z',
	    'basketball' => 'M16 0c8.875 0 16 7.188 16 16s-7.125 16-16 16C7.187 32 0 24.812 0 16S7.188 0 16 0zm8.438 15.063h5.688c-.188-2.813-1.25-5.438-2.875-7.563-1.625 2.188-2.625 4.813-2.813 7.563zm5.687 1.875h-5.688c.188 2.75 1.188 5.375 2.813 7.563 1.625-2.125 2.688-4.75 2.875-7.563zM26 6.063c-2.313-2.375-5.5-3.875-9.063-4.125v13.125h5.625c.188-3.313 1.375-6.438 3.438-9zM15.063 1.938c-3.5.25-6.688 1.75-9 4.125 2 2.563 3.25 5.688 3.438 9h5.563V1.938zM1.938 15.063h5.688c-.188-2.75-1.188-5.375-2.813-7.563-1.625 2.125-2.688 4.75-2.875 7.563zm5.687 1.875H1.937c.188 2.813 1.25 5.438 2.875 7.563 1.625-2.188 2.625-4.813 2.813-7.563zm-1.562 9c2.313 2.375 5.5 3.875 9 4.125V16.938H9.5c-.188 3.313-1.375 6.438-3.438 9zm10.875 4.125c3.563-.25 6.75-1.75 9.063-4.125-2.063-2.563-3.25-5.688-3.438-9h-5.625v13.125z',
	    'bar-chart' => 'M32 30.125H0V32h32v-1.875zM3.75 18.813v9.438H1.875V16.938h7.563v11.313H7.5v-9.438H3.75zm9.438-5.625v15.063h-1.875V11.313h7.5v16.938h-1.875V13.188h-3.75zm9.375-7.563V28.25h-1.875V3.75h7.563v24.5h-1.875V5.625h-3.813z',
	    'bar-chart-alt' => 'M32 30.125H0V32h32v-1.875zm-9.437-11.312v9.438h-1.875V16.938h7.563v11.313h-1.875v-9.438h-3.813zm-9.375-5.625v15.063h-1.875V11.313h7.5v16.938h-1.875V13.188h-3.75zM3.75 5.625V28.25H1.875V3.75h7.563v24.5H7.5V5.625H3.75z',
	    'back-right' => 'M27.438 28.25H14.125c-4.688 0-8.5-3.813-8.5-8.5 0-4.625 3.813-8.438 8.5-8.438h5.5l-5 4.938 1.313 1.375 7.25-7.25-7.25-7.25-1.313 1.313 5 5h-5.5c-5.688 0-10.375 4.625-10.375 10.313 0 5.75 4.688 10.375 10.375 10.375h13.313v-1.875z',
	    'back-left' => 'M28.25 14.125c0-5.688-4.688-10.375-10.375-10.375H4.562v1.875h13.313c4.688 0 8.5 3.813 8.5 8.5s-3.813 8.438-8.5 8.438h-5.5l5-4.938-1.313-1.375-7.25 7.25 7.25 7.313 1.313-1.375-5-4.938h5.5c5.688 0 10.375-4.688 10.375-10.375z',
	    'arrows-corner' => 'M28.25 17.875h-1.875V25L7 5.625h7.125V3.75H3.75v10.375h1.875V6.937l19.438 19.438h-7.188v1.875H28.25V17.875z',
	    'archive' => 'M32 3.75v7.563h-1.875v20.688H1.875V11.313H0V3.75h32zm-3.75 26.375V11.312H3.75v18.813h24.5zm1.875-20.687V5.625H1.875v3.813h28.25zm-18.812 11.25C9.188 20.688 7.5 19 7.5 16.938s1.688-3.75 3.813-3.75h9.438c2.063 0 3.75 1.688 3.75 3.75s-1.688 3.75-3.75 3.75h-9.438zm0-5.625c-1.063 0-1.875.813-1.875 1.875s.813 1.875 1.875 1.875h9.438c1 0 1.875-.813 1.875-1.875s-.875-1.875-1.875-1.875h-9.438z',
	    'anchor' => 'M28.813 23.688l-1.688.875-1.25-2.438c-1.313 4.188-5.25 7.313-9.875 7.313s-8.563-3.125-9.875-7.313l-1.25 2.438-1.688-.875 2.938-5.875 5.938 2.938-.875 1.688-3.5-1.75c.688 3.563 3.688 6.313 7.375 6.75v-14.25H12.25v-1.875h2.813v-2c-2.125-.438-3.75-2.313-3.75-4.625 0-2.563 2.063-4.688 4.688-4.688s4.688 2.125 4.688 4.688c0 2.313-1.625 4.188-3.75 4.625v2h2.813v1.875h-2.813v14.25c3.688-.438 6.688-3.188 7.375-6.75l-3.5 1.75-.875-1.688 5.875-2.938zm-15.625-19c0 1.563 1.25 2.813 2.813 2.813s2.813-1.25 2.813-2.813-1.25-2.813-2.813-2.813-2.813 1.25-2.813 2.813z',
	    'align-right' => 'M32 3.75H0v1.875h32V3.75zM5.625 13.188v-1.875H32v1.875H5.625zM0 20.688v-1.875h32v1.875H0zm13.188 7.562v-1.875h18.813v1.875H13.188z',
	    'align-left' => 'M32 3.75H0v1.875h32V3.75zm-5.625 7.563v1.875H0v-1.875h26.375zM0 20.688v-1.875h32v1.875H0zm0 7.562v-1.875h18.813v1.875H0z',
	    'align-justify' => 'M32 3.75H0v1.875h32V3.75zM0 13.188v-1.875h32v1.875H0zm0 7.5v-1.875h32v1.875H0zm0 7.562v-1.875h32v1.875H0z',
	    'align-center' => 'M32 3.75H0v1.875h32V3.75zM2.813 11.313h26.375v1.875H2.813v-1.875zM0 20.688v-1.875h32v1.875H0zm6.563 7.562v-1.875h18.875v1.875H6.563z',
	    'alert' => 'M15.938 2.813l15.688 27.313H.376zm0 3.812L3.625 28.25h24.75zm1 13.938v-7.375h-1.875v7.375h1.875zm.937 3.937c0-1-.813-1.875-1.875-1.875s-1.875.875-1.875 1.875c0 1.063.813 1.938 1.875 1.938s1.875-.875 1.875-1.938z',
	    'alarm-clock' => 'M27.688 12.813c.938 1.813 1.5 3.813 1.5 6 0 3.25-1.188 6.188-3.063 8.438l2.375 3.25-1.5 1.125-2.25-3c-2.313 2.063-5.375 3.375-8.75 3.375s-6.438-1.313-8.75-3.375l-2.25 3-1.5-1.125 2.375-3.25C4 25.001 2.812 22.063 2.812 18.813c0-2.188.563-4.188 1.5-6-.938-1-1.5-2.25-1.5-3.625 0-2.813 2.313-5.125 5.125-5.125 1.688 0 3.188.813 4.188 2.188.938-.313 1.938-.5 2.938-.563V3.75h-1.875V1.875h5.625V3.75h-1.875v1.938c1 .063 2 .25 2.938.563 1-1.375 2.5-2.188 4.188-2.188 2.813 0 5.125 2.313 5.125 5.125 0 1.375-.563 2.625-1.5 3.625zm-3.625-6.875c-.938 0-1.75.375-2.375 1.063 2 .938 3.688 2.375 5 4.125.375-.563.625-1.25.625-1.938 0-1.75-1.5-3.25-3.25-3.25zM4.688 9.188c0 .688.25 1.375.625 1.938 1.313-1.75 3-3.188 5-4.188-.625-.625-1.438-1-2.375-1-1.75 0-3.25 1.5-3.25 3.25zM16 30.125c6.25 0 11.313-5.063 11.313-11.313 0-6.188-5.063-11.313-11.313-11.313S4.687 12.624 4.687 18.812c0 6.25 5.063 11.313 11.313 11.313zm.938-11.312v-5.625h-1.875v7.5h9.438v-1.875h-7.563z',
	    'agenda' => 'M26.375 3.75h3.75v24.5h-3.75V32h-24.5V0h24.5v3.75zM3.75 30.125H7.5V1.875H3.75v28.25zm20.75 0V1.875H9.437v28.25H24.5zm3.75-3.75v-5.688h-1.875v5.688h1.875zm0-7.562v-5.625h-1.875v5.625h1.875zm-1.875-7.5h1.875V5.625h-1.875v5.688zM11.313 7.5v1.938h9.375V7.5h-9.375zm0 3.813v1.875h7.5v-1.875h-7.5z',
	    'write' => 'M21.938 0l10.063 10v22h-23.5v-1.875h21.625V11.312h-9.438V1.874H7.563v1.875h.875c1.563 0 2.813 1.25 2.813 2.813v16.125l-4.625 9.375-4.75-9.313V6.561c0-1.563 1.25-2.813 2.813-2.813h1v-3.75h16.25zM7.375 26.375l2-4.125v-11H7.5v11.375H5.625V11.25H3.75v11l2.063 4.125h1.563zm2-19.812c0-.5-.438-.938-.938-.938h-3.75c-.5 0-.938.438-.938.938v2.813h5.625V6.563zM22.563 3.25v6.188h6.188z',
	    'window' => 'M0 1.875h32v28.25H0V1.875zM30.125 3.75H1.875v5.688h28.25V3.75zm-28.25 24.5h28.25V11.312H1.875V28.25zM13.188 7.5V5.625h-1.875V7.5h1.875zm-3.75 0V5.625H7.5V7.5h1.938zm-3.813 0V5.625H3.75V7.5h1.875z',
	    'widgetized' => 'M3.75 0v1.875h1.875V0H3.75zM7.5 1.875V0h1.938v1.875H7.5zm3.813 0V0h1.875v1.875h-1.875zm3.75 0V0h1.875v1.875h-1.875zm3.75 0V0h1.875v1.875h-1.875zm3.75 0V0h1.938v1.875h-1.938zm3.812 0V0h1.875v1.875h-1.875zM3.75 16.938v-1.875h1.875v1.875H3.75zm3.75 0v-1.875h1.938v1.875H7.5zm3.813 0v-1.875h1.875v1.875h-1.875zm7.5 0v-1.875h1.875v1.875h-1.875zm3.75 0v-1.875h1.938v1.875h-1.938zm3.812 0v-1.875h1.875v1.875h-1.875zM3.75 32v-1.875h1.875V32H3.75zm3.75 0v-1.875h1.938V32H7.5zm3.813 0v-1.875h1.875V32h-1.875zm3.75 0v-1.875h1.875V32h-1.875zm3.75 0v-1.875h1.875V32h-1.875zm3.75 0v-1.875h1.938V32h-1.938zm3.812 0v-1.875h1.875V32h-1.875zm3.75-32H32v1.875h-1.875V0zm0 5.625V3.75H32v1.875h-1.875zm0 3.813V7.5H32v1.938h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.812v-1.938H32V24.5h-1.875zm0 3.75v-1.875H32v1.875h-1.875zM15.063 5.625V3.75h1.875v1.875h-1.875zm0 3.813V7.5h1.875v1.938h-1.875zm0 3.75v-1.875h1.875v1.875h-1.875zm0 3.75v-1.875h1.875v1.875h-1.875zm0 3.75v-1.875h1.875v1.875h-1.875zm0 3.812v-1.938h1.875V24.5h-1.875zm0 3.75v-1.875h1.875v1.875h-1.875zM30.125 32v-1.875H32V32h-1.875zM0 1.875V0h1.875v1.875H0zm0 3.75V3.75h1.875v1.875H0zm0 3.813V7.5h1.875v1.938H0zm0 3.75v-1.875h1.875v1.875H0zm0 3.75v-1.875h1.875v1.875H0zm0 3.75v-1.875h1.875v1.875H0zM0 24.5v-1.938h1.875V24.5H0zm0 3.75v-1.875h1.875v1.875H0zM0 32v-1.875h1.875V32H0z',
	    'widget' => 'M3.75 0v1.875h1.875V0H3.75zm5.688 0v1.875H7.5V0h1.938zm3.75 0v1.875h-1.875V0h1.875zm3.75 0v1.875h-1.875V0h1.875zm3.75 0v1.875h-1.875V0h1.875zM24.5 0v1.875h-1.938V0H24.5zm1.875 1.875V0h1.875v1.875h-1.875zM3.75 32v-1.875h1.875V32H3.75zm3.75 0v-1.875h1.938V32H7.5zm3.813 0v-1.875h1.875V32h-1.875zm3.75 0v-1.875h1.875V32h-1.875zm3.75 0v-1.875h1.875V32h-1.875zm3.75 0v-1.875h1.938V32h-1.938zm3.812 0v-1.875h1.875V32h-1.875zm3.75-32H32v1.875h-1.875V0zm0 5.625V3.75H32v1.875h-1.875zm0 3.813V7.5H32v1.938h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.812v-1.938H32V24.5h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.75v-1.875H32V32h-1.875zM0 1.875V0h1.875v1.875H0zm0 3.75V3.75h1.875v1.875H0zm0 3.813V7.5h1.875v1.938H0zm0 3.75v-1.875h1.875v1.875H0zm0 3.75v-1.875h1.875v1.875H0zm0 3.75v-1.875h1.875v1.875H0zM0 24.5v-1.938h1.875V24.5H0zm0 3.75v-1.875h1.875v1.875H0zM0 32v-1.875h1.875V32H0zm25.375-17.062l-.125-.625-2.688-.813c-.063-.125-.063-.25-.125-.375l1.313-2.5-.375-.5c-.438-.563-.938-1.063-1.5-1.5l-.5-.375-2.5 1.313c-.125-.063-.25-.063-.375-.125l-.813-2.688-.625-.125c-.688-.063-1.438-.063-2.125 0l-.625.125-.813 2.688c-.125.063-.25.063-.375.125l-2.5-1.313-.5.375c-.563.438-1.063 1-1.5 1.563l-.375.438 1.313 2.5c-.063.125-.063.25-.125.375l-2.688.813-.125.625c0 .313-.063.688-.063 1.063s.063.75.063 1.063l.125.625 2.688.813c.063.125.063.25.125.375l-1.313 2.5.375.438c.438.625.938 1.125 1.5 1.563l.5.375 2.5-1.313c.125.063.25.063.375.125l.813 2.688.625.125c.313 0 .688.063 1.063.063s.75-.063 1.063-.063l.625-.125.813-2.688c.125-.063.25-.063.375-.125l2.5 1.313.438-.375c.625-.438 1.125-1 1.563-1.563l.375-.438-1.313-2.5c.063-.125.063-.25.125-.375l2.688-.813.125-.625c0-.313.063-.688.063-1.063s-.063-.75-.063-1.063zM23.5 16v.25l-2.438.75-.125.5c-.125.313-.25.625-.438.938l-.188.438 1.188 2.25-.375.375-2.25-1.188-.438.25-.938.375-.5.125-.75 2.438c-.188.063-.313.063-.5 0l-.75-2.438-.5-.125c-.313-.125-.625-.25-.938-.438l-.438-.188-2.25 1.188-.375-.375 1.188-2.25-.188-.438c-.188-.313-.313-.625-.438-.938l-.125-.5-2.438-.75v-.5l2.438-.75.125-.5c.125-.313.25-.625.438-.938l.188-.438-1.188-2.25.375-.375 2.25 1.188.438-.188c.313-.188.625-.313.938-.438l.5-.125.75-2.438c.188-.063.313-.063.5 0l.75 2.438.5.125c.313.125.625.25.938.438l.438.188 2.25-1.188.375.375-1.188 2.25.188.438c.188.313.313.625.438.938l.125.5 2.438.75v.25z',
	    'widget-alt' => 'M3.75 0v1.875h1.875V0H3.75zm5.688 0v1.875H7.5V0h1.938zm3.75 0v1.875h-1.875V0h1.875zm3.75 0v1.875h-1.875V0h1.875zm3.75 0v1.875h-1.875V0h1.875zM24.5 0v1.875h-1.938V0H24.5zm1.875 1.875V0h1.875v1.875h-1.875zM3.75 32v-1.875h1.875V32H3.75zm3.75 0v-1.875h1.938V32H7.5zm3.813 0v-1.875h1.875V32h-1.875zm3.75 0v-1.875h1.875V32h-1.875zm3.75 0v-1.875h1.875V32h-1.875zm3.75 0v-1.875h1.938V32h-1.938zm3.812 0v-1.875h1.875V32h-1.875zm3.75-32H32v1.875h-1.875V0zm0 5.625V3.75H32v1.875h-1.875zm0 3.813V7.5H32v1.938h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.812v-1.938H32V24.5h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.75v-1.875H32V32h-1.875zM0 1.875V0h1.875v1.875H0zm0 3.75V3.75h1.875v1.875H0zm0 3.813V7.5h1.875v1.938H0zm0 3.75v-1.875h1.875v1.875H0zm0 3.75v-1.875h1.875v1.875H0zm0 3.75v-1.875h1.875v1.875H0zM0 24.5v-1.938h1.875V24.5H0zm0 3.75v-1.875h1.875v1.875H0zM0 32v-1.875h1.875V32H0zm16-13.125l7.813-7.75 1.313 1.313-9.125 9.125-9.125-9.125 1.313-1.313z',
	    'wallet' => 'M2.938 3.75h29.063V27h-3.688v3.125H2.938C1.313 30.125 0 28.875 0 27.25V6.687c0-1.625 1.313-2.938 2.938-2.938zm0 24.5h23.5v-5.625h-5.375c-1.625 0-2.938-1.25-2.938-2.813v-1.875c0-1.563 1.313-2.875 2.938-2.875h5.375V9.374H2.875c-.313 0-.563-.063-.875-.125 0 0-.063 0-.125-.063v18.063c0 .563.5 1 1.063 1zm18.125-7.5h9.063v-3.813h-9.063c-.625 0-1.063.438-1.063 1v1.875c0 .5.438.938 1.063.938zm9.062 4.375v-2.5h-1.813v2.5h1.813zm-1.812-10.062h1.813V5.625H2.938c-.563 0-1 .5-1 1.063s.5.813 1 .813h25.375v7.563z',
	    'video-clapper' => 'M0 1.875h32v28.25H0V1.875zM30.125 7.5V3.75h-4.938l4.438 3.75h.5zm-13.687 5.688h5.5l4.438-3.75h-5.5zM12.813 7.5h5.5l-4.438-3.75h-5.5zM18 9.438h-5.5l-4.438 3.75h5.5zM21.188 7.5h5.5L22.25 3.75h-5.5zM1.875 3.75V7.5h8L5.437 3.75H1.874zm0 5.688v3.75h3.25l4.438-3.75H1.875zm28.25 18.812V15.062H1.875V28.25h28.25zm0-15.062v-3.75h-.813l-4.438 3.75h5.25z',
	    'video-camera' => 'M24.438 12.688l7.563-5.25v19l-7.563-5.25v4.25c0 1.5-1.25 2.813-2.813 2.813h-15c-1.563 0-2.813-1.313-2.813-2.813V15.063h-.938c-1.625 0-2.875-1.25-2.875-2.813V8.5c0-1.563 1.25-2.875 2.875-2.875h2.75v-.938c0-1.563 1.313-2.813 2.875-2.813h10.375v1.875H8.499c-.563 0-1 .438-1 .938v.938h14.125c1.563 0 2.813 1.313 2.813 2.875v4.188zm5.687 10.125v-11.75l-7.563 5.25V8.5c0-.563-.438-1-.938-1H2.874c-.563 0-1 .438-1 1v3.75c0 .5.438.938 1 .938h2.813v12.25c0 .5.438.938.938.938h15c.5 0 .938-.438.938-.938v-7.875z',
	    'vector' => 'M28.125 11.313H32v5.625h-5.625v-4.5C23 10.75 18.875 11 15.75 13.188c.125.25.188.563.188.938 0 1.563-1.25 2.813-2.813 2.813-.25 0-.438 0-.625-.063-.813 1.438-1.188 3.125-1.188 4.75 0 1.5.438 3.188 1.25 4.75h4.375v5.625h-5.625v-4c-.75-1.188-1.875-3.563-1.875-6.375 0-1.438.25-2.875.75-4.188l-4.875 4.813c.188.375.313.813.313 1.25 0 1.563-1.25 2.875-2.813 2.875s-2.813-1.313-2.813-2.875c0-1.5 1.25-2.813 2.813-2.813.438 0 .813.125 1.188.25l6.375-6.375c-.063-.125-.063-.313-.063-.438 0-1.563 1.25-2.813 2.813-2.813h.5l7.313-7.313c-.125-.375-.25-.75-.25-1.188 0-1.563 1.313-2.813 2.813-2.813 1.563 0 2.875 1.25 2.875 2.813s-1.313 2.813-2.875 2.813c-.438 0-.875-.125-1.25-.313l-4.813 4.875c1.313-.5 2.75-.75 4.188-.75 2.313 0 4.563.625 6.5 1.875zM23.5 1.875c-.5 0-.938.438-.938.938s.438.938.938.938c.563 0 1-.438 1-.938s-.438-.938-1-.938zM2.813 24.5c.5 0 .938-.438.938-1 0-.5-.438-.938-.938-.938s-.938.438-.938.938c0 .563.438 1 .938 1zm10.375 3.75v1.875h1.875V28.25h-1.875zm-.063-13.187c.5 0 .938-.438.938-.938s-.438-.938-.938-.938-.938.438-.938.938.438.938.938.938zm17 0v-1.875H28.25v1.875h1.875z',
	    'themify-logo' => 'M4.938 12.813c.375 0 .938.063 1.25.125.125-.188.188-.438.188-.625 0-.563-.5-1-1.188-1s-1.438.188-2.063.313c-.563.063-1.5.25-1.938.25-.188 0-.875 0-.938-.438-.125.188-.313.563-.25.875.125.875 1.188.813 1.5.813h.438s.313-.063.438-.063H2.5v.125c-.25.688-1.938 4.688-1.938 5.125 0 .688.688.688 1.188.75.25-.625 1.813-4.75 2.563-6.188h.063c.188-.063.375-.063.563-.063zm7.312 5.25c.563-.125 1.625-.688 2.063-1-.813 1.25-1.813 1.938-2.938 1.938-.438 0-1.313-.125-1.375-1.188-.313.438-1 1.375-1.688 1.313-.75 0-.875-.5-.875-1 0-.938 1-3.063 1-3.063-.875 0-2.125 2.125-2.688 4.125-.563 0-1.125-.563-1.125-1.125s.688-2 1.313-3.375c.313-.75 1.125-2.063 1.375-3.688.188-.063.563-.188.688-.188.5 0 .688.25.688.688 0 .313-1.25 2.875-1.313 3.25 0 0 1.25-.813 1.938-.813.5 0 .813.25.813.688 0 .375-.313.875-.625 1.375s-.563 1.063-.688 1.438c-.063.25-.063.375 0 .375.063.063.688.063 1.25-.5.313-1.5 1.875-3.625 3.25-3.625.75 0 1.188.5 1.25 1.125.25 1.875-2.438 3.25-2.938 2.375-.125-.25 1.375.063 1.688-1.625.063-.313-.188-.375-.313-.375-.5 0-1.625 1.125-1.625 2.125 0 .813.5.813.875.75zm7.938-.625c-.125.375.063.375.25.375s.438 0 .688-.188c-.188.75-.75 1.5-1.563 1.5-.563 0-.813-.25-.813-.813 0-.938.688-2.188.813-2.438l.125-.188H19.5c-.563 0-1.938 2.063-2.188 3.25h-.25c-.375 0-.75-.188-.75-.625 0-.5.25-1 .5-1.5.188-.313.313-.625.438-.938l.063-.125h-.125c-.75 0-1.75 1.938-2.188 3.25h-.063c-.5 0-.875-.313-.875-.813 0-.188.313-.875.625-1.563.438-1.063.938-2.313 1-2.813.188-.063.313-.063.438-.063.25 0 .688.063.688.563 0 .188-.125.938-.125.938.688-.813 1.438-1.313 1.875-1.313.375 0 .563.313.563.938v.25l.125-.188c.563-.625 1.188-1.063 1.625-1.063.375 0 .5.188.5.5 0 .5-.438 1.438-.813 2.063-.25.5-.375.813-.375 1zm3.375.562c-.25.813-.563 1.125-1.25 1.125-.625 0-1.063-.625-1.063-1.188 0-.5.438-1.375.875-2.313.25-.563.5-1.125.688-1.625h.125c.375 0 .938.313 1 .75 0 .313-.375.688-.688 1.313-.375.688-.625 1.313-.625 1.688 0 .313.563.625.938.25zm.25-4.625c-.5 0-.75-.188-.75-.438 0-.313-.063-.563.313-.938 1.063.063 1.438.188 1.438.438 0 .188-.125.5-.438.875-.188.063-.438.063-.563.063zm7.062.188c.5 0 1.063.188 1.125.625 0 .125-.063.375-.25.75-.063.125-.125.313-.188.438-.063.25-.375.938-.438 1.25-.625 1.938-1.438 3.938-3.25 4.125l-.063.063c-.5 0-.938-.125-1.188-.438-.688-.625-.5-1.25-.5-1.25s.375.625 1.375.563c.75 0 1.438-.875 1.875-2.125l-.063-.063c-.375.5-1.625 1.438-2.125.875-.188-.125-.188-.313-.25-.625 0-.5.313-1.563.5-2.188.125-.313.25-.688.313-.938 0-.063-.063-.125-.125-.188h-.063c-.125 0-.313 0-.5.125-.25.125-.438.313-.5.438 0 0-2.5 5.563-2.625 6.5-.375-.063-1.188-.563-1.125-1.125 0-.375.875-2.313 1.438-3.5.313-.688.813-1.938.813-1.938-.125-.188-.375-.313-.313-.563 0-.125.063-.375.313-.5h.063c.188-.063.438-.125.563-.188v-.063c.5-1.125 1.5-3.188 2.875-3.063.75 0 1.25.375 1.313 1 .063.25 0 .313-.125.563-.125-.625-.813-.563-1.25-.25-.25.125-.938.938-1.188 1.813h.75s.5 0 .75.063c.063 0 .125.063.188.063.125.063.125.125.188.188 0 .063 0 .125.063.188 0 .313-.25.875-.438 1.375-.188.438-.438.938-.375 1.125.375.875 2.25-2.188 2.375-3.063v-.063h.063z',
	    'themify-favicon' => 'M17.688 2.438c11.125 0 15.375 11.25 14.063 18.313-.813 4.563-9.938 5.75-18 6.563-6.813.688-12.063 2.25-12.063 2.25s6.188-4.688 2.125-6.75C1.438 21.564-6.562 9.126 11.501 3.501c2.25-.75 4.313-1.063 6.188-1.063zm12.25 18c.563-3.313-.188-8.313-3.25-12-2.25-2.75-5.313-4.125-9-4.125-1.75 0-3.625.313-5.625.938C7.75 6.626 2.5 9.189 1.938 13.876c-.438 3.625 2.063 6.875 2.75 7.25 1.938 1 2.313 2.5 2.375 3.25.063.688-.063 1.375-.375 2.063 1.938-.375 4.313-.75 6.813-1 5.125-.563 15.813-1.625 16.438-5zM7.5 12.25c0 1 .875 1.875 1.938 1.875 1 0 1.875-.875 1.875-1.875 0-1.063-.875-1.875-1.875-1.875-1.063 0-1.938.813-1.938 1.875zm9.438-.937c0 1 .875 1.875 1.875 1.875 1.063 0 1.875-.875 1.875-1.875 0-1.063-.813-1.875-1.875-1.875-1 0-1.875.813-1.875 1.875zM25.063 16S13 23.188 6.938 17.813c0 0 7.688 9.75 18.125-1.813z',
	    'themify-favicon-alt' => 'M11.5 3.5c15.75-4.938 21.75 9 20.25 17.25-.813 4.563-9.938 5.75-18 6.563-6.813.688-12.063 2.25-12.063 2.25s6.188-4.688 2.125-6.75C1.437 21.563-6.563 9.125 11.5 3.5zm7.313 5.938c-1 0-1.875.813-1.875 1.875 0 1 .875 1.875 1.875 1.875 1.063 0 1.875-.875 1.875-1.875 0-1.063-.813-1.875-1.875-1.875zm-9.375.937c-1.063 0-1.938.813-1.938 1.875 0 1 .875 1.875 1.938 1.875 1 0 1.875-.875 1.875-1.875 0-1.063-.875-1.875-1.875-1.875zm-2.5 7.438s7.688 9.75 18.125-1.813c0 0-12.063 7.188-18.125 1.813z',
	    'support' => 'M25.188 5.625h6.813v24.5h-32v-24.5h6.813C8.564 2.187 12.064 0 16.002 0s7.438 2.188 9.188 5.625zM16 1.875c-2.875 0-5.5 1.438-7 3.75h14c-1.5-2.313-4.125-3.75-7-3.75zM30.125 28.25V7.5H1.875v20.75h28.25zm-15.062-9.437v3.75h1.875v-3.75h3.75v-1.875h-3.75v-3.75h-1.875v3.75h-3.75v1.875h3.75z',
	    'stamp' => 'M32 22.438v7.688h-1.875v1.875H1.875v-1.875H0v-7.688c0-2 1.625-3.563 3.563-3.563h8.25l-2.375-8.813V3.749c0-2.063 1.688-3.75 3.75-3.75h5.625c2 0 3.75 1.688 3.75 3.75l-.063 6.625-2.375 8.5h8.313c1.938 0 3.563 1.563 3.563 3.563zm-1.875 5.812v-5.813c0-.938-.75-1.688-1.688-1.688h-10.75l3-10.75v-6.25c0-1-.875-1.875-1.875-1.875h-5.625c-1 0-1.875.875-1.875 1.875v6.188l3 10.813H3.562c-.938 0-1.688.75-1.688 1.688v5.813h28.25z',
	    'split-v-alt' => 'M10.063 11L8.75 9.687 2.437 16l6.313 6.313L10.063 21l-4.938-5zM23.25 9.688l6.313 6.313-6.313 6.313-1.313-1.313 4.938-5-4.938-5zM15.063 32V0h1.875v32h-1.875z',
	    'slice' => 'M31.188 7.25c.5.5.813 1.25.813 2s-.313 1.438-.813 2L16.75 25.688l-1.563-1.5-4.125 4.125H.874l23.688-23.75c1.063-1.063 2.938-1.063 4 0zM12.75 19.063l4 3.938 1.5-1.563-3.938-3.938zm-2.437 7.375l3.563-3.625-2.438-2.438-6.063 6.063h4.938zm19.5-16.563c.375-.375.375-.938 0-1.313l-2.625-2.625c-.188-.188-.375-.313-.625-.313s-.5.125-.688.313l-10.25 10.25 4 3.938z',
	    'shortcode' => 'M.063 1.875v28.25h5.625V28.25h-3.75V3.75h3.75V1.875H.063zm26.312 0h5.688v28.25h-5.688V28.25h3.813V3.75h-3.813V1.875zM16.75 15c2.625 1 3.938 2.25 3.875 4.438 0 2.375-1.688 4.438-5.313 4.438-1.438 0-3.063-.438-3.875-1l.5-1.625c.875.5 2.188 1 3.5 1 2.063 0 3.188-1.125 3.188-2.625 0-1.438-.813-2.25-2.875-3-2.438-.938-4-2.188-4-4.313 0-2.375 2-4.188 4.938-4.188 1.563 0 2.688.375 3.375.75L19.5 10.5c-.5-.25-1.5-.75-2.875-.75-2.063 0-2.875 1.25-2.875 2.313 0 1.438.938 2.125 3 2.938z',
	    'shift-right-alt' => 'M28.625 16l-6.313-6.313L20.999 11l4.938 5-4.938 5 1.313 1.313zM13.188 32V0h1.875v32h-1.875z',
	    'shift-left-alt' => 'M11 11L9.687 9.687 3.374 16l6.313 6.313L11 21l-4.938-5zm5.938-11h1.875v32h-1.875V0z',
	    'ruler-alt-2' => 'M0 .563l31.438 31.438H0V.563zm1.875 4.562v25h25l-4.75-4.813-1.25 1.25-1.313-1.313 1.188-1.25-1.313-1.313-1.25 1.188-1.313-1.313 1.25-1.25-1.375-1.313-1.188 1.25-1.375-1.375 1.25-1.188-1.313-1.375-1.25 1.25-1.313-1.313 1.188-1.25-1.313-1.313-1.25 1.188-1.313-1.313 1.25-1.25-1.375-1.313-1.188 1.25-1.375-1.375 1.25-1.188zM3.75 28.25v-14.5l14.5 14.5H3.75zm1.875-10v8.125h8.125z',
	    'receipt' => 'M3.75 0h24.5v31.813l-3.75-4.688-2.813 3.563-2.813-3.563-2.813 3.563-2.813-3.563-2.813 3.563-2.875-3.563-3.813 4.688V0zm22.625 26.438V1.875H5.625v24.688l2-2.438 2.813 3.563 2.813-3.563 2.813 3.563 2.813-3.563 2.813 3.563 2.813-3.563zM20.688 7.5V5.625H9.375V7.5h11.313zm-3.75 7.563v-1.875H9.375v1.875h7.563zm5.625-3.75V9.438H9.375v1.875h13.188zm-13.125 7.5v1.875h13.125v-1.875H9.438z',
	    'pin2' => 'M15.063 21.625V32h1.875V21.625h-1.875zm11.312-5.062l-2.063-.938L22.187 3.75 23 2.312l1.313-2.313H7.688l1.313 2.313.813 1.438-2.125 11.875-2.063.938v4.125h20.75v-4.125zm-1.875 1.25v1h-17v-1l1.875-.875 2.25-12.875.125-.625-.875-1.563h10.25l-.563 1-.313.563 2.188 12.563.188.938z',
	    'pin-alt' => 'M10.188 20.5L.25 30.375l1.375 1.375 9.875-9.938zM32 11.688L20.312 0l-.75 2.5-.5 1.625-9.875 6.938-2.063-.813-2.938 2.938 14.625 14.625 2.938-2.938-.813-2.063 6.938-9.875zm-3.562-.875l-1.063.313-.688.188-7.25 10.375-.625.813.375.938.375 1-.75.688L6.874 13.19l.688-.75 1.938.75 11.188-7.875.188-.688.313-1.063z',
	    'pencil-alt2' => 'M17.875 0c1.563 0 2.813 1.25 2.813 2.813v20.063l-4.625 9.313-4.75-9.313V2.813C11.313 1.25 12.563 0 14.126 0h3.75zm-3.75 1.875c-.5 0-.938.438-.938.938v1.938h5.625V2.813c0-.5-.438-.938-.938-.938h-3.75zm1.063 24.5h1.625l1.75-3.438h-5.125zm-2-5.312h5.625V10.438h-5.625v10.625zm0-12.5h5.625V6.625h-5.625v1.938z',
	    'palette' => 'M16 .938c8.313 0 15.063 6.75 15.063 15.063 0 5.063-2.563 9.813-6.813 12.625l-.625.375-7-7c-1.063-1.063-2.938-1.063-4 0-.563.563-.875 1.25-.875 2s.313 1.5.875 2l5.125 5.125-2.438-.125c-8.063-.313-14.375-6.938-14.375-15C.937 7.688 7.687.938 16 .938zm7.813 25.625c3.375-2.438 5.375-6.375 5.375-10.563C29.188 8.75 23.25 2.812 16 2.812S2.812 8.75 2.812 16c0 6.125 4.188 11.25 9.875 12.75l-1.438-1.438c-.875-.875-1.375-2.063-1.375-3.313s.5-2.438 1.375-3.313c1.813-1.75 4.875-1.75 6.688 0zM21.625 12.25c2.125 0 3.813 1.688 3.813 3.75s-1.688 3.75-3.813 3.75c-2.063 0-3.75-1.688-3.75-3.75s1.688-3.75 3.75-3.75zm0 5.625c1.063 0 1.875-.813 1.875-1.875s-.813-1.875-1.875-1.875c-1 0-1.875.813-1.875 1.875s.875 1.875 1.875 1.875zM16 11.313c1.563 0 2.813-1.313 2.813-2.813 0-1.563-1.25-2.875-2.813-2.875S13.187 6.938 13.187 8.5c0 1.5 1.25 2.813 2.813 2.813zm-5.187-.25c0-1-.813-1.875-1.875-1.875s-1.875.875-1.875 1.875c0 1.063.813 1.938 1.875 1.938s1.875-.875 1.875-1.938z',
	    'more' => 'M3.75 11.313c2.063 0 3.75 1.688 3.75 3.75s-1.688 3.75-3.75 3.75S0 17.125 0 15.063s1.688-3.75 3.75-3.75zm0 5.625c1.063 0 1.875-.813 1.875-1.875s-.813-1.875-1.875-1.875c-1 0-1.875.813-1.875 1.875s.875 1.875 1.875 1.875zM16 11.313c2.063 0 3.75 1.688 3.75 3.75s-1.688 3.75-3.75 3.75-3.75-1.688-3.75-3.75 1.688-3.75 3.75-3.75zm0 5.625c1.063 0 1.875-.813 1.875-1.875s-.813-1.875-1.875-1.875-1.875.813-1.875 1.875.813 1.875 1.875 1.875zm12.25-5.625c2.063 0 3.75 1.688 3.75 3.75s-1.688 3.75-3.75 3.75-3.75-1.688-3.75-3.75 1.688-3.75 3.75-3.75zm0 5.625c1 0 1.875-.813 1.875-1.875s-.875-1.875-1.875-1.875c-1.063 0-1.875.813-1.875 1.875s.813 1.875 1.875 1.875z',
	    'more-alt' => 'M7.5 15.063c0-2.063-1.688-3.75-3.75-3.75S0 13.001 0 15.063s1.688 3.75 3.75 3.75 3.75-1.688 3.75-3.75zm8.5-3.75c2.063 0 3.75 1.688 3.75 3.75s-1.688 3.75-3.75 3.75-3.75-1.688-3.75-3.75 1.688-3.75 3.75-3.75zm12.25 0c2.063 0 3.75 1.688 3.75 3.75s-1.688 3.75-3.75 3.75-3.75-1.688-3.75-3.75 1.688-3.75 3.75-3.75z',
	    'microphone-alt' => 'M21.875 13.188L19.75 28.251h-2.813v3.75h-1.875v-3.75h-2.813l-2.125-15.063c-1.313-1.375-2.125-3.25-2.125-5.313 0-4.438 3.625-8 8-8s8 3.563 8 8c0 2.063-.813 3.938-2.125 5.313zM11.313 4.063c-.875 1-1.375 2.313-1.375 3.813 0 3.313 2.688 6.063 6.063 6.063s6.063-2.75 6.063-6.063c0-1.5-.5-2.813-1.375-3.813v3.438h-1.875v-5c-.563-.313-1.188-.5-1.875-.625v7.563h-1.875V1.876c-.688.125-1.313.313-1.875.625v5h-1.875V4.063zm2.625 22.312h4.125l1.688-11.5c-1.125.563-2.375.938-3.75.938s-2.625-.375-3.75-.938z',
	    'magnet' => 'M20.688 0h9.438v19.625c0 8.063-7.25 12.375-14.125 12.375S1.876 27.687 1.876 19.625V0h9.438v19.063c0 2.5 2.063 4.5 4.688 4.5s4.688-2 4.688-4.5V0zm7.562 1.875h-5.688V7.5h5.688V1.875zm-18.812 0H3.75V7.5h5.688V1.875zM16 30.125c4.938 0 12.25-2.813 12.25-10.5V9.437h-5.688v9.625c0 3.5-2.938 6.438-6.563 6.438s-6.563-2.938-6.563-6.438V9.437H3.748v10.188c0 7.688 7.313 10.5 12.25 10.5z',
	    'line-double' => 'M32 11.313H0v1.875h32v-1.875zm-32 7.5v-1.875h32v1.875H0z',
	    'line-dotted' => 'M0 15.063v1.875h.938v-1.875H0zm4.5 1.875v-1.875h1.75v1.875H4.5zm5.313 0v-1.875h1.75v1.875h-1.75zm10.625 0v-1.875h1.75v1.875h-1.75zm-5.313 0v-1.875h1.75v1.875h-1.75zm10.625 0v-1.875h1.75v1.875h-1.75zm5.313-1.875h.938v1.875h-.938v-1.875z',
	    'line-dashed' => 'M0 15.063v1.875h7.5v-1.875H0zm12.25 1.875v-1.875h7.5v1.875h-7.5zm12.25-1.875H32v1.875h-7.5v-1.875z',
	    'layout-width-full' => 'M0 0h32v32H0V0zm30.125 30.125V1.875H1.875v28.25h28.25z',
	    'layout-width-default' => 'M0 0h32v32H0V0zm30.125 30.125V1.875H1.875v28.25h28.25zm-24.5-15.062v1.875H7.5v-1.875H5.625zm0-7.563v1.938H7.5V7.5H5.625zm0 11.313v1.875H7.5v-1.875H5.625zm0-7.5v1.875H7.5v-1.875H5.625zm0-7.563v1.875H7.5V3.75H5.625zm0 22.625v1.875H7.5v-1.875H5.625zm0-3.812v1.938H7.5v-1.938H5.625zM24.5 3.75v1.875h1.875V3.75H24.5zm0 7.563v1.875h1.875v-1.875H24.5zm0-3.813v1.938h1.875V7.5H24.5zm0 7.563v1.875h1.875v-1.875H24.5zm0 3.75v1.875h1.875v-1.875H24.5zm0 3.75v1.938h1.875v-1.938H24.5zm0 3.812v1.875h1.875v-1.875H24.5z',
	    'layout-width-default-alt' => 'M3.75 30.125V32h1.875v-1.875H3.75zM18.813 32v-1.875h1.875V32h-1.875zm3.75 0v-1.875h1.938V32h-1.938zM7.5 32v-1.875h1.938V32H7.5zm3.813 0v-1.875h1.875V32h-1.875zm3.75 0v-1.875h1.875V32h-1.875zm11.312 0v-1.875h1.875V32h-1.875zm0-26.375V3.75h1.875v1.875h-1.875zm0 3.813V7.5h1.875v1.938h-1.875zm0 15.062v-1.938h1.875V24.5h-1.875zm0-11.312v-1.875h1.875v1.875h-1.875zm0 3.75v-1.875h1.875v1.875h-1.875zm0 11.312v-1.875h1.875v1.875h-1.875zm0-7.562v-1.875h1.875v1.875h-1.875zm0-20.688h1.875v1.875h-1.875V0zm-3.812 1.875V0h1.938v1.875h-1.938zm-11.25 0V0h1.875v1.875h-1.875zm3.75 0V0h1.875v1.875h-1.875zm3.75 0V0h1.875v1.875h-1.875zm-11.313 0V0h1.938v1.875H7.5zm-3.75 0V0h1.875v1.875H3.75zm0 22.625v-1.938h1.875V24.5H3.75zm0 3.75v-1.875h1.875v1.875H3.75zm0-7.562v-1.875h1.875v1.875H3.75zm0-15.063V3.75h1.875v1.875H3.75zm0 3.813V7.5h1.875v1.938H3.75zm0 3.75v-1.875h1.875v1.875H3.75zm0 3.75v-1.875h1.875v1.875H3.75z',
	    'layout-tab' => 'M13.188 5.625h18.813v24.5h-32V3.75h13.188v1.875zm7.5 1.875h-7.5v1.938h7.5V7.5zm9.437 20.75V11.312H11.312V5.624H1.874v22.625h28.25zM22.563 9.438h7.563V7.5h-7.563v1.938z',
	    'layout-tab-window' => 'M22.563 3.75h9.438v26.375h-32V3.75h22.563zm7.562 1.875h-7.563v3.813h7.563V5.625zm-9.437 0h-9.375v3.813h9.375V5.625zm-18.813 0v3.813h7.563V5.625H1.875zm28.25 22.625V11.312H1.875V28.25h28.25z',
	    'layout-tab-v' => 'M11.313 1.875h20.688v28.25H11.313V18.812H1.875v-7.5H0V3.749h11.313V1.874zM3.75 11.313v1.875h7.563v-1.875H3.75zm0 5.625h7.563v-1.875H3.75v1.875zM30.125 28.25V3.75H13.187v1.875H1.874v3.813h11.313v18.813h16.938z',
	    'layout-tab-min' => 'M13.188 3.75h18.813v5.688H11.313V3.75H1.875v5.625H0v-7.5h13.188V3.75zm0 1.875V7.5h7.5V5.625h-7.5zM22.563 7.5h7.563V5.625h-7.563V7.5z',
	    'layout-slider' => 'M0 1.875h32V28.25H0V1.875zm30.125 24.5V3.75H1.875v22.625h28.25zM8.75 19.5l1.313-1.313L7 15.062l3.063-3.125-1.313-1.313-4.438 4.438zm13.188-1.312l1.313 1.313 4.438-4.438-4.438-4.438-1.313 1.313 3.063 3.125z',
	    'layout-slider-alt' => 'M3.75 26.375V5.625h24.5v20.75H3.75zM5.625 7.5v17h20.75v-17H5.625zm24.5 1v15H32v-15h-1.875zM0 8.5v15h1.875v-15H0z',
	    'layout-sidebar-right' => 'M32 0h-9.438v32H32V0zM16.938 32v-1.875h1.875V32h-1.875zm-3.313 0v-1.875h1.625V32h-1.625zM3.563 32v-1.875h1.688V32H3.563zm3.312 0v-1.875h1.688V32H6.875zm3.375 0v-1.875h1.688V32H10.25zM0 32v-1.875h1.875V32H0zm0-15.062v-1.875h1.875v1.875H0zM0 5.625V3.75h1.875v1.875H0zm0 15.063v-1.875h1.875v1.875H0zm0-7.5v-1.875h1.875v1.875H0zM0 24.5v-1.938h1.875V24.5H0zm0 3.75v-1.875h1.875v1.875H0zM0 9.438V7.5h1.875v1.938H0zm0-7.563V0h1.875v1.875H0zM15.25 0v1.875h-1.625V0h1.625zm-3.312 0v1.875H10.25V0h1.688zM5.25 0v1.875H3.562V0H5.25zm3.313 0v1.875H6.875V0h1.688zm8.375 1.875V0h1.875v1.875h-1.875zm0 26.375v-1.875h1.875v1.875h-1.875zm0-3.75v-1.938h1.875V24.5h-1.875zm0-7.562v-1.875h1.875v1.875h-1.875zm0 3.75v-1.875h1.875v1.875h-1.875zm0-11.25V7.5h1.875v1.938h-1.875zm0 3.75v-1.875h1.875v1.875h-1.875zm0-7.563V3.75h1.875v1.875h-1.875z',
	    'layout-sidebar-none' => 'M0 30.125V32h1.875v-1.875H0zM26.375 32v-1.875h1.875V32h-1.875zm-3.812 0v-1.875h1.938V32h-1.938zm-3.75 0v-1.875h1.875V32h-1.875zm-3.75 0v-1.875h1.875V32h-1.875zm-3.75 0v-1.875h1.875V32h-1.875zM3.75 32v-1.875h1.875V32H3.75zm3.75 0v-1.875h1.938V32H7.5zm22.625 0v-1.875H32V32h-1.875zm0-11.312v-1.875H32v1.875h-1.875zm0 3.812v-1.938H32V24.5h-1.875zm0-15.062V7.5H32v1.938h-1.875zm0 7.5v-1.875H32v1.875h-1.875zm0-3.75v-1.875H32v1.875h-1.875zm0-7.563V3.75H32v1.875h-1.875zm0 22.625v-1.875H32v1.875h-1.875zm0-28.25H32v1.875h-1.875V0zM7.5 1.875V0h1.938v1.875H7.5zm-3.75 0V0h1.875v1.875H3.75zm18.813 0V0h1.938v1.875h-1.938zm-3.75 0V0h1.875v1.875h-1.875zm-7.5 0V0h1.875v1.875h-1.875zm15.062 0V0h1.875v1.875h-1.875zm-11.312 0V0h1.875v1.875h-1.875zM0 1.875V0h1.875v1.875H0zM0 24.5v-1.938h1.875V24.5H0zm0 3.75v-1.875h1.875v1.875H0zm0-7.562v-1.875h1.875v1.875H0zm0-11.25V7.5h1.875v1.938H0zm0 7.5v-1.875h1.875v1.875H0zM0 5.625V3.75h1.875v1.875H0zm0 7.563v-1.875h1.875v1.875H0z',
	    'layout-sidebar-left' => 'M0 0v32h9.438V0H0zm13.188 32v-1.875h1.875V32h-1.875zm13.562 0v-1.875h1.688V32H26.75zm-3.312 0v-1.875h1.688V32h-1.688zm-6.688 0v-1.875h1.625V32H16.75zm3.313 0v-1.875h1.688V32h-1.688zm10.062 0v-1.875H32V32h-1.875zm0-26.375V3.75H32v1.875h-1.875zm0 22.625v-1.875H32v1.875h-1.875zm0-15.062v-1.875H32v1.875h-1.875zm0-3.75V7.5H32v1.938h-1.875zm0 7.5v-1.875H32v1.875h-1.875zm0 3.75v-1.875H32v1.875h-1.875zm0 3.812v-1.938H32V24.5h-1.875zm0-24.5H32v1.875h-1.875V0zM26.75 1.875V0h1.688v1.875H26.75zm-3.312 0V0h1.688v1.875h-1.688zm-3.375 0V0h1.688v1.875h-1.688zm-3.313 0V0h1.625v1.875H16.75zm-3.562 0V0h1.875v1.875h-1.875zm0 26.375v-1.875h1.875v1.875h-1.875zm0-3.75v-1.938h1.875V24.5h-1.875zm0-11.312v-1.875h1.875v1.875h-1.875zm0 7.5v-1.875h1.875v1.875h-1.875zm0-11.25V7.5h1.875v1.938h-1.875zm0-3.813V3.75h1.875v1.875h-1.875zm0 11.313v-1.875h1.875v1.875h-1.875z',
	    'layout-placeholder' => 'M.063 1.875h32v28.25h-32V1.875zM15.313 16L1.938 4.312v23.375zM2.75 3.813l13.313 11.563L29.376 3.813H2.751zm13.313 12.812L2.688 28.25h26.625zM16.75 16l13.438 11.75V4.312z',
	    'layout-menu' => 'M0 13.188h24.5v5.625H0v-5.625zm15.063 1.875H9.438v1.875h5.625v-1.875zm-13.188 0v1.875H7.5v-1.875H1.875zm20.688 1.875v-1.875h-5.625v1.875h5.625z',
	    'layout-menu-v' => 'M5.625 1.875h20.75V7.5H5.625V1.875zM24.5 5.625V3.75h-17v1.875h17zM5.625 15.063V9.438h20.75v5.625H5.625zm1.875-3.75v1.875h17v-1.875h-17zm-1.875 11.25v-5.625h20.75v5.625H5.625zm1.875-3.75v1.875h17v-1.875h-17zM5.625 30.125v-5.688h20.75v5.688H5.625zm1.875-3.75v1.875h17v-1.875h-17z',
	    'layout-menu-separated' => 'M0 18.813v-5.625h9.438v5.625H0zm1.875-3.75v1.875H7.5v-1.875H1.875zm9.438 3.75v-5.625h9.375v5.625h-9.375zm1.875-3.75v1.875h5.625v-1.875h-5.625zm9.375-1.875h9.438v5.625h-9.438v-5.625zm7.562 3.75v-1.875H24.5v1.875h5.625z',
	    'layout-menu-full' => 'M0 13.188h32v5.625H0v-5.625zm16.938 1.875v1.875h5.625v-1.875h-5.625zm-1.875 1.875v-1.875H9.438v1.875h5.625zM1.875 15.063v1.875H7.5v-1.875H1.875zm28.25 1.875v-1.875H24.5v1.875h5.625z',
	    'layout-media-right-alt' => 'M3.75 24.5v1.875H32V24.5H3.75zm9.438 5.625V28.25h18.813v1.875H13.188zM32 1.875H0v20.688h32V1.875zM30.125 3.75v16.938H1.875V3.75h28.25z',
	    'layout-media-right' => 'M15.063 7.5h16.938v17H15.063v-17zm15.062 15.063V9.438H16.937v13.125h13.188zM2.188 7.5v1.938h11V7.5h-11zm4.437 7.563v1.875h6.563v-1.875H6.625zm6.563-1.875v-1.875H0v1.875h13.188zM0 18.813v1.875h13.188v-1.875H0zm2.188 3.75v1.938h11v-1.938h-11z',
	    'layout-media-overlay' => 'M28.25 22.563v-1.875H3.75v1.875h24.5zm-5.687 1.875v1.875H3.75v-1.875h18.813zM32 1.875H0v28.25h32V1.875zM30.125 3.75v24.5H1.875V3.75h28.25z',
	    'layout-media-overlay-alt' => 'M0 3.75h32v22.625H0V3.75zm1.875 15.063h28.25V5.625H1.875v13.188z',
	    'layout-media-overlay-alt-2' => 'M22.563 16.938v-1.875H3.75v1.875h18.813zm0 1.875v1.875H3.75v-1.875h18.813zM32 1.875H0v28.25h32V1.875zM30.125 3.75v24.5H1.875V3.75h28.25z',
	    'layout-media-left-alt' => 'M0 24.5v1.875h28.25V24.5H0zm0 5.625V28.25h18.813v1.875H0zm32-28.25H0v20.688h32V1.875zM30.125 3.75v16.938H1.875V3.75h28.25z',
	    'layout-media-left' => 'M18.813 7.5v1.938h11V7.5h-11zm0 7.563v1.875h6.563v-1.875h-6.563zm0-3.75v1.875h13.188v-1.875H18.813zm0 7.5v1.875h13.188v-1.875H18.813zm0 3.75v1.938h11v-1.938h-11zM0 24.5v-17h16.938v17H0zM1.875 9.438v13.125h13.188V9.438H1.875z',
	    'layout-media-center-alt' => 'M1.875 24.5v1.875h28.25V24.5H1.875zM7.5 30.125V28.25h17v1.875h-17zM32 1.875H0v20.688h32V1.875zM30.125 3.75v16.938H1.875V3.75h28.25z',
	    'layout-media-center' => 'M1.875 7.5h28.25v11.313H1.875V7.5zm26.375 9.438v-7.5H3.75v7.5h24.5zm-1.875 3.75H5.625v1.875h20.75v-1.875zM3.75 24.5v1.875h24.5V24.5H3.75z',
	    'layout-list-thumb' => 'M28.25 7.5V5.625H11.312V7.5H28.25zM11.313 9.438h20.688v1.875H11.313V9.438zM0 3.75v9.438h9.438V3.75H0zm1.875 7.563V5.625H7.5v5.688H1.875zm26.375 7.5v1.875H11.312v-1.875H28.25zM11.313 24.5v-1.938h20.688V24.5H11.313zM0 16.938v9.438h9.438v-9.438H0zM1.875 24.5v-5.688H7.5V24.5H1.875z',
	    'layout-list-thumb-alt' => 'M28.25 9.438V7.5H11.312v1.938H28.25zm-16.937 1.875h20.688v1.875H11.313v-1.875zM0 15.063V5.625h9.438v9.438H0zm28.25 5.625v1.875H11.312v-1.875H28.25zm-16.937 5.687V24.5h20.688v1.875H11.313zM0 28.25v-9.438h9.438v9.438H0z',
	    'layout-list-post' => 'M26.375 9.438V5.625H0v3.813h26.375zM0 11.313h32v1.875H0v-1.875zm26.375 7.5v3.75H0v-3.75h26.375zM0 26.375V24.5h32v1.875H0z',
	    'layout-list-large-image' => 'M31.063 9.438V7.5h-4.688v1.938h4.688zm-1.875 5.625v1.875h-2.813v-1.875h2.813zm-2.813-3.75H32v1.875h-5.625v-1.875zm0 9.375v-1.875H32v1.875h-5.625zm0 3.812v-1.938h4.688V24.5h-4.688zM0 7.5v17h24.5v-17H0zm1.875 15.063V9.438h20.688v13.125H1.875z',
	    'layout-line-solid' => 'M32 15.063H0v1.875h32v-1.875z',
	    'layout-grid4' => 'M1.875 7.5V1.875H7.5V7.5H1.875zM3.75 3.75v1.875h1.875V3.75H3.75zM9.438 7.5V1.875h5.625V7.5H9.438zm1.875-3.75v1.875h1.875V3.75h-1.875zm5.625 3.75V1.875h5.625V7.5h-5.625zm1.875-3.75v1.875h1.875V3.75h-1.875zM24.5 1.875h5.625V7.5H24.5V1.875zm3.75 3.75V3.75h-1.875v1.875h1.875zM1.875 15.063V9.438H7.5v5.625H1.875zm1.875-3.75v1.875h1.875v-1.875H3.75zm5.688 3.75V9.438h5.625v5.625H9.438zm1.875-3.75v1.875h1.875v-1.875h-1.875zm5.625 3.75V9.438h5.625v5.625h-5.625zm1.875-3.75v1.875h1.875v-1.875h-1.875zm5.687 3.75V9.438h5.625v5.625H24.5zm1.875-3.75v1.875h1.875v-1.875h-1.875zm-24.5 11.25v-5.625H7.5v5.625H1.875zm1.875-3.75v1.875h1.875v-1.875H3.75zm5.688 3.75v-5.625h5.625v5.625H9.438zm1.875-3.75v1.875h1.875v-1.875h-1.875zm5.625 3.75v-5.625h5.625v5.625h-5.625zm1.875-3.75v1.875h1.875v-1.875h-1.875zm5.687 3.75v-5.625h5.625v5.625H24.5zm1.875-3.75v1.875h1.875v-1.875h-1.875zm-24.5 11.312V24.5H7.5v5.625H1.875zm1.875-3.75v1.875h1.875v-1.875H3.75zm5.688 3.75V24.5h5.625v5.625H9.438zm1.875-3.75v1.875h1.875v-1.875h-1.875zm5.625 3.75V24.5h5.625v5.625h-5.625zm1.875-3.75v1.875h1.875v-1.875h-1.875zm5.687 3.75V24.5h5.625v5.625H24.5zm1.875-3.75v1.875h1.875v-1.875h-1.875z',
	    'layout-grid3' => 'M0 9.438V0h9.438v9.438H0zm1.875-7.563V7.5H7.5V1.875H1.875zm9.438 7.563V0h9.375v9.438h-9.375zm1.875-7.563V7.5h5.625V1.875h-5.625zM22.563 0h9.438v9.438h-9.438V0zm7.562 7.5V1.875H24.5V7.5h5.625zM0 20.688v-9.375h9.438v9.375H0zm1.875-7.5v5.625H7.5v-5.625H1.875zm9.438 7.5v-9.375h9.375v9.375h-9.375zm1.875-7.5v5.625h5.625v-5.625h-5.625zm9.375 7.5v-9.375h9.438v9.375h-9.438zm1.937-7.5v5.625h5.625v-5.625H24.5zM0 32v-9.438h9.438V32H0zm1.875-7.5v5.625H7.5V24.5H1.875zm9.438 7.5v-9.438h9.375V32h-9.375zm1.875-7.5v5.625h5.625V24.5h-5.625zm9.375 7.5v-9.438h9.438V32h-9.438zm1.937-7.5v5.625h5.625V24.5H24.5z',
	    'layout-grid2' => 'M0 13.188V0h13.188v13.188H0zM1.875 1.875v9.438h9.438V1.875H1.875zM16.938 0h13.188v13.188H16.938V0zM28.25 11.313V1.875h-9.438v9.438h9.438zM0 30.125V16.937h13.188v13.188H0zm1.875-11.312v9.438h9.438v-9.438H1.875zm15.063 11.312V16.937h13.188v13.188H16.938zm1.875-11.312v9.438h9.438v-9.438h-9.438z',
	    'layout-grid2-thumb' => 'M0 3.75v5.688h5.625V3.75H0zm16.938 5.688V3.75h5.625v5.688h-5.625zM0 24.5v-5.688h5.625V24.5H0zm16.938 0v-5.688h5.625V24.5h-5.625zM7.5 5.625V3.75h7.563v1.875H7.5zm0 3.813V7.5h7.563v1.938H7.5zm17-5.688H32v1.875h-7.5V3.75zm0 5.688V7.5H32v1.938h-7.5zm-11.312 1.875v1.875H7.5v-1.875h5.688zm16.937 0v1.875H24.5v-1.875h5.625zM7.5 20.688v-1.875h7.563v1.875H7.5zm0 3.812v-1.938h7.563V24.5H7.5zm17-3.812v-1.875H32v1.875h-7.5zm0 3.812v-1.938H32V24.5h-7.5zm-17 3.75v-1.875h5.688v1.875H7.5zm17 0v-1.875h5.625v1.875H24.5z',
	    'layout-cta-right' => 'M0 5.625h32v20.75H0V5.625zM30.125 24.5v-17H1.875v17h28.25zm-3.75-9.437v-1.875H7.5v1.875h18.875zm-9.437 1.875v3.75h9.438v-3.75h-9.438z',
	    'layout-cta-left' => 'M0 5.625h32v20.75H0V5.625zM30.125 24.5v-17H1.875v17h28.25zM24.5 15.063v-1.875H5.625v1.875H24.5zm-9.437 5.625v-3.75H5.625v3.75h9.438z',
	    'layout-cta-center' => 'M26.375 15.063v-1.875H5.625v1.875h20.75zM32 5.625H0v20.75h32V5.625zM30.125 7.5v17H1.875v-17h28.25zM11.938 20.688v-3.75h8.125v3.75h-8.125z',
	    'layout-cta-btn-right' => 'M16.938 13.188v-1.875H3.75v1.875h13.188zM7.5 16.938v-1.875h9.438v1.875H7.5zM32 5.625H0V24.5h32V5.625zM30.125 7.5v15.063H1.875V7.5h28.25zm-1.875 3.813v3.75h-9.438v-3.75h9.438z',
	    'layout-cta-btn-left' => 'M28.25 13.188v-1.875H15.062v1.875H28.25zm-13.187 3.75v-1.875h9.438v1.875h-9.438zM32 5.625H0V24.5h32V5.625zM30.125 7.5v15.063H1.875V7.5h28.25zm-16.937 3.813v3.75H3.75v-3.75h9.438z',
	    'layout-column4' => 'M1.875 32V0H7.5v32H1.875zM3.75 1.875v28.25h1.875V1.875H3.75zM9.438 32V0h5.625v32H9.438zm1.875-30.125v28.25h1.875V1.875h-1.875zM16.938 32V0h5.625v32h-5.625zm1.875-30.125v28.25h1.875V1.875h-1.875zM24.5 0h5.625v32H24.5V0zm3.75 30.125V1.875h-1.875v28.25h1.875z',
	    'layout-column3' => 'M0 32V0h9.438v32H0zM1.875 1.875v28.25H7.5V1.875H1.875zM11.313 32V0h9.375v32h-9.375zm1.875-30.125v28.25h5.625V1.875h-5.625zM22.563 0h9.438v32h-9.438V0zm7.562 30.125V1.875H24.5v28.25h5.625z',
	    'layout-column2' => 'M0 32V0h15.063v32H0zM1.875 1.875v28.25h11.313V1.875H1.875zM16.938 0h15.063v32H16.938V0zm13.187 30.125V1.875H18.812v28.25h11.313z',
	    'layout-accordion-separated' => 'M0 0h32v5.625H0V0zm30.125 3.75V1.875H1.875V3.75h28.25zM0 24.5v-17h32v17H0zM1.875 9.438v13.125h28.25V9.438H1.875zM0 32v-5.625h32V32H0zm1.875-3.75v1.875h28.25V28.25H1.875z',
	    'layout-accordion-merged' => 'M0 0h32v32H0V0zm30.125 1.875H1.875v16.938h28.25V1.875zm0 18.813H1.875v3.813h28.25v-3.813zm-28.25 9.437h28.25v-3.75H1.875v3.75z',
	    'layout-accordion-list' => 'M7.5 0H32v16.938H7.5V0zm22.625 15.063V1.875H9.437v13.188h20.688zM0 5.625V0h5.625v5.625H0zm1.875-3.75V3.75H3.75V1.875H1.875zM7.5 24.5v-5.688H32V24.5H7.5zm1.938-3.812v1.875h20.688v-1.875H9.438zM0 24.5v-5.688h5.625V24.5H0zm1.875-3.812v1.875H3.75v-1.875H1.875zM7.5 32v-5.625H32V32H7.5zm1.938-3.75v1.875h20.688V28.25H9.438zM0 32v-5.625h5.625V32H0zm1.875-3.75v1.875H3.75V28.25H1.875z',
	    'ink-pen' => 'M5.625 0h20.75v12.25L15.937 30.125 5.624 12.25V0zm10.313 26.375zM16 11.313c1.063 0 1.875-.875 1.875-1.875 0-1.063-.813-1.938-1.875-1.938s-1.875.875-1.875 1.938c0 1 .813 1.875 1.875 1.875zm8.5.437V1.875h-17v9.875l7.563 13.063v-11.75c-1.625-.438-2.813-1.875-2.813-3.625 0-2.125 1.688-3.813 3.75-3.813s3.75 1.688 3.75 3.813c0 1.75-1.188 3.188-2.813 3.625v11.563z',
	    'info-alt' => 'M16 0c8.813 0 16 7.188 16 16s-7.188 16-16 16S0 24.812 0 16 7.188 0 16 0zm0 30.125c7.813 0 14.125-6.313 14.125-14.125S23.812 1.875 16 1.875 1.875 8.188 1.875 16 8.188 30.125 16 30.125zm.938-6.812v-10.25H13.25v1.875h1.813v8.375h-1.875v1.875h5.625v-1.875h-1.875zM13.5 9.375c0 1.063.875 1.875 1.875 1.875 1.063 0 1.875-.813 1.875-1.875 0-1-.813-1.875-1.875-1.875-1 0-1.875.875-1.875 1.875z',
	    'help-alt' => 'M16 0c8.813 0 16 7.188 16 16s-7.188 16-16 16S0 24.812 0 16 7.188 0 16 0zm0 30.125c7.813 0 14.125-6.313 14.125-14.125S23.812 1.875 16 1.875 1.875 8.188 1.875 16 8.188 30.125 16 30.125zM18.188 23c0-1.063-.875-1.938-1.938-1.938s-1.938.875-1.938 1.938.875 1.938 1.938 1.938 1.938-.875 1.938-1.938zm1.875-15.062c-.938-1.188-2.25-1.813-3.813-1.813-4.188 0-5.375 3.188-5.438 4.875h1.875c.063-.313.188-3 3.563-3 1 0 1.75.375 2.313 1.125.625.75.75 1.625.688 1.875-.313 1.375-1.125 2.063-2 2.875-1.125 1-2.375 2.125-2.375 4.5h1.875c0-1.5.75-2.188 1.75-3.125 1-.875 2.125-1.875 2.625-3.813.188-1-.188-2.438-1.063-3.5z',
	    'headphone-alt' => 'M29.5 11.313c1.375.188 2.5 1.375 2.5 2.813v7.5c0 1.563-1.25 2.875-2.813 2.875h-2.813v-1.938h-1.875v-9.375h1.875v-1.875h1.125c-1.75-5.625-6.313-9.438-11.5-9.438s-9.75 3.875-11.5 9.438h1.125v1.875h1.875v9.375H5.624v1.938h-2c.438 2.125 2.375 3.75 4.625 3.75h5.125c.375-1.125 1.375-1.875 2.625-1.875h5.625c1.563 0 2.875 1.25 2.875 2.813s-1.313 2.813-2.875 2.813h-5.625c-1.25 0-2.25-.813-2.625-1.875H8.249c-3.375 0-6.125-2.563-6.5-5.875-1-.438-1.75-1.438-1.75-2.625v-7.5c0-1.438 1.125-2.625 2.5-2.813C4.312 4.626 9.812.001 15.999.001c6.25 0 11.688 4.625 13.5 11.313zM16 28.25c-.5 0-.938.438-.938.938s.438.938.938.938h5.625c.563 0 .938-.438.938-.938s-.375-.938-.938-.938H16zM3.75 22.563v-9.375h-.938c-.5 0-.938.438-.938.938v7.5c0 .563.438.938.938.938h.938zm26.375-.938v-7.5c0-.5-.438-.938-.938-.938h-.938v9.375h.938c.5 0 .938-.375.938-.938z',
	    'hand-point-up' => 'M27.313 15.5c0-1.563-1.313-2.875-2.875-2.875-.313 0-.625.063-.875.125v-.25c0-1.625-1.25-2.875-2.813-2.875-.375 0-.688.063-.938.125-.125-1.5-1.375-2.625-2.813-2.625-.375 0-.688.063-1 .125V2.875c0-1.563-1.25-2.875-2.813-2.875s-2.875 1.313-2.875 2.875v9.25l-.5-.563c-.5-.5-1.875-1.938-3.688-.813-1.375.75-1.813 2.563-1.063 3.813l6.188 13.375c.25.5.625.813 1.063 1.125V30c0 .5.438.938.938.938s.938-.438.938-.938v-1.625c0-.375-.313-.75-.688-.875-.25-.063-.5-.25-.563-.375L6.748 13.75c-.313-.5-.125-1.125.313-1.438.25-.125.563-.313 1.438.563l2.063 2.313c.313.25.688.375 1.063.188.375-.125.563-.438.563-.875V2.876c0-.563.438-1 1-1 .5 0 .938.438.938 1v6.875c0 .5.375.875.875.938.5 0 .938-.375 1-.813.063-.5.5-.875 1-.875s.938.438.938 1v2.375c0 .5.375.938.875.938.563.063.938-.375 1-.875 0-.563.438-.938.938-.938s.938.438.938 1v2.938c0 .5.438.938.938.938.563.063.938-.375.938-.875s.313-1 .875-1c.5 0 1 .438 1 1v6c0 .938-.563 2.438-1.063 3.75-.438 1.313-.875 2.375-.875 3.125v1.625c0 .5.438.938 1 .938.5 0 .938-.438.938-.938v-1.625c0-.438.375-1.5.688-2.5.563-1.438 1.188-3.125 1.188-4.375v-6z',
	    'hand-point-right' => 'M31.875 14.125c0-1.563-1.313-2.875-2.938-2.875h-9.188l.5-.438c.563-.563 1.938-1.938.875-3.75-.813-1.375-2.563-1.813-3.875-1.063L3.874 12.187c-.438.25-.813.625-1.063 1.063h-.938c-.5 0-.938.438-.938.938s.438.938.938.938h1.563c.438 0 .813-.313.938-.688.063-.25.188-.5.375-.563l13.375-6.188c.5-.313 1.125-.125 1.375.313.188.313.313.563-.5 1.438l-2.313 2.063c-.25.313-.375.688-.25 1.063s.5.563.875.563h11.625c.563 0 1.063.438 1.063 1 0 .5-.5.938-1.063.938h-6.813c-.5 0-.875.375-.938.875s.313.938.813 1 .875.5.875 1-.438.938-1 .938h-2.375c-.5 0-.938.375-.938.875-.063.5.375.938.875 1 .5 0 .938.438.938.938s-.438.938-1 .938h-2.938c-.563 0-.938.438-.938.938-.063.5.375.938.875.938s1 .313 1 .875-.5 1-1 1h-6c-.938 0-2.438-.563-3.75-1.063-1.313-.438-2.375-.813-3.125-.813H1.872c-.5 0-.938.375-.938.938 0 .5.438.938.938.938h1.625c.438 0 1.5.375 2.438.75 1.5.5 3.125 1.125 4.438 1.125h6c1.563 0 2.875-1.313 2.875-2.875 0-.313-.063-.563-.125-.875h.25c1.563 0 2.875-1.25 2.875-2.813 0-.313-.063-.688-.188-.938 1.5-.125 2.688-1.375 2.688-2.813 0-.375-.063-.688-.188-1h4.375c1.625 0 2.938-1.25 2.938-2.813z',
	    'hand-point-left' => 'M30.938 25.438c0-.563-.438-.938-.938-.938h-1.625c-.75 0-1.813.375-3.125.813-1.313.5-2.813 1.063-3.75 1.063h-6c-.563 0-1-.438-1-1s.5-.875 1-.875.875-.438.875-.938-.438-.938-.938-.938h-2.938c-.563 0-1-.438-1-.938s.375-.938.938-.938c.5-.063.875-.5.875-1s-.438-.875-.938-.875H9.999c-.563 0-1-.438-1-.938s.375-.938.875-1c.438-.063.813-.5.813-1-.063-.5-.438-.875-.938-.875H2.874c-.563 0-1-.438-1-.938 0-.563.438-1 1-1h11.625c.438 0 .75-.188.875-.563.188-.375.063-.75-.188-1.063l-2.25-2.063c-.938-.875-.75-1.125-.625-1.438.313-.438.938-.625 1.5-.313l13.188 6.125c.25.125.438.375.5.625.125.375.5.688.875.688h1.625c.5 0 .938-.438.938-.938s-.438-.938-.938-.938h-1c-.25-.438-.625-.813-1.125-1.125l-13.25-6.125c-1.313-.75-3.125-.313-3.875 1.063-1.125 1.813.313 3.188.875 3.75l.5.438h-9.25c-1.563 0-2.875 1.313-2.875 2.875s1.313 2.813 2.875 2.813h4.375c-.063.313-.125.625-.125 1 0 1.438 1.125 2.688 2.625 2.813-.063.25-.125.563-.125.938 0 1.563 1.313 2.813 2.875 2.813h.25c-.063.313-.125.563-.125.875 0 1.563 1.313 2.875 2.875 2.875h6c1.25 0 2.938-.625 4.375-1.125 1-.375 2.063-.75 2.5-.75h1.625c.5 0 .938-.438.938-.938z',
	    'hand-point-down' => 'M25.875 21.25c1.375-.75 1.813-2.563 1.063-3.813L20.75 4.062c-.25-.5-.625-.813-1.063-1.125v-.938c0-.5-.438-.938-.938-.938s-.938.438-.938.938v1.625c0 .375.313.75.688.875.25.063.5.25.563.375l6.188 13.375c.313.5.125 1.125-.313 1.438-.25.125-.563.313-1.438-.563l-2.063-2.313c-.313-.25-.688-.375-1.063-.188-.375.125-.563.438-.563.875v11.625c0 .563-.438 1-1 1-.5 0-.938-.438-.938-1v-6.875c0-.5-.375-.875-.875-.938-.5 0-.938.375-1 .813-.063.5-.5.875-1 .875s-.938-.438-.938-1v-2.375c0-.5-.375-.938-.875-.938-.563 0-.938.375-1 .875 0 .563-.438.938-.938.938s-.938-.438-.938-1V16.56c0-.5-.438-.938-.938-.938-.5 0-.938.375-.938.875s-.313 1-.875 1c-.5 0-1-.438-1-1v-6c0-.938.563-2.438 1.063-3.75s.875-2.375.875-3.125V1.997c0-.5-.438-.938-1-.938-.5 0-.938.438-.938.938v1.625c0 .438-.375 1.5-.688 2.5-.563 1.438-1.188 3.125-1.188 4.375v6c0 1.563 1.313 2.875 2.875 2.875.313 0 .625-.063.875-.125v.25c0 1.625 1.25 2.875 2.813 2.875.375 0 .688-.063.938-.125.125 1.5 1.375 2.625 2.813 2.625.375 0 .688 0 1-.125v4.375c0 1.563 1.25 2.875 2.813 2.875s2.875-1.313 2.875-2.875v-9.25l.5.563c.5.5 1.875 1.938 3.688.813z',
	    'gallery' => 'M24.5 18.813v5.688H0V.001h24.5v18.813zM1.875 1.875v15.063h1.313l6.75-11.25 4.25 7.313 2.125-2.313 4.875 6.25h1.375V1.875H1.875zm16.938 15.063l-2.625-3.375-2.375 2.563-3.938-6.75-4.5 7.563h13.438zM1.875 22.563h20.688v-3.75H1.875v3.75zM32 5.625h-5.625V7.5h3.75v20.75H9.437v-1.875H7.499v3.75h24.5v-24.5z',
	    'face-smile' => 'M16 0c8.813 0 16 7.188 16 16s-7.188 16-16 16S0 24.812 0 16 7.188 0 16 0zm0 30.125c7.813 0 14.125-6.313 14.125-14.125S23.812 1.875 16 1.875 1.875 8.188 1.875 16 8.188 30.125 16 30.125zm8.5-13.187c0-.5-.438-.938-1-.938-.5 0-.938.438-.938.938 0 3.625-2.938 6.563-6.563 6.563s-6.563-2.938-6.563-6.563c0-.5-.438-.938-.938-.938-.563 0-1 .438-1 .938 0 4.688 3.813 8.5 8.5 8.5s8.5-3.813 8.5-8.5zm-16-6.563c0 1 .813 1.875 1.875 1.875 1 0 1.875-.875 1.875-1.875 0-1.063-.875-1.875-1.875-1.875-1.063 0-1.875.813-1.875 1.875zm11.25 0c0 1 .875 1.875 1.875 1.875 1.063 0 1.875-.875 1.875-1.875 0-1.063-.813-1.875-1.875-1.875-1 0-1.875.813-1.875 1.875z',
	    'face-sad' => 'M16 0c8.813 0 16 7.188 16 16s-7.188 16-16 16S0 24.812 0 16 7.188 0 16 0zm0 30.125c7.813 0 14.125-6.313 14.125-14.125S23.812 1.875 16 1.875 1.875 8.188 1.875 16 8.188 30.125 16 30.125zm8.5-5.625c0-4.688-3.813-8.5-8.5-8.5s-8.5 3.813-8.5 8.5c0 .5.438.938 1 .938.5 0 .938-.438.938-.938 0-3.688 2.938-6.625 6.563-6.625s6.563 2.938 6.563 6.625c0 .5.438.938.938.938.563 0 1-.438 1-.938zm-16-14.125c0 1 .813 1.875 1.875 1.875 1 0 1.875-.875 1.875-1.875 0-1.063-.875-1.875-1.875-1.875-1.063 0-1.875.813-1.875 1.875zm11.25 0c0 1 .875 1.875 1.875 1.875 1.063 0 1.875-.875 1.875-1.875 0-1.063-.813-1.875-1.875-1.875-1 0-1.875.813-1.875 1.875z',
	    'credit-card' => 'M29.188 3.75c1.563 0 2.813 1.313 2.813 2.813v18.875c0 1.5-1.25 2.813-2.813 2.813H2.813C1.25 28.251 0 26.938 0 25.438V6.563c0-1.5 1.25-2.813 2.813-2.813h26.375zm.937 21.688V15.063H1.875v10.375c0 .5.438.938.938.938h26.375c.5 0 .938-.438.938-.938zm-28.25-16h28.25V6.563c0-.5-.438-.938-.938-.938H2.812c-.5 0-.938.438-.938.938v2.875z',
	    'control-skip-forward' => 'M5.625 27.438V4.563l13.75 11.375zM7.5 8.563v14.813l8.938-7.438zM26.375 3.75H24.5v24.5h1.875V3.75z',
	    'control-skip-backward' => 'M12.625 16.063l13.75-11.5v22.875zM24.5 23.438V8.625l-8.938 7.438zM5.625 3.75v24.5H7.5V3.75H5.625z',
	    'control-record' => 'M16 4.688c6.25 0 11.313 5.063 11.313 11.313S22.25 27.314 16 27.314 4.687 22.251 4.687 16.001 9.75 4.688 16 4.688zm0 20.75c5.188 0 9.438-4.25 9.438-9.438S21.188 6.562 16 6.562 6.562 10.812 6.562 16s4.25 9.438 9.438 9.438z',
	    'control-eject' => 'M15.938 5.125l11.5 13.688H4.563zm0 2.938l-7.375 8.875h14.813zM28.25 24.5H3.75v1.875h24.5V24.5z',
	    'comments-smiley' => 'M24.5 15.063c0 3.625-3 6.563-6.625 6.563s-6.563-2.938-6.563-6.563H9.437c0 4.688 3.75 8.438 8.438 8.438s8.5-3.75 8.5-8.438H24.5zM14.125 12.25c-1.063 0-1.875-.875-1.875-1.875 0-1.063.813-1.875 1.875-1.875S16 9.313 16 10.375c0 1-.813 1.875-1.875 1.875zm7.5 0c-1 0-1.875-.875-1.875-1.875 0-1.063.875-1.875 1.875-1.875 1.063 0 1.875.813 1.875 1.875 0 1-.813 1.875-1.875 1.875zM32 14.125C32 6.312 25.687 0 17.875 0 10.125 0 3.75 6.313 3.75 14.125c0 2.5.688 5 2 7.125L.375 31.625 10.75 26.25c2.125 1.313 4.625 2 7.125 2C25.688 28.25 32 21.875 32 14.125zm-1.875 0c0 6.75-5.5 12.25-12.25 12.25-2.313 0-4.625-.688-6.625-2l-.438-.25-6.063 3.125 3.125-6.063-.25-.438c-1.313-2-2-4.313-2-6.625 0-6.75 5.5-12.25 12.25-12.25s12.25 5.5 12.25 12.25z',
	    'brush-alt' => 'M32 14.188v6.563h-1.75l1.438 11.25H.313l1.438-11.25H.001v-6.563c0-1.563 1.25-2.813 2.813-2.813h9.063l-.563-2.063v-6.5c0-1.563 1.25-2.813 2.813-2.813h3.75c1.563 0 2.813 1.25 2.813 2.813v6.813l-.563 1.75h9.063c1.563 0 2.813 1.25 2.813 2.813zm-2.437 15.937l-1.188-9.375H3.625l-1.188 9.375h3.188v-3.75H7.5v3.75h9.438v-7.563h1.875v7.563h1.875V24.5h1.875v5.625h1.938v-3.75h1.875v3.75h3.188zM2 18.875h28.125v-4.688c0-.5-.438-.938-.938-.938H17.562l1.25-4.063V2.811c0-.5-.438-.938-.938-.938h-3.75c-.5 0-.938.438-.938.938v6.375l1.25 4.063H2.811c-.5 0-.938.438-.938.938v4.688h.125zM15.063 3.75v1.875h1.875V3.75h-1.875z',
	    'youtube' => 'M15.625 12.063c-.813 0-1.438-.25-1.875-.875-.313-.5-.5-1.188-.5-2.125V5.938c0-.938.188-1.625.5-2.063.438-.625 1.063-.938 1.875-.938s1.438.313 1.875.938c.375.438.5 1.125.5 2.063v3.125c0 .938-.125 1.688-.5 2.125-.438.625-1.063.875-1.875.875zm-.75-6.438v3.75c0 .813.25 1.25.75 1.25.563 0 .75-.438.75-1.25v-3.75c0-.813-.188-1.25-.75-1.25-.5 0-.75.438-.75 1.25zm4.625 5.813c.125.438.5.625 1.063.625s1.188-.313 1.813-1.063v.938h1.625V3.063h-1.625v6.813c-.375.5-.688.75-1 .75-.25 0-.375-.125-.375-.375-.063-.063-.063-.25-.063-.625V3.063h-1.625v7c0 .688.063 1.125.188 1.375zm6.188 10.812c0-.813-.313-1.25-.813-1.25-.563 0-.813.438-.813 1.25v.813h1.625v-.813zM8.188 3.313c.563 1.688.938 2.938 1.125 3.813v4.813h1.75V7.126L13.251.001h-1.813l-1.25 4.688L8.938.001H7.063c.375 1.125.75 2.25 1.125 3.313zm20.562 13.25c.5 2 .5 4.125.5 6.25 0 2-.063 4.25-.5 6.25-.313 1.375-1.438 2.438-2.813 2.563-3.313.375-6.625.375-9.938.375s-6.625 0-9.938-.375c-1.375-.125-2.5-1.188-2.813-2.563-.5-2-.5-4.25-.5-6.25 0-2.125.063-4.25.5-6.25.313-1.438 1.438-2.5 2.875-2.625 3.25-.375 6.563-.375 9.875-.375s6.625 0 9.938.375c1.375.125 2.5 1.188 2.813 2.625zm-18.437 1.75v-1.625H4.75v1.625h1.875v10.188h1.813V18.313h1.875zM15.125 28.5v-8.813h-1.563v6.75c-.375.5-.688.75-1 .75-.25 0-.375-.125-.375-.375-.063-.063-.063-.25-.063-.625v-6.5h-1.563v7c0 .625.063 1 .125 1.25.125.5.5.688 1.063.688s1.188-.375 1.813-1.063v.938h1.563zm6.063-2.625v-3.563c0-.813 0-1.375-.125-1.75-.188-.625-.625-1-1.25-1s-1.188.313-1.688 1v-3.875h-1.563V28.5h1.563v-.875c.563.688 1.063 1 1.688 1s1.063-.313 1.25-1c.125-.375.125-.938.125-1.75zm6.062-1.5v-1.813c0-.938-.125-1.625-.5-2.063-.438-.625-1.063-.938-1.875-.938s-1.438.313-1.938.938c-.313.438-.5 1.125-.5 2.063v3.063c0 .938.188 1.688.563 2.063.438.625 1.063.938 1.938.938.813 0 1.5-.313 1.875-.938.25-.313.375-.625.375-1 .063-.125.063-.5.063-1v-.25h-1.625c0 .625 0 1-.063 1.125-.063.375-.313.625-.688.625-.563 0-.813-.438-.813-1.25v-1.563h3.188zm-7.625-2.187c0-.75-.25-1.188-.688-1.188-.25 0-.563.125-.813.438v5.375c.25.25.563.375.813.375.438 0 .688-.375.688-1.188v-3.813z',
	    'vimeo' => 'M29.5 5.063c.75 1 1 2.25.688 3.875-.375 2.063-2.625 7.813-6.188 12.688-2 2.625-4 4.5-6.188 5.813-.75.438-2.125 1-3.375 1-.5 0-.938-.063-1.313-.25-2.563-1.063-3.5-4.875-4.188-7.625l-.25-1.188c-.375-1.313-.688-2.625-1.125-3.75-.125-.313-.188-.688-.313-1-.188-.688-.313-1.313-.688-1.813-.125-.313-.188-.313-.25-.313-.188 0-.5.125-.813.188-.5.188-1.188.375-1.875.313-.813-.125-1.063-.688-1.188-.938-.125-.188-.125-.188-.25-.25-.313-.188-.5-.5-.5-.875 0-.25.188-.75.375-.938 1-.625 1.813-1.375 2.625-2.125 1.125-1 2.188-2 3.563-2.813.375-.188 1.5-.813 2.813-.813.313 0 .688.063.938.125 1.375.438 2.313 2 2.688 3.188.313 1.063.5 2.25.688 3.25l.125.75c.125.563.188 1.063.188 1.688.188 1.75.375 3.75 1.375 4.75.188.25.375.375.5.375.5 0 1.375-1.5 1.625-2 .563-1.125 1.125-2.25 1.188-3.188.063-.688 0-1.25-.188-1.438-.25-.25-1-.313-2.063-.25-.313 0-.625-.125-.813-.375-.25-.25-.313-.563-.188-.875 1.375-4.25 5.438-6.313 7.063-6.625.438-.063.938-.063 1.438-.063 1.75 0 3.063.5 3.875 1.5zm-1.187 3.5C28.501 7.5 28.438 6.75 28 6.25c-.563-.688-1.75-.813-2.375-.813-.438 0-.813 0-1.125.063-.625.125-3.563 1.188-5.063 4.063.688.063 1.563.25 2.125.938.625.625.813 1.563.688 2.875s-.75 2.563-1.313 3.688c-.75 1.375-1.75 3.188-3.375 3.188-.688 0-1.313-.313-1.875-.938-1.438-1.5-1.625-3.813-1.813-5.875-.063-.563-.125-1.063-.188-1.563l-.125-.688c-.188-1-.375-2.125-.688-3.063-.25-.875-.938-1.813-1.375-1.938-.125 0-.25-.063-.438-.063-.625 0-1.375.313-1.813.563-1.25.75-2.25 1.625-3.313 2.563-.625.563-1.25 1.188-1.938 1.75 0 0 .063.063.063.125.313 0 .625-.125.875-.188.438-.125.875-.313 1.375-.313.75 0 1.438.438 1.875 1.188s.688 1.563.875 2.313c.125.25.188.563.313.875.438 1.25.75 2.5 1.125 3.875l.313 1.25c.563 2.375 1.375 5.625 3.063 6.375.688.25 2.188-.188 2.938-.688 2-1.188 3.813-2.938 5.625-5.375 3.688-4.875 5.625-10.375 5.875-11.875z',
	    'twitter' => 'M32 6.063c-.875 1.313-2 2.5-3.313 3.438.063.25.063.563.063.813 0 8.688-6.625 18.688-18.688 18.688-3.688 0-7.188-1.063-10.063-2.938.5.063 1.063.063 1.563.063 3.063 0 5.938-1 8.188-2.813-2.875-.063-5.313-1.938-6.125-4.563.375.063.813.125 1.188.125.625 0 1.188-.063 1.75-.188-3-.625-5.25-3.25-5.25-6.438v-.125c.875.5 1.875.813 2.938.875-1.75-1.188-2.938-3.188-2.938-5.5 0-1.188.375-2.313.938-3.313 3.188 4 8.063 6.625 13.5 6.875-.063-.5-.125-1-.125-1.5 0-3.625 2.875-6.563 6.5-6.563 1.938 0 3.625.813 4.813 2.063 1.5-.25 2.938-.813 4.188-1.563-.5 1.5-1.563 2.813-2.875 3.625 1.313-.188 2.563-.5 3.75-1.063zm-5.125 4.25c0-.25 0-.438-.063-.688 0-.375.063-.75.25-1.063-.313-.188-.5-.5-.625-.875-.125-.25-.125-.563-.063-.813-.313-.125-.563-.25-.813-.5-.875-.938-2.125-1.5-3.438-1.5-2.563 0-4.625 2.125-4.625 4.688 0 .375 0 .75.125 1.125.063.563-.063 1.188-.438 1.625-.375.375-.875.625-1.438.625h-.063c-4.625-.25-9-2-12.438-5 .125 1.438.875 2.688 2.063 3.5.688.438 1 1.313.75 2.125-.25.75-1 1.313-1.813 1.313h-.25c.688.938 1.688 1.688 2.938 1.938.875.188 1.5.938 1.5 1.813s-.563 1.625-1.438 1.875c.75.563 1.75.938 2.75.938.813 0 1.5.563 1.75 1.313s0 1.563-.625 2.063c-1.063.875-2.313 1.563-3.563 2.063.938.188 1.813.25 2.75.25 11.563 0 16.813-9.813 16.813-16.813z',
	    'twitter-alt' => 'M28.688 9.5c1.313-.938 2.438-2.125 3.313-3.438-1.188.563-2.438.875-3.75 1.063C29.564 6.312 30.626 5 31.126 3.5c-1.25.75-2.688 1.313-4.188 1.563C25.75 3.813 24.063 3 22.125 3c-3.625 0-6.563 2.938-6.563 6.563 0 .5.063 1 .188 1.5-5.438-.25-10.313-2.875-13.5-6.875-.563 1-.938 2.125-.938 3.313 0 2.313 1.188 4.313 2.938 5.5-1.063-.063-2.063-.375-2.938-.875v.125c0 3.188 2.25 5.813 5.25 6.438-.563.125-1.125.188-1.75.188-.375 0-.813-.063-1.188-.125.813 2.625 3.188 4.5 6.125 4.563-2.25 1.813-5.125 2.813-8.188 2.813-.5 0-1.063 0-1.563-.063 2.875 1.875 6.375 2.938 10.063 2.938 12.063 0 18.688-10 18.688-18.688 0-.25 0-.563-.063-.813z',
	    'time' => 'M16.313 0c8.813 0 16 7.188 16 16s-7.188 16-16 16-16-7.188-16-16 7.188-16 16-16zm0 30.125c7.813 0 14.125-6.313 14.125-14.125S24.125 1.875 16.313 1.875 2.188 8.188 2.188 16s6.313 14.125 14.125 14.125zm10.062-13.187h-9.438v-7.5h-1.875v9.375h11.313v-1.875z',
	    'tumblr' => 'M24.75 23.875l1.438-.938V30l-.5.25c-1.438.688-2.625 1.125-3.688 1.375S19.687 32 18.375 32c-1.438 0-2.75-.188-3.938-.563-1.125-.375-2.125-.938-3-1.688s-1.5-1.563-1.813-2.438c-.313-.813-.5-1.938-.5-3.438v-9.688H5.811V8.31l.625-.188c1.063-.375 2-.875 2.75-1.5.688-.625 1.313-1.375 1.75-2.25.438-.938.813-2.125 1-3.563l.063-.813h6.063v7.625h7.125v6.563h-7.125v6.813c0 2.063.125 2.813.25 3.063.063.25.313.5.625.688.5.313 1.063.438 1.813.438 1.313 0 2.625-.438 4-1.313zm-.437 4.938V26.25c-2.188 1.063-4.625 1.188-6.375.125-.688-.438-1.188-1-1.438-1.688-.188-.625-.313-1.688-.313-3.688v-8.688h7.125V9.498h-7.125V1.873h-2.563c-.188 1.313-.563 2.375-1 3.313-.563 1.125-1.313 2.125-2.25 2.875-.75.688-1.688 1.188-2.688 1.625v2.625h3.313v11.563c0 1.25.125 2.188.375 2.75.188.625.625 1.188 1.25 1.75.688.563 1.5 1 2.375 1.25 1.875.625 4.625.625 6.563.125.813-.188 1.75-.5 2.75-.938z',
	    'skype' => 'M30.5 18.688c1 1.438 1.5 3.125 1.5 4.813 0 4.688-3.813 8.5-8.5 8.5-1.688 0-3.375-.5-4.813-1.5-9.375 1.688-17.438-5.5-17.438-14.5 0-.875.063-1.813.25-2.688-1-1.438-1.5-3.125-1.5-4.813 0-4.688 3.813-8.5 8.5-8.5 1.688 0 3.375.5 4.813 1.5C22.687-.188 30.75 7 30.75 16c0 .875-.063 1.813-.25 2.688zm-7 11.437c3.688 0 6.625-2.938 6.625-6.625 0-1.438-.5-2.813-1.375-4l-.25-.313.063-.438c.188-.938.313-1.875.313-2.75 0-7.063-5.813-12.875-12.875-12.875-.875 0-1.813.125-2.75.313l-.438.063-.313-.25c-1.188-.875-2.563-1.375-4-1.375-3.688 0-6.625 2.938-6.625 6.625 0 1.438.5 2.813 1.375 4l.25.313-.063.438c-.188.938-.313 1.875-.313 2.75 0 7.063 5.75 12.875 12.875 12.875.875 0 1.813-.125 2.75-.313l.438-.063.313.25c1.188.875 2.563 1.375 4 1.375zm.438-10.875c0-3.375-3.313-4.563-6.125-5.188l-2-.5c-1.5-.313-2.625-.563-2.625-1.75 0-1 1.125-1.5 2.813-1.5 3.125 0 3.125 2.25 5.063 2.25 1.25 0 2.063-1 2.063-2.125 0-2.25-3.75-3.688-7.5-3.688-3.375 0-7.313 1.438-7.313 5.438 0 3.313 2.188 4.438 5.063 5.125l2.875.75c1.75.438 2.813.625 2.813 1.875 0 1-1.125 1.75-2.875 1.75-3.625 0-3.813-3-5.875-3-1.375 0-2 .938-2 2.063 0 2.375 3.688 4.375 8.125 4.375 3.688 0 7.5-1.875 7.5-5.875z',
	    'share' => 'M12.813 25.188l1.25-1.313c-1.75-1.625-2.688-3.875-2.688-6.25 0-4.625 3.813-8.438 8.5-8.438h5.438l-4.938 5 1.313 1.313 7.25-7.25L21.688 1l-1.313 1.313 4.938 5h-5.438c-5.75 0-10.375 4.625-10.375 10.313 0 2.875 1.188 5.625 3.313 7.563zM30.188 17h1.875v12.188c0 1.563-1.25 2.813-2.813 2.813H2.937c-1.563 0-2.875-1.25-2.875-2.813V17H2v12.188c0 .5.375.938.938.938h26.313c.563 0 .938-.438.938-.938V17z',
	    'share-alt' => 'M10.375 15.5l1.375-1.313-5-5h5.5c4.625 0 8.438 3.813 8.438 8.438 0 2.375-.938 4.625-2.688 6.188l1.313 1.375c2.063-1.938 3.25-4.688 3.25-7.563 0-5.688-4.625-10.313-10.313-10.313h-5.5l5-5L10.375.999l-7.25 7.25zm19.75 1.5H32v12.188c0 1.563-1.25 2.813-2.813 2.813H2.812c-1.563 0-2.813-1.25-2.813-2.813V17h1.875v12.188c0 .5.438.938.938.938h26.375c.5 0 .938-.438.938-.938V17z',
	    'rocket' => 'M22.563 20.688s3.813 0 3.813 11.313c0 0-4.5-4.5-8.125-5.438 0 1.063-.625 1.938-1.313 1.938s-1.313-.875-1.313-1.938C12 27.501 7.5 32.001 7.5 32.001c0-11.313 3.813-11.313 3.813-11.313V9.438C11.313 0 16.938 0 16.938 0s5.625 0 5.625 9.438v11.25zM16.938 1.875c-.5.063-3.125.5-3.688 5.625h7.375c-.563-5.125-3.188-5.563-3.688-5.625zm0 22.625c2.375 0 5.188 1.625 7.313 3.188-.5-4-1.625-4.938-1.875-5.125h-1.688V9.438h-7.5v13.125H11.5c-.25.188-1.375 1.125-1.875 5.125 2.125-1.563 4.938-3.188 7.313-3.188z',
	    'pinterest' => 'M28.313 11.688c0-5.375-4.625-10.438-11.625-10.438C8 1.25 3.625 7.5 3.625 12.688c0 3.125 1.25 5.938 3.75 7 .438.125.813 0 .938-.5.063-.313.25-1.125.375-1.438.125-.5.063-.625-.25-1-.75-.938-1.25-2-1.25-3.625 0-4.625 3.438-8.75 9-8.75 4.938 0 7.625 3 7.625 7 0 5.25-2.313 9.75-5.813 9.75-1.875 0-3.313-1.625-2.875-3.563.563-2.313 1.625-4.813 1.625-6.438 0-1.5-.813-2.813-2.5-2.813-1.938 0-3.5 2.063-3.5 4.75 0 0 0 1.75.563 2.938C9.313 24.437 9 25.937 9 25.937c-.375 1.375-.375 2.938-.313 4.188 0 0 .188 2.188 2.125.75.688-1.063 1.5-2.5 1.875-3.875 0 0 .188-.813 1.25-5 .625 1.188 2.5 2.25 4.5 2.25 5.875 0 9.875-5.313 9.875-12.563z',
	    'new-window' => 'M28.25 3.75H14.125v1.875H25.25L7.437 23.438l1.375 1.375L26.375 7.188v10.688h1.875V3.751zm-7.562 26.375V17.5h1.875V32H0V9.437h14.25v1.875H1.875v18.813h18.813z',
	    'microsoft' => 'M14.563 29.625v-12.75h17.438V32zm1.875-10.875v9.188l13.688 1.875V18.75H16.438zM0 27.625v-10.75h13.125v12.5zm1.875-8.875v7.188l9.375 1.313v-8.5H1.875zM0 15.25V4.375l13.125-1.75V15.25H0zm1.875-9.187v7.313h9.375V4.751zm12.688-3.688L32.001 0v15.25H14.563V2.375zm15.562 11V2.187L16.437 4.062v9.313h13.688z',
	    'list-ol' => 'M32 7.5H9.437v1.938H32V7.5zM9.438 16.938v-1.875h22.563v1.875H9.438zm0 7.562v-1.938h22.563V24.5H9.438zm-5.5-17.937l-.938.5-.125-.563L4 5.875h.625v5.188h-.688v-4.5zM3.063 18v.063h2.313v.563h-3.25v-.438l.563-.563c1.25-1.188 1.875-1.875 1.875-2.688 0-.5-.25-1-1-1-.5 0-.875.25-1.125.438l-.188-.438c.375-.313.875-.563 1.438-.563 1.125 0 1.563.75 1.563 1.5 0 .938-.688 1.75-1.75 2.75zm1.125 5.313c.625.125 1.188.625 1.188 1.313 0 .813-.688 1.563-1.875 1.563-.563 0-1.125-.188-1.375-.375l.188-.5c.25.125.688.313 1.188.313.875 0 1.125-.563 1.125-1 0-.688-.625-1-1.313-1h-.375v-.563h.375c.5 0 1.125-.25 1.125-.875 0-.375-.25-.75-.875-.75-.438 0-.813.188-1.063.313l-.125-.5c.25-.188.75-.375 1.313-.375 1 0 1.5.625 1.5 1.25 0 .5-.375.938-1 1.188z',
	    'linkedin' => 'M1.313 10.938v19.438h6.5V10.938h-6.5zm3.25-9.313c2.25 0 3.625 1.438 3.625 3.313S6.813 8.313 4.563 8.313H4.5c-2.188 0-3.563-1.5-3.563-3.375s1.438-3.313 3.625-3.313zM23.625 10.5c4.25 0 7.438 2.813 7.438 8.75v11.125h-6.438V20c0-2.625-.938-4.375-3.313-4.375-1.75 0-2.813 1.188-3.313 2.313-.125.438-.188 1-.188 1.625v10.813h-6.438c.063-17.563 0-19.438 0-19.438h6.438v2.813c.813-1.375 2.375-3.25 5.813-3.25z',
	    'layout-sidebar-2' => 'M32 0h-7.5v32H32V0zM0 32V0h5.625v32H0zm20.688 0v-1.875h1.875V32h-1.875zm-6.438 0v-1.875h1.625V32H14.25zm3.25 0v-1.875h1.563V32H17.5zM11 32v-1.875h1.625V32H11zm-3.5 0v-1.875h1.938V32H7.5zm0-26.375V3.75h1.938v1.875H7.5zm0 18.875v-1.938h1.938V24.5H7.5zm0 3.75v-1.875h1.938v1.875H7.5zm0-7.562v-1.875h1.938v1.875H7.5zm0-7.5v-1.875h1.938v1.875H7.5zm0-3.75V7.5h1.938v1.938H7.5zm0 7.5v-1.875h1.938v1.875H7.5zm0-15.063V0h1.938v1.875H7.5zm3.5 0V0h1.625v1.875H11zm6.5 0V0h1.563v1.875H17.5zm-3.25 0V0h1.625v1.875H14.25zm6.438 0V0h1.875v1.875h-1.875zm0 7.563V7.5h1.875v1.938h-1.875zm0-3.813V3.75h1.875v1.875h-1.875zm0 7.563v-1.875h1.875v1.875h-1.875zm0 3.75v-1.875h1.875v1.875h-1.875zm0 11.312v-1.875h1.875v1.875h-1.875zm0-3.75v-1.938h1.875V24.5h-1.875zm0-3.812v-1.875h1.875v1.875h-1.875z',
	    'layout-grid4-alt' => 'M1.875 1.875V7.5H7.5V1.875H1.875zM9.438 7.5V1.875h5.625V7.5H9.438zm7.5 0V1.875h5.625V7.5h-5.625zM24.5 1.875h5.625V7.5H24.5V1.875zM1.875 15.063V9.438H7.5v5.625H1.875zm7.563 0V9.438h5.625v5.625H9.438zm7.5 0V9.438h5.625v5.625h-5.625zm7.562 0V9.438h5.625v5.625H24.5zm-22.625 7.5v-5.625H7.5v5.625H1.875zm7.563 0v-5.625h5.625v5.625H9.438zm7.5 0v-5.625h5.625v5.625h-5.625zm7.562 0v-5.625h5.625v5.625H24.5zM1.875 30.125V24.5H7.5v5.625H1.875zm7.563 0V24.5h5.625v5.625H9.438zm7.5 0V24.5h5.625v5.625h-5.625zm7.562 0V24.5h5.625v5.625H24.5z',
	    'layout-grid3-alt' => 'M0 0v9.438h9.438V0H0zm11.313 9.438V0h9.375v9.438h-9.375zM22.563 0h9.438v9.438h-9.438V0zM0 20.688v-9.375h9.438v9.375H0zm11.313 0v-9.375h9.375v9.375h-9.375zm11.25 0v-9.375h9.438v9.375h-9.438zM0 32v-9.438h9.438V32H0zm11.313 0v-9.438h9.375V32h-9.375zm11.25 0v-9.438h9.438V32h-9.438z',
	    'layout-grid2-alt' => 'M0 0v13.188h13.188V0H0zm16.938 0h13.188v13.188H16.938V0zM0 30.125V16.937h13.188v13.188H0zm16.938 0V16.937h13.188v13.188H16.938z',
	    'layout-column4-alt' => 'M1.875 0v32H7.5V0H1.875zm7.563 32V0h5.625v32H9.438zm7.5 0V0h5.625v32h-5.625zM24.5 0h5.625v32H24.5V0z',
	    'layout-column3-alt' => 'M0 0v32h9.438V0H0zm11.313 32V0h9.375v32h-9.375zm11.25-32h9.438v32h-9.438V0z',
	    'layout-column2-alt' => 'M0 0v32h15.063V0H0zm16.938 0h15.063v32H16.938V0z',
	    'instagram' => 'M24.5 0C28.625 0 32 3.375 32 7.5v17c0 4.125-3.375 7.5-7.5 7.5h-17C3.375 32 0 28.625 0 24.5v-17C0 3.375 3.375 0 7.5 0h17zm5.625 24.5V13.187h-6.063c.563 1.125.875 2.375.875 3.75 0 4.938-4 8.938-8.938 8.938s-8.938-4-8.938-8.938c0-1.375.313-2.625.875-3.75H1.873V24.5c0 3.063 2.563 5.625 5.625 5.625h17c3.063 0 5.625-2.563 5.625-5.625zm-7.062-7.562c0-3.875-3.188-7.063-7.063-7.063s-7.063 3.188-7.063 7.063 3.188 7.063 7.063 7.063 7.063-3.188 7.063-7.063zm-.188-5.625h7.25V7.5c0-3.063-2.563-5.625-5.625-5.625h-17c-3.063 0-5.625 2.563-5.625 5.625v3.813h7.25C10.75 9.313 13.25 8 16 8s5.25 1.313 6.875 3.313zm4.313-6.188c0-.563-.438-1-1-1h-2.563c-.563 0-1.063.438-1.063 1v2.438c0 .563.5 1 1.063 1h2.563c.563 0 1-.438 1-1V5.125z',
	    'google' => 'M32 4.938h-4.938V0h-2.438v4.938h-4.938v2.438h4.938v4.938h2.438V7.376H32V4.938zM19.563 24.063c0-5.375-5.75-6.375-5.75-8.875s4.313-2.875 4.313-8c0-2.125-1-4.5-2.875-5.688h2.563L20.439 0h-8.438c-1.188 0-2.375.125-3.563.375-3.5.75-6.313 3.875-6.313 7.563 0 3.875 3.188 6.625 6.938 6.625.438 0 .875-.063 1.313-.125-.188.625-.375 1-.375 1.688 0 1.063.563 2 1.188 2.813-3.438.125-8.75 1-10.5 4.438-.375.813-.688 1.75-.688 2.625 0 4.438 5.188 6 8.813 6 2.813 0 5.813-.625 8.063-2.5 1.625-1.438 2.688-3.25 2.688-5.438zm-5-14.938c0 2.375-.938 4.25-3.563 4.25-3.438 0-5.313-4.563-5.313-7.5 0-2.25 1.188-4.5 3.688-4.5 3.563 0 5.188 4.813 5.188 7.75zm2.312 16.563c0 3.375-3.25 4.563-6.063 4.563-3.125 0-7.25-1.438-7.25-5.125 0-4 4.688-5 7.813-5h1c1.938 1.375 4.5 2.875 4.5 5.563z',
	    'github' => 'M24.625 20.938c0-1.438-.75-3.688-2.5-3.688-1.688 0-2.438 2.25-2.438 3.688 0 1.375.75 3.688 2.438 3.688 1.75 0 2.5-2.313 2.5-3.688zM9.875 17.25c1.688 0 2.438 2.25 2.438 3.688 0 1.375-.75 3.688-2.438 3.688-1.75 0-2.5-2.313-2.5-3.688 0-1.438.75-3.688 2.5-3.688zM32 17.563c0-2.813-.75-5.5-2.625-7.688.375-1 .5-2.125.5-3.25 0-1.438-.313-2.875-.938-4.188-3 0-4.938 1.313-7.25 3.125-1.75-.438-3.563-.625-5.375-.625-2 0-4 .188-5.938.688-2.313-1.813-4.25-3.188-7.313-3.188-.625 1.313-.938 2.75-.938 4.188 0 1.125.125 2.25.5 3.313-1.875 2.125-2.625 4.813-2.625 7.625 0 2.125.188 4.375 1.188 6.313 2.625 5.25 10.063 5.688 15.125 5.688 5 0 12-.5 14.5-5.688 1-1.938 1.188-4.188 1.188-6.313zm-4.312 3.375c0 5.875-5.375 6.75-10.063 6.75h-3.25c-4.688 0-10.063-.875-10.063-6.75 0-2.938 1.813-5.563 4.938-5.563 1.25 0 2.5.25 3.75.438 1 .125 2 .188 3 .188s2-.063 3-.188c1.313-.188 2.5-.438 3.75-.438 3.125 0 4.938 2.625 4.938 5.563z',
	    'flickr' => 'M13.75 16c0-3.813-3.125-6.875-6.875-6.875C3.062 9.125 0 12.188 0 16s3.063 6.875 6.875 6.875c3.75 0 6.875-3.063 6.875-6.875zM32 16c0-3.813-3.063-6.875-6.875-6.875-3.75 0-6.875 3.063-6.875 6.875s3.125 6.875 6.875 6.875C28.938 22.875 32 19.812 32 16zm-1.875 0c0 2.75-2.25 5-5 5s-5-2.25-5-5 2.25-5 5-5 5 2.25 5 5z',
	    'facebook' => 'M23.438 10.5h-5V7.75c0-1.438.188-2.25 2.25-2.25h2.75V0H19c-5.313 0-7.125 2.688-7.125 7.188v3.313H8.562v5.5h3.313v16h6.563v-16h4.438z',
	    'dropbox' => 'M31.75 8.25l-5.875 4.625 5.875 4.688-6.438 4.188v2.938l-9.313 5.5-9.25-5.5v-2.875l-6.5-4.25 5.875-4.688L.249 8.251l10-6.5 5.75 4.75 5.75-4.75zm-9.875-4.187l-4.25 3.563 6.688 4.125 4.188-3.375zm.688 8.812L16 8.812l-6.563 4.063L16 16.938zM3.5 8.375l4.188 3.375 6.688-4.125-4.25-3.563zm0 9l6.625 4.375 4.25-3.563-6.688-4.125zm19.938 6.25V23l-1.688 1.063-5.75-4.75-5.75 4.75L8.625 23v.625L16 28zm5.062-6.25l-4.188-3.313-6.688 4.125 4.25 3.563z',
	    'dribbble' => 'M16 0c8.813 0 16 7.188 16 16s-7.188 16-16 16S0 24.812 0 16 7.188 0 16 0zm14.125 16.25V16c0-3.438-1.25-6.625-3.375-9.125-2.313 2.563-5.375 4.313-8.563 5.563.625 1.25 1.125 2.438 1.625 3.625 2.938-.625 6.375-.688 10.313.188zM25.438 5.563C22.938 3.25 19.625 1.875 16 1.875c-1.375 0-2.688.188-3.938.563 2.125 2.688 3.875 5.5 5.313 8.25 3-1.125 5.875-2.75 8.063-5.125zM10.25 3.125C6.125 5 3.062 8.75 2.125 13.25c2.188 0 7.813-.188 13.438-1.938-1.438-2.75-3.188-5.563-5.313-8.188zM1.875 16c0 3.688 1.438 7.063 3.813 9.625 1.438-2.125 5.5-7 12.25-9.125-.438-1.125-.938-2.25-1.5-3.438-5.813 1.875-11.688 2.125-14.125 2.125-.125 0-.25 0-.375-.063 0 .313-.063.563-.063.875zm5.188 10.938c2.438 2 5.563 3.188 8.938 3.188 2 0 3.875-.438 5.563-1.188-.25-1.688-1.125-5.75-2.938-10.625-6.625 2-10.438 6.938-11.563 8.625zm16.25 1.125c3.5-2.125 6-5.75 6.625-9.938-3.563-.813-6.688-.813-9.438-.25 1.625 4.438 2.438 8.188 2.813 10.188z',
	    'apple' => 'M26.375 20.938c.875 1.25 1.875 2.063 3 2.438-.438 1.5-1.25 3.125-2.375 4.813-1.625 2.5-3.25 3.75-4.938 3.75-.625 0-1.5-.188-2.688-.625-1.125-.438-2.125-.625-2.875-.625s-1.688.25-2.75.688-1.875.625-2.5.625c-2 0-3.938-1.688-5.813-5s-2.813-6.5-2.813-9.625c0-3 .688-5.375 2.125-7.25 1.5-1.813 3.25-2.75 5.5-2.75.938 0 2.063.188 3.375.563 1.375.438 2.25.625 2.688.625.563 0 1.438-.25 2.75-.688 1.25-.438 2.375-.625 3.313-.625 1.563 0 2.875.375 4.125 1.25.625.438 1.313 1.125 2 1.875-1 .875-1.75 1.625-2.25 2.313-.813 1.188-1.25 2.5-1.25 3.938 0 1.625.5 3.063 1.375 4.313zm-.937 6.187c.625-.938 1.188-1.875 1.563-2.813-.813-.563-1.5-1.313-2.188-2.313-1.125-1.563-1.688-3.375-1.688-5.375 0-1.813.563-3.5 1.625-5 .25-.438.625-.875 1.063-1.313-.125-.125-.313-.188-.438-.25-.875-.625-1.875-.938-3-.938-.688 0-1.625.188-2.75.563-1.438.5-2.5.75-3.313.75-.5 0-1.188-.125-3.188-.688-1.188-.313-2.125-.5-2.875-.5-1.625 0-2.875.688-4 2.063-1.188 1.563-1.75 3.5-1.75 6.063 0 2.75.813 5.625 2.563 8.75 1.5 2.563 3 4 4.188 4 .125 0 .688-.063 1.75-.5 1.313-.563 2.5-.813 3.5-.813 1.063 0 2.25.25 3.563.75 1.188.438 1.75.5 2 .5.938 0 2.125-1.063 3.375-2.938zM17.75 7.438c.688-.188 1.375-.688 2.063-1.375.813-.813 1.438-1.688 1.813-2.625s.563-1.813.563-2.625c0-.125-.063-.25-.063-.375s-.063-.25-.063-.438c-2.25.5-3.875 1.438-4.813 2.875-1 1.375-1.5 3-1.5 4.938.875-.125 1.563-.188 2-.375z',
	    'android' => 'M7.188 10.75v12.813c0 1.125.938 2.063 2.125 2.063h1.375l.063 4.375c0 1.125.875 2 1.938 2 1.125 0 2-.875 2-2v-4.375h2.625v4.375c0 1.125.875 2 2 2s2-.875 2-2v-4.375h1.438c1.125 0 2.063-.938 2.063-2.063V10.75H7.19zm-2.75-.375c1.063 0 1.938.875 1.938 1.938v8.25c0 1.125-.813 2-1.938 2s-2-.875-2-2v-8.25c0-1.063.875-1.938 2-1.938zM24.875 10c0-3-1.813-5.688-4.5-7.063l1.375-2.5c.063-.188 0-.313-.125-.438-.125-.063-.313 0-.375.125l-1.375 2.563c-1.188-.5-2.5-.813-3.875-.813s-2.688.313-3.875.813L10.75.124c-.063-.125-.25-.188-.375-.125-.125.125-.188.25-.125.438l1.375 2.5C8.937 4.312 7.062 7 7.062 10h17.813zM12.688 6.063c0 .438-.313.75-.75.75-.375 0-.75-.313-.75-.75 0-.375.375-.75.75-.75.438 0 .75.375.75.75zm8.125 0c0 .438-.375.75-.75.75-.438 0-.75-.313-.75-.75 0-.375.313-.75.75-.75.375 0 .75.375.75.75zm6.75 4.312c1.125 0 2 .875 2 1.938v8.25c0 1.125-.875 2-2 2-1.063 0-1.938-.875-1.938-2v-8.25c0-1.063.875-1.938 1.938-1.938z',
	    'save' => 'M26.688 0l5.313 5.25v23.938c0 1.563-1.25 2.813-2.813 2.813H2.813C1.25 32.001 0 30.751 0 29.188V2.813C0 1.25 1.25 0 2.813 0h23.875zM15.063 1.875H7.5v9.438h15.063V1.875h-1.875v7.563h-5.625V1.875zm-9.438 28.25h20.75V18.812H5.625v11.313zm24.5-.937V6l-4.25-4.125H24.5v11.313H5.625V1.875H2.812c-.5 0-.938.438-.938.938v26.375c0 .5.438.938.938.938h.938V16.938h24.5v13.188h.938c.5 0 .938-.438.938-.938z',
	    'save-alt' => 'M29.188 0c1.563 0 2.813 1.25 2.813 2.813v26.375c0 1.563-1.25 2.813-2.813 2.813H2.813C1.25 32.001 0 30.751 0 29.188V5.25L5.313 0h23.875zM24.5 1.875H9.437v3.75H24.5v-3.75zM5.625 30.125h20.75V28.25H5.625v1.875zm24.5-.937V2.813c0-.5-.438-.938-.938-.938h-2.813V7.5H7.499V1.875H6.124L1.874 6v23.188c0 .5.438.938.938.938h.938v-3.75h24.5v3.75h.938c.5 0 .938-.438.938-.938zM16 9.438c3.625 0 6.563 2.938 6.563 6.563S19.625 22.564 16 22.564s-6.563-2.938-6.563-6.563S12.375 9.438 16 9.438zm0 11.25c2.625 0 4.688-2.063 4.688-4.688S18.625 11.312 16 11.312 11.312 13.375 11.312 16s2.063 4.688 4.688 4.688z',
	    'yahoo' => 'M17.875 31.063l-.25-12.813c2.125-3.688 4.25-7.375 6.438-11 1.25-2.125 2.438-4.313 3.875-6.313-.688.188-1.375.25-2.063.25s-1.313-.063-1.938-.25c-2.438 4.5-5.25 8.875-7.938 13.25-2.688-4.375-5.438-8.75-7.938-13.25-.688.125-1.375.25-2.063.25-.625 0-1.313-.063-1.938-.25 3.75 5.625 6.875 11.5 10.25 17.313l-.25 12.813c.625-.125 1.313-.188 1.938-.188s1.25.063 1.875.188z',
	    'wordpress' => 'M31.063 16C31.063 7.687 24.313.937 16 .937S.937 7.687.937 16 7.687 31.063 16 31.063 31.063 24.313 31.063 16zm-.688 0c0 7.938-6.438 14.375-14.375 14.375S1.625 23.937 1.625 16 8.063 1.625 16 1.625 30.375 8.063 30.375 16zM4.188 10.75C3.5 12.375 3.063 14.125 3.063 16c0 5.125 3 9.5 7.313 11.625zM23.75 19.5c.5-1.75 1-3.063 1-4.125 0-1.625-.563-2.75-1.063-3.563-.688-1.125-1.313-2-1.313-3.063 0-1.188.938-2.25 2.188-2.25h.188C22.437 4.374 19.375 3.061 16 3.061c-4.5 0-8.5 2.313-10.813 5.875h.875s1.313 0 3.438-.188c.688-.063.75 1 .063 1.063s-1.5.125-1.5.125l4.75 14 2.813-8.5-2-5.5-1.375-.125s-.625-1.125.063-1.063c2.188.188 3.438.188 3.438.188s1.313 0 3.438-.188c.688-.063.75 1 .063 1.063s-1.5.125-1.5.125l4.688 13.875zM20.188 28l-4-10.875-3.813 11.25c1.125.375 2.375.563 3.625.563 1.5 0 2.938-.25 4.313-.75-.063-.063-.125-.125-.125-.188zm8.75-12c0-2.25-.625-4.375-1.625-6.188.063.375.125.813.125 1.313 0 1.313-.375 2.75-1 4.625L22.5 27.188c3.813-2.25 6.438-6.438 6.438-11.188z',
	    'vimeo-alt' => 'M30.375 4.313c.75 1 .813 2.313.563 3.563-.375 1.813-2.625 8.188-6.813 13.813-1.75 2.375-3.938 4.688-6.625 6.313-1 .563-3 1.313-4.313.75-2.625-1.063-3.5-5.563-4.25-8.563-.438-1.75-.875-3.438-1.438-4.938-.375-1.188-.563-2.375-1.188-3.438-1.063-1.75-2.563-.063-4.125-.25-.688-.125-.375-.813-1.25-1.25v-.188c2.563-1.813 4.313-4 6.875-5.5.875-.5 2.25-1 3.438-.688 1 .313 1.875 1.75 2.25 2.875.438 1.375.688 3.063.938 4.375.375 2.375.25 5.938 2 7.813 1.938 2.063 3.375-.813 4.188-2.25.688-1.313 1.25-2.625 1.375-3.813.25-2.875-1.125-3.25-3.75-3.063 1.5-4.625 5.875-6.5 7.125-6.75 1.625-.25 3.875-.188 5 1.188z',
	    'tumblr-alt' => 'M17.125.938h-4.313c-.188 1.563-.5 2.813-1 3.875-.563 1-1.188 1.813-2.063 2.563-.813.688-1.875 1.25-3 1.625v4.25h3.313v10.625c0 1.313.125 2.375.438 3.125.25.75.813 1.438 1.563 2.063.688.625 1.625 1.125 2.688 1.438 1.063.375 2.25.563 3.625.563 1.25 0 2.375-.125 3.438-.375 1-.25 2.188-.688 3.438-1.25v-4.75c-1.5 1-3 1.5-4.5 1.5-.875 0-1.625-.25-2.313-.625-.5-.313-.875-.688-1-1.188-.25-.5-.313-1.625-.313-3.375v-7.75h7.125V8.564h-7.125V.939z',
	    'trello' => 'M31.063 29.813V2.188c0-.688-.563-1.25-1.25-1.25H2.188c-.688 0-1.25.563-1.25 1.25v27.625c0 .688.563 1.25 1.25 1.25h27.625c.688 0 1.25-.563 1.25-1.25zM14.75 4.688v20.125c0 .313-.25.625-.625.625H4.687c-.313 0-.625-.313-.625-.625V4.688c0-.313.313-.625.625-.625h9.438c.375 0 .625.313.625.625zm13.188 0v12.563c0 .375-.313.625-.625.625h-9.438c-.375 0-.625-.25-.625-.625V4.688c0-.313.25-.625.625-.625h9.438c.313 0 .625.313.625.625z',
	    'stack-overflow' => 'M23.813 30.438v-11.75h-2v10.375H6.25V18.688H4.187v12.375h19.625v-.625zm-4-3.438v-2.5H7.875v2.563zm.25-5.75L8.25 20.125 8 22.688l11.875 1.063zm.812-3.312l-11.5-3.125-.625 2.5 11.438 3.063zm1.5-2.938l-10.25-6-1.313 2.188 10.25 6zm2.5-1.75l-6.688-9.813-2.125 1.438 6.688 9.813zm2.938-.562L25.75.938l-2.5.438 2.063 11.688z',
	    'soundcloud' => 'M1.688 19.063l-.313-1.688c0-.063 0-.063-.125-.063-.063 0-.063 0-.063.063l-.25 1.688.25 1.688c0 .063 0 .063.125.063.063 0 .063 0 .063-.063zm1.187 0L2.5 16.375c0-.063-.063-.125-.125-.125s-.125.063-.125.125L2 19.063l.25 2.625c0 .125.063.125.125.125s.125 0 .125-.063zm1.188 0l-.313-3.188c0-.125-.063-.188-.188-.188-.063 0-.125.063-.125.188l-.313 3.188.313 3.125c0 .063.063.125.125.125.125 0 .188-.063.188-.125zm1.187 0l-.313-3.313c0-.063-.063-.125-.188-.125-.063 0-.125.063-.125.125l-.313 3.313.313 3.188c0 .125.063.188.125.188.125 0 .188-.063.188-.188zm1.188 0L6.188 16c0-.063-.125-.188-.188-.188-.125 0-.25.125-.25.188l-.25 3.063.25 3.25c0 .063.125.188.25.188.063 0 .188-.125.188-.188zm1.25 0l-.25-4.938c0-.125-.125-.25-.25-.25s-.25.125-.25.25l-.25 4.938.25 3.25c0 .125.125.188.25.188s.25-.063.25-.188zm1.187.062L8.625 13c0-.188-.125-.25-.25-.25s-.25.063-.25.25l-.188 6.125.188 3.188c0 .125.125.25.25.25s.25-.125.25-.25zm1.313-.062l-.25-6.625c0-.125-.125-.25-.313-.25-.125 0-.25.125-.25.25l-.25 6.625.25 3.188c0 .125.125.25.25.25.188 0 .313-.125.313-.25zm1.187 0l-.188 3.188c0 .125-.125.25-.313.25-.125 0-.313-.125-.313-.25l-.188-3.188.188-6.813c0-.188.188-.313.313-.313.188 0 .313.125.313.313zm1.25 0l-.188-6.688c0-.125-.125-.313-.313-.313s-.313.188-.313.313l-.188 6.688.188 3.125c0 .188.125.313.313.313s.313-.125.313-.313zm1.313 0l-.188-6.438c0-.188-.125-.313-.375-.313-.188 0-.313.125-.313.313l-.188 6.438.188 3.125c0 .188.125.313.313.313.25 0 .375-.125.375-.313zm1.25 0l-.125 2.75v.313c0 .125-.063.25-.125.313s-.188.125-.25.125c-.125 0-.25-.063-.313-.188-.063-.063-.063-.125-.063-.188v-.063l-.188-3.063.125-7.563.063-.063c0-.125.063-.25.125-.313s.125-.063.25-.063c.063 0 .125 0 .188.063.125.063.188.188.188.313zm1.125 3.062l.188-3.063-.188-8.313c0-.188-.063-.313-.188-.375-.063 0-.125-.063-.188-.063-.125 0-.188.063-.25.125-.125.063-.188.188-.188.313l-.125 8.313.063 1.563.063 1.5c.063.188.188.375.438.375s.375-.188.375-.375zm11.062.375c2 0 3.688-1.625 3.688-3.688 0-2-1.688-3.688-3.688-3.688-.5 0-1 .125-1.438.313-.313-3.375-3.125-6-6.5-6-.875 0-1.688.188-2.375.5-.313.063-.375.188-.375.375v11.75c0 .25.188.438.375.438h10.313z',
	    'sharethis' => 'M31.063 24.813c0-3.5-2.813-6.313-6.25-6.313-1.688 0-3.188.688-4.313 1.688l-7.063-3.5c.063-.25.063-.5.063-.688s0-.438-.063-.688l7.063-3.5c1.125 1.063 2.625 1.688 4.313 1.688 3.438 0 6.25-2.813 6.25-6.25 0-3.5-2.813-6.313-6.25-6.313-3.5 0-6.313 2.813-6.313 6.313 0 .188 0 .438.063.625L11.5 11.438C10.375 10.375 8.875 9.75 7.187 9.75 3.749 9.75.937 12.5.937 16s2.813 6.25 6.25 6.25c1.688 0 3.188-.625 4.313-1.688l7.063 3.563c-.063.188-.063.438-.063.688 0 3.438 2.813 6.25 6.313 6.25 3.438 0 6.25-2.813 6.25-6.25z',
	    'sharethis-alt' => 'M31.063 25.438V6.563C31.063 3.5 28.5.938 25.438.938H6.563C3.5.938.938 3.501.938 6.563v18.875c0 3.063 2.563 5.625 5.625 5.625h18.875c3.063 0 5.625-2.563 5.625-5.625zm-9.188-7.75c2.25 0 4.188 1.875 4.188 4.188 0 2.25-1.938 4.188-4.188 4.188-2.313 0-4.188-1.938-4.188-4.188v-.438l-4.688-2.375c-.75.688-1.75 1.125-2.875 1.125-2.25 0-4.188-1.875-4.188-4.188s1.938-4.188 4.188-4.188c1.125 0 2.125.438 2.875 1.125l4.688-2.375v-.438c0-2.25 1.875-4.188 4.188-4.188 2.25 0 4.188 1.938 4.188 4.188 0 2.313-1.938 4.188-4.188 4.188-1.125 0-2.125-.438-2.875-1.125l-4.688 2.375v.875L19 18.812c.75-.688 1.75-1.125 2.875-1.125z',
	    'reddit' => 'M29.313 18.688c1.063-.563 1.75-1.688 1.75-2.938 0-1.938-1.563-3.438-3.438-3.438-.875 0-1.688.313-2.313.875-2.313-1.5-5.25-2.375-8.5-2.563l1.813-5.5 4.75 1.125c0 1.5 1.25 2.813 2.813 2.813s2.813-1.313 2.813-2.875-1.25-2.813-2.813-2.813c-1.125 0-2.125.688-2.563 1.688l-5.313-1.25c-.25-.063-.563.125-.688.438l-2 6.375c-3.375.063-6.563.938-9 2.5-.625-.5-1.375-.813-2.25-.813-1.875 0-3.438 1.5-3.438 3.438 0 1.188.688 2.25 1.625 2.875-.063.313-.063.688-.063 1 0 2.438 1.375 4.75 4 6.438 2.563 1.688 5.875 2.563 9.438 2.563s6.875-.875 9.438-2.563 4-4 4-6.438c0-.313 0-.625-.063-.938zm-26.438-1.25c-.438-.438-.75-1.063-.75-1.688 0-1.25 1-2.313 2.25-2.313.438 0 .875.188 1.25.375-1.313 1.063-2.25 2.313-2.75 3.625zm25.375 2.187c0 2.063-1.25 4-3.5 5.438-2.375 1.563-5.5 2.375-8.813 2.375s-6.438-.813-8.813-2.375c-2.25-1.438-3.5-3.375-3.5-5.438s1.25-4 3.5-5.438c2.375-1.5 5.5-2.375 8.813-2.375s6.438.875 8.813 2.375c2.25 1.438 3.5 3.438 3.5 5.438zm-16.75.438c1.125 0 2.063-.938 2.063-2.063s-.938-2.125-2.063-2.125c-1.188 0-2.125 1-2.125 2.125s.938 2.063 2.125 2.063zm9.375 3c-.25-.188-.625-.188-.813 0-.813.813-2.125 1.188-4.063 1.188-1.938 0-3.25-.375-4.063-1.188-.188-.188-.563-.188-.813 0-.188.25-.188.625 0 .875 1.063 1 2.625 1.5 4.875 1.5s3.813-.5 4.875-1.5c.188-.25.188-.625 0-.875zM22.625 18c0-1.125-.938-2.125-2.063-2.125s-2.125 1-2.125 2.125 1 2.063 2.125 2.063 2.063-.938 2.063-2.063zm1.938-11.812c0-.875.75-1.625 1.625-1.625.938 0 1.688.75 1.688 1.625 0 .938-.75 1.688-1.688 1.688-.875 0-1.625-.75-1.625-1.688zm5.312 9.562c0 .688-.313 1.313-.875 1.75-.438-1.313-1.375-2.563-2.688-3.625.375-.25.813-.438 1.313-.438 1.25 0 2.25 1.063 2.25 2.313z',
	    'pinterest-alt' => 'M16 .938c8.313 0 15.063 6.75 15.063 15.063S24.313 31.064 16 31.064c-1.5 0-2.938-.25-4.25-.625.563-.875 1.188-2.063 1.5-3.25.188-.625 1.063-4.125 1.063-4.125.5 1 2.063 1.875 3.688 1.875 4.813 0 8.125-4.375 8.125-10.313 0-4.438-3.813-8.625-9.563-8.625-7.125 0-10.75 5.125-10.75 9.438 0 2.563 1 4.875 3.063 5.75.375.125.688 0 .75-.375.125-.313.25-.938.313-1.25.125-.375.063-.5-.188-.813-.625-.75-1-1.625-1-2.938 0-3.813 2.875-7.25 7.438-7.25 4 0 6.25 2.5 6.25 5.813 0 4.313-1.938 8-4.75 8-1.625 0-2.813-1.313-2.438-2.938.5-1.875 1.375-3.938 1.375-5.313 0-1.25-.688-2.25-2.063-2.25-1.625 0-2.875 1.625-2.875 3.875 0 1.438.438 2.375.438 2.375s-1.625 7-1.938 8.188c-.25 1.188-.25 2.438-.25 3.5-5.313-2.375-9-7.625-9-13.813C.938 7.687 7.688.937 16.001.937z',
	    'microsoft-alt' => 'M0 4.375V15.25h13.125V2.625zm0 23.25v-10.75h13.125v12.5zm14.563-25.25L32.001 0v15.25H14.563V2.375zm0 27.25v-12.75h17.438V32z',
	    'linux' => 'M26.063 28.688c1.25-.625 4.063-1.688 2-2.938-.438-.313-1.625-.625-1.688-2.813-.438.375-.375 2.438.813 2.813 1.313.438 2.188 1.25-.313 2.063-1.688.563-1.938.75-3.25 1.875-1.313 1.063-3.313.625-2.938-1.688.125-1.188.25-2.188-.063-3.25-.125-.5-.188-1.188-.125-1.625.188-.938.688-1.188 1.188-.313.313.5.375 1.188 1.5 1.25 1.688.063 2-1.688 2.5-1.75.375-.063.75-1.063.5-2.75-.313-1.75-1.375-4.5-2.688-5.938-1.125-1.125-1.813-2.188-2.25-3.625-.375-1.25-.563-2.438-.5-3.625.125-1.438-.688-3.563-2-4.5-.875-.625-2.125-.938-3.313-.938-.625 0-1.25.125-1.75.375-1.938 1.063-2.188 2.563-2.188 4.313.063 1.563.125 3.438.313 5.188-.25.813-1.375 2.313-2.125 3.25-1 1-1.438 2.813-2.125 4.5-.313.813-.875 1.25-.938 2.375 0 .313 0 1.125.313.875 1.125-.875 2.563 1.313 4.75 4.75.375.625 1.875 3.375-.688 3.75-.875.063-2.25-.5-3.563-.875-1.188-.25-2.438-.438-3.125-.625-.375-.125-.563-.25-.625-.438-.063-.438.5-1.125.563-1.625 0-.563-.188-.813-.375-1.25s-.25-.813-.125-1c.125-.125.375-.188.75-.125.5 0 1.063-.063 1.375-.25.563-.375.813-1 .563-1.813 0 .813-.25 1.063-.938 1.438-.563.375-1.5.063-1.938.438-.5.438.188 1.625.125 2.5-.063.625-.688 1.375-.438 2 .313.688 1.75.75 3.25 1.063 2.125.438 3.313 1.188 4.313 1.25 1.438 0 1.625-1.375 3.875-1.438.625-.063 1.25-.063 1.938-.063h2.188c1.438.063.938.813 1.938 1.313.813.438 2.25.25 2.625-.063.438-.5 1.75-1.563 2.688-2.063zm-2.813-8.125c.25.125.938.438.938.75-.688-.563-2.75-.688-2.813.688-.375 0-.625 0-.875.313-.813.938-.063 2.938-.125 4-.063.938-.375 1.875-.5 2.813-.5 0-.438-.375-.313-.875.188-.438.375-1 .375-1.563.063-.5 0-.813-.125-.875s-.313.063-.563.5c-.625.938-1.813 1.375-3 1.5-1.125.125-2.188 0-2.813-.625-.188-.188-.5.063-.5.125-.063.063.125.25.313.563.313.5.563 1.188-.063 1.563 0-1.688-.563-1.813-1.125-2.875 1.125-.063 1.25-1.25.75-1.75-.438-.375-2.75-2.125-3.313-2.75-.313-.313-.688-.5-.875-.813-.313-.813-.563-2-.125-2.813.063-.125.125-.063.063.188-.375 1.813.813 3.25 1.063 2.5.188-.5 0-1.438.063-2.125.188-1.313 1.375-3.75 1.875-3.938-.813-1.438.938-2.563.938-3.875-.063-.875.688 1 1.438 1.438.875.438 1.813-.875 3.125-1.5.375-.188.813-.375.813-.563-.188-.75-1.75.938-3.125 1-.688 0-.875-.125-1.125-.375-.75-.688.063-.125 1.188-.313.438-.063.625-.188 1.125-.375.563-.188 1.125-.5 1.75-.688.438-.125.375-.438.188-.5-.063-.063-.188-.063-.313.125-.25.438-1.438.688-1.813.813-.5.125-1 .25-1.688.25-1.125-.063-.875-.563-1.625-1-.188-.125-.125-.438.125-.75.188-.125.625-.25.813-.625.063 0 .313-.313.5-.438.063-.063.063-1.375-.563-1.375-.563-.063-.75.375-.75.813.063.438.313.813.438.813.313 0 0 .313-.125.375-.25.063-.625-1-.563-1.5s.313-1.438 1-1.438c.563 0 1 .75 1 2.063 0 .25 1-.063 1.313.25.25.25-.813-2.313 1.5-2.5.625.125 1.188.313 1.438 1.75-.063.125.188 1.125-.188 1.25-.5.125-.75-.063-.5-.5.188-.438 0-1.5-.938-1.438s-.813 1.688-.563 1.75c.313 0 .938.5 1.375.563 1.438.25.375 1.125.563 2.125.25 1.188 1 .875 1.688 3.938.125.188.688.313 1.25 2.688.5 2.125-.188 3.625 1 3.5.25 0 .625-.063.813-.688.438-1.563-.25-3.438-.938-4.688-.375-.75-.75-1.25-.938-1.375.813.438 1.75 1.875 2 3 .313 1.438.5 2 .063 3.5zM9.5 15.75c.188-.25.125-.563.313-.5.125.063.063.188-.063.5-.063.25-.313.438-.375.438-.25-.063.063-.25.125-.438zm3.875-9.125c.125.063.313.375.25.75 0 .063-.063.063-.063.063-.125 0-.188-.125-.125-.313 0-.188-.063-.25-.125-.25-.125 0-.125-.313.063-.25zm.438 1.563c.188 0 .063-.313.438-.313-.563-.063-.563.313-.438.313zm1.375-.313c.313-.063.313.25.5.188s0-.375-.5-.188zm2.062-1.312c.063-.063.438.188.438.563 0 .063-.188.125-.188.063-.063-.25-.188-.438-.313-.5s-.188-.125.063-.125zm1-3.625c.125.063.313.188.313.25-.063.188-.438.125-.563.188-.313.125-.375.438-.563.313s.063-.313.188-.5c0-.125-.125-.5.188-.563.125 0 .25.125.438.313zm1.813 7.375c.313.188.5.063.625.375 0 .25-.125.5-.313.5-.375-.063-1.125-.875-.813-1.25.125-.125.188.188.5.375z',
	    'jsfiddle' => 'M31.063 20.438c0-2.438-1.5-4.5-3.625-5.375V14.5c0-4.813-4-8.813-8.938-8.813-3.625 0-6.688 2.063-8.125 5.063-.688-.563-1.563-.875-2.5-.875-2.313 0-4.125 1.813-4.125 4.063 0 .438.063.813.188 1.25-1.813 1-3 2.938-3 5.125 0 3.25 2.688 5.75 6 5.938h17.875c.125 0 .188.063.313.063 3.25 0 5.938-2.625 5.938-5.875zm-18.938 2.437c-2.375 0-4.313-1.438-4.313-3.875s2-3.875 4.313-3.875c4.563 0 5.438 5.688 8.563 5.688 1.063 0 1.938-.75 1.938-1.875 0-1-1-1.688-1.938-1.688-.875 0-1.5.313-2.125.938-.438-.563-.875-1.125-1.375-1.625 1.063-1 2.125-1.438 3.563-1.438 2.313 0 4.313 1.438 4.313 3.875s-2 3.875-4.25 3.875c-4.75 0-5.438-5.625-8.625-5.625-1.063 0-1.938.688-1.938 1.75s.875 1.75 1.938 1.75c.875 0 1.5-.313 2.125-.938.438.563.938 1.063 1.313 1.563-1 1-2.063 1.5-3.5 1.5z',
	    'joomla' => 'M18.813 22.625l3.125-3.125-3-3-3.125 3.125-2.938 3-.625.563c-.938.938-2.5.938-3.5 0-.938-1-.938-2.563 0-3.5L9 19.5l-3-3-.188.25c-1.75 1.688-2.313 4.125-1.75 6.375C2.249 23.5.937 25.125.937 27c0 2.25 1.813 4.063 4 4.063 1.938 0 3.563-1.313 3.938-3.125 2.25.563 4.625-.063 6.375-1.75l.563-.625zM15.5 6.313l-.25-.188C13.5 4.437 11.187 3.812 9 4.312 8.687 2.437 7 .937 5 .937 2.812.937 1 2.75 1 5c0 1.875 1.313 3.5 3.125 3.875-.688 2.313-.125 4.875 1.688 6.688l.563.563 2.938 3 3.188 3.125 2.938-3-6.688-6.688c-.938-.938-.938-2.5 0-3.5 1-.938 2.563-.938 3.5 0l.25.25zM27.5 9c2-.313 3.5-2 3.5-4 0-2.25-1.813-4.063-4-4.063-2.063 0-3.75 1.5-4 3.5-2.25-.688-4.813-.125-6.625 1.688l-6.688 6.688 3 3 6.688-6.75c.938-.938 2.5-.938 3.5 0 .938 1 .938 2.563 0 3.5l-.25.25 2.938 3 .25-.25C27.626 13.75 28.188 11.25 27.501 9zm-.437 22.063c2.188 0 4-1.813 4-4.063 0-2-1.5-3.688-3.5-3.938.563-2.25-.063-4.625-1.75-6.313l-.563-.625-6.125-6.125-3 3 6.125 6.125.625.563c.938 1 .938 2.563 0 3.5-1 .938-2.563.938-3.5 0l-.25-.25-2.938 3 .188.25c1.813 1.813 4.438 2.313 6.688 1.625.375 1.875 2 3.25 4 3.25z',
	    'html5' => 'M29.25.938H2.75l2.438 27.063 10.75 3.063 10.875-3.063zM24.313 6.5L24 9.75H11.312l.313 3.438H23.75l-.938 10.25-6.75 1.813v.063h-.125l-6.813-1.875-.375-5.25h3.25l.25 2.625 3.688 1 3.75-1 .375-4.313h-11.5l-.875-10h16.625z',
	    'flickr-alt' => 'M16 .938c8.313 0 15.063 6.75 15.063 15.063S24.313 31.064 16 31.064.937 24.314.937 16.001 7.687.938 16 .938zm-5.75 19.75c2.563 0 4.688-2.125 4.688-4.75s-2.063-4.75-4.688-4.75-4.75 2.125-4.75 4.75 2.125 4.75 4.75 4.75zm11.875 0c2.625 0 4.75-2.125 4.75-4.75s-2.125-4.75-4.75-4.75-4.75 2.125-4.75 4.75 2.125 4.75 4.75 4.75z',
	    'email' => 'M0 3.75h32v24.5H0V3.75zM16 18.5L29 5.625H3zM10.813 16L1.875 7.187v17.625zm1.375 1.375l-9.125 9h25.688l-9-8.938-3.75 3.688zm8.875-1.25L30.126 25V7.187z',
	    'drupal' => 'M16.125 31.063c7 0 13.063-5.063 13.063-12.75S23.5 7.125 22.563 6.563c-1.563-1-3-1.375-4.438-2.313-.938-.625-2.188-2.063-3.188-3.313-.188 2-.813 2.813-1.5 3.375-1.5 1.188-2.438 1.563-3.688 2.25-1.063.563-6.938 4-6.938 11.5s6.313 13 13.313 13zm10.313-12.438c1.438 0 1.813 1.5 1.813 2.438 0 .875-.25 2.5-.938 3.5-.75 1.063-1.188 1.438-2 1.375-1-.063-3.125-3.375-4.438-3.438-1.688-.063-5.313 3.5-8.25 3.5-1.688 0-2.25-.188-2.813-.625-.875-.563-1.313-1.5-1.25-2.813 0-2.25 2.125-4.375 4.813-4.375 3.375-.063 5.75 3.375 7.438 3.313 1.438 0 4.25-2.875 5.625-2.875zm-4 9.125c.25-.188.375-.063.375.063.063.125.125.313-.063.5-.188.125-1.5 1.063-3.063 1.25-1.563.125-3.688.25-5-.938-.188-.188-.125-.5 0-.625.188-.125.313-.188.5-.188.125 0 .125 0 .188.063.563.438 1.438.813 3.313.813s3.188-.5 3.75-.938zm-.938-2.937c.375.25.563.75.688 1.063.125.25 0 .438-.25.563-.188.125-.25.063-.438-.313s-.375-.75-1.375-.75-1.375.375-1.813.75c-.5.375-.688.563-.875.313s-.125-.438.188-.75c.375-.313.875-.75 1.375-.938.5-.25.75-.188 1.188-.188.5 0 1 .063 1.313.25z',
	    'dropbox-alt' => 'M.938 17.563l6.125-4.875 8.938 5.5-6.188 5.188zM9.813 2l6.188 5.188-8.938 5.5L.938 7.75zm21.25 5.75l-6.125 4.938L16 7.188 22.188 2zM16 18.188l8.938-5.5 6.125 4.875-8.875 5.813zm0 1.125l6.25 5.125 2.625-1.688v1.938L16 30.001l-8.875-5.313V22.75l2.688 1.688z',
	    'css3' => 'M31.063 2.375H5.438l-1 5.063h20.563l-.625 3.25H3.751l-1 5.063h20.563l-1.125 5.75-8.313 2.75-7.188-2.75.5-2.5H2.125L.937 25.064l11.875 4.563L26.5 25.064z',
	    'rss' => 'M18.75 26.375c0-7.125-5.875-12.938-13.125-12.938v1.875c6.188 0 11.25 4.938 11.25 11.063h1.875zM5.625 6.563c11.125 0 19.813 8.688 19.813 19.813H23.5c0-10.063-7.813-17.875-17.875-17.875V6.563zm5.688 17c0 1.5-1.313 2.813-2.813 2.813-1.563 0-2.875-1.313-2.875-2.813 0-1.563 1.313-2.875 2.875-2.875 1.5 0 2.813 1.313 2.813 2.875zm-1.875 0c0-.563-.438-1-.938-1-.563 0-1 .438-1 1 0 .5.438.938 1 .938.5 0 .938-.438.938-.938zM32 29.188c0 1.563-1.25 2.813-2.813 2.813H2.812c-1.563 0-2.813-1.25-2.813-2.813V2.813C-.001 1.25 1.249 0 2.812 0h26.375C30.75 0 32 1.25 32 2.813v26.375zM29.188 1.875H2.813c-.5 0-.938.438-.938.938v26.375c0 .5.438.938.938.938h26.375c.5 0 .938-.438.938-.938V2.813c0-.5-.438-.938-.938-.938z',
	    'rss-alt' => 'M21.063 32c0-11.438-9.438-20.688-21.063-20.688v1.875c10.563 0 19.125 8.438 19.125 18.813h1.938zM0 0c17.938 0 32 14.063 32 32h-1.875C30.125 15.125 16.875 1.875 0 1.875V0zm7.5 28.25C7.5 30.313 5.812 32 3.75 32S0 30.312 0 28.25s1.688-3.75 3.75-3.75 3.75 1.688 3.75 3.75zm-1.875 0c0-1.063-.813-1.875-1.875-1.875-1 0-1.875.813-1.875 1.875 0 1 .875 1.875 1.875 1.875 1.063 0 1.875-.875 1.875-1.875z'
	);
    }

}

new Themify_Icon_Themify();
